# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BotVersion

class Bot(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Bot - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'provider': 'str',
            'versions': 'list[BotVersion]',
            'bot_composite_tag': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'provider': 'provider',
            'versions': 'versions',
            'bot_composite_tag': 'botCompositeTag',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._provider = None
        self._versions = None
        self._bot_composite_tag = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this Bot.
        This is a string type that should denote a unique ID of the bot for calling purposes by the Genesys service (EG a UUID).

        :return: The id of this Bot.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this Bot.
        This is a string type that should denote a unique ID of the bot for calling purposes by the Genesys service (EG a UUID).

        :param id: The id of this Bot.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this Bot.
        This is the name that will be displayed to the user in Architect.

        :return: The name of this Bot.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this Bot.
        This is the name that will be displayed to the user in Architect.

        :param name: The name of this Bot.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this Bot.
        An optional description of the bot.

        :return: The description of this Bot.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this Bot.
        An optional description of the bot.

        :param description: The description of this Bot.
        :type: str
        """
        

        self._description = description

    @property
    def provider(self) -> str:
        """
        Gets the provider of this Bot.
        The provider of the bot.

        :return: The provider of this Bot.
        :rtype: str
        """
        return self._provider

    @provider.setter
    def provider(self, provider: str) -> None:
        """
        Sets the provider of this Bot.
        The provider of the bot.

        :param provider: The provider of this Bot.
        :type: str
        """
        

        self._provider = provider

    @property
    def versions(self) -> List['BotVersion']:
        """
        Gets the versions of this Bot.
        This bots version.

        :return: The versions of this Bot.
        :rtype: list[BotVersion]
        """
        return self._versions

    @versions.setter
    def versions(self, versions: List['BotVersion']) -> None:
        """
        Sets the versions of this Bot.
        This bots version.

        :param versions: The versions of this Bot.
        :type: list[BotVersion]
        """
        

        self._versions = versions

    @property
    def bot_composite_tag(self) -> str:
        """
        Gets the bot_composite_tag of this Bot.
        A system-generated string that contains metadata about this bot.

        :return: The bot_composite_tag of this Bot.
        :rtype: str
        """
        return self._bot_composite_tag

    @bot_composite_tag.setter
    def bot_composite_tag(self, bot_composite_tag: str) -> None:
        """
        Sets the bot_composite_tag of this Bot.
        A system-generated string that contains metadata about this bot.

        :param bot_composite_tag: The bot_composite_tag of this Bot.
        :type: str
        """
        

        self._bot_composite_tag = bot_composite_tag

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this Bot.
        The URI for this object

        :return: The self_uri of this Bot.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this Bot.
        The URI for this object

        :param self_uri: The self_uri of this Bot.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

