# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import NuanceBotCredentials

class BotExecutionConfiguration(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BotExecutionConfiguration - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'bot_id': 'str',
            'execution_host': 'str',
            'bot_credentials': 'NuanceBotCredentials'
        }

        self.attribute_map = {
            'bot_id': 'botId',
            'execution_host': 'executionHost',
            'bot_credentials': 'botCredentials'
        }

        self._bot_id = None
        self._execution_host = None
        self._bot_credentials = None

    @property
    def bot_id(self) -> str:
        """
        Gets the bot_id of this BotExecutionConfiguration.
        The Nuance bot ID

        :return: The bot_id of this BotExecutionConfiguration.
        :rtype: str
        """
        return self._bot_id

    @bot_id.setter
    def bot_id(self, bot_id: str) -> None:
        """
        Sets the bot_id of this BotExecutionConfiguration.
        The Nuance bot ID

        :param bot_id: The bot_id of this BotExecutionConfiguration.
        :type: str
        """
        

        self._bot_id = bot_id

    @property
    def execution_host(self) -> str:
        """
        Gets the execution_host of this BotExecutionConfiguration.
        The hostname to use when contacting Nuance to execute this bot

        :return: The execution_host of this BotExecutionConfiguration.
        :rtype: str
        """
        return self._execution_host

    @execution_host.setter
    def execution_host(self, execution_host: str) -> None:
        """
        Sets the execution_host of this BotExecutionConfiguration.
        The hostname to use when contacting Nuance to execute this bot

        :param execution_host: The execution_host of this BotExecutionConfiguration.
        :type: str
        """
        

        self._execution_host = execution_host

    @property
    def bot_credentials(self) -> 'NuanceBotCredentials':
        """
        Gets the bot_credentials of this BotExecutionConfiguration.
        The bot's launch credentials

        :return: The bot_credentials of this BotExecutionConfiguration.
        :rtype: NuanceBotCredentials
        """
        return self._bot_credentials

    @bot_credentials.setter
    def bot_credentials(self, bot_credentials: 'NuanceBotCredentials') -> None:
        """
        Sets the bot_credentials of this BotExecutionConfiguration.
        The bot's launch credentials

        :param bot_credentials: The bot_credentials of this BotExecutionConfiguration.
        :type: NuanceBotCredentials
        """
        

        self._bot_credentials = bot_credentials

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

