# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class BuAgentScheduleHistoryDeletedChange(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BuAgentScheduleHistoryDeletedChange - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'shift_ids': 'list[str]',
            'full_day_time_off_marker_dates': 'list[date]',
            'agent_schedule': 'bool'
        }

        self.attribute_map = {
            'shift_ids': 'shiftIds',
            'full_day_time_off_marker_dates': 'fullDayTimeOffMarkerDates',
            'agent_schedule': 'agentSchedule'
        }

        self._shift_ids = None
        self._full_day_time_off_marker_dates = None
        self._agent_schedule = None

    @property
    def shift_ids(self) -> List[str]:
        """
        Gets the shift_ids of this BuAgentScheduleHistoryDeletedChange.
        The IDs of deleted shifts

        :return: The shift_ids of this BuAgentScheduleHistoryDeletedChange.
        :rtype: list[str]
        """
        return self._shift_ids

    @shift_ids.setter
    def shift_ids(self, shift_ids: List[str]) -> None:
        """
        Sets the shift_ids of this BuAgentScheduleHistoryDeletedChange.
        The IDs of deleted shifts

        :param shift_ids: The shift_ids of this BuAgentScheduleHistoryDeletedChange.
        :type: list[str]
        """
        

        self._shift_ids = shift_ids

    @property
    def full_day_time_off_marker_dates(self) -> List[date]:
        """
        Gets the full_day_time_off_marker_dates of this BuAgentScheduleHistoryDeletedChange.
        The dates of any deleted full day time off markers

        :return: The full_day_time_off_marker_dates of this BuAgentScheduleHistoryDeletedChange.
        :rtype: list[date]
        """
        return self._full_day_time_off_marker_dates

    @full_day_time_off_marker_dates.setter
    def full_day_time_off_marker_dates(self, full_day_time_off_marker_dates: List[date]) -> None:
        """
        Sets the full_day_time_off_marker_dates of this BuAgentScheduleHistoryDeletedChange.
        The dates of any deleted full day time off markers

        :param full_day_time_off_marker_dates: The full_day_time_off_marker_dates of this BuAgentScheduleHistoryDeletedChange.
        :type: list[date]
        """
        

        self._full_day_time_off_marker_dates = full_day_time_off_marker_dates

    @property
    def agent_schedule(self) -> bool:
        """
        Gets the agent_schedule of this BuAgentScheduleHistoryDeletedChange.
        Whether the entire agent schedule was deleted

        :return: The agent_schedule of this BuAgentScheduleHistoryDeletedChange.
        :rtype: bool
        """
        return self._agent_schedule

    @agent_schedule.setter
    def agent_schedule(self, agent_schedule: bool) -> None:
        """
        Sets the agent_schedule of this BuAgentScheduleHistoryDeletedChange.
        Whether the entire agent schedule was deleted

        :param agent_schedule: The agent_schedule of this BuAgentScheduleHistoryDeletedChange.
        :type: bool
        """
        

        self._agent_schedule = agent_schedule

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

