# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BuAgentScheduleHistoryChange
    from . import BuAgentScheduleHistoryDroppedChange
    from . import BuScheduleReference

class BuAgentScheduleHistoryResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BuAgentScheduleHistoryResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'prior_published_schedules': 'list[BuScheduleReference]',
            'base_published_schedule': 'BuAgentScheduleHistoryChange',
            'dropped_changes': 'list[BuAgentScheduleHistoryDroppedChange]',
            'changes': 'list[BuAgentScheduleHistoryChange]'
        }

        self.attribute_map = {
            'prior_published_schedules': 'priorPublishedSchedules',
            'base_published_schedule': 'basePublishedSchedule',
            'dropped_changes': 'droppedChanges',
            'changes': 'changes'
        }

        self._prior_published_schedules = None
        self._base_published_schedule = None
        self._dropped_changes = None
        self._changes = None

    @property
    def prior_published_schedules(self) -> List['BuScheduleReference']:
        """
        Gets the prior_published_schedules of this BuAgentScheduleHistoryResponse.
        The list of previously published schedules

        :return: The prior_published_schedules of this BuAgentScheduleHistoryResponse.
        :rtype: list[BuScheduleReference]
        """
        return self._prior_published_schedules

    @prior_published_schedules.setter
    def prior_published_schedules(self, prior_published_schedules: List['BuScheduleReference']) -> None:
        """
        Sets the prior_published_schedules of this BuAgentScheduleHistoryResponse.
        The list of previously published schedules

        :param prior_published_schedules: The prior_published_schedules of this BuAgentScheduleHistoryResponse.
        :type: list[BuScheduleReference]
        """
        

        self._prior_published_schedules = prior_published_schedules

    @property
    def base_published_schedule(self) -> 'BuAgentScheduleHistoryChange':
        """
        Gets the base_published_schedule of this BuAgentScheduleHistoryResponse.
        The originally published agent schedules

        :return: The base_published_schedule of this BuAgentScheduleHistoryResponse.
        :rtype: BuAgentScheduleHistoryChange
        """
        return self._base_published_schedule

    @base_published_schedule.setter
    def base_published_schedule(self, base_published_schedule: 'BuAgentScheduleHistoryChange') -> None:
        """
        Sets the base_published_schedule of this BuAgentScheduleHistoryResponse.
        The originally published agent schedules

        :param base_published_schedule: The base_published_schedule of this BuAgentScheduleHistoryResponse.
        :type: BuAgentScheduleHistoryChange
        """
        

        self._base_published_schedule = base_published_schedule

    @property
    def dropped_changes(self) -> List['BuAgentScheduleHistoryDroppedChange']:
        """
        Gets the dropped_changes of this BuAgentScheduleHistoryResponse.
        The changes dropped from the schedule history. This will happen if the schedule history is too large

        :return: The dropped_changes of this BuAgentScheduleHistoryResponse.
        :rtype: list[BuAgentScheduleHistoryDroppedChange]
        """
        return self._dropped_changes

    @dropped_changes.setter
    def dropped_changes(self, dropped_changes: List['BuAgentScheduleHistoryDroppedChange']) -> None:
        """
        Sets the dropped_changes of this BuAgentScheduleHistoryResponse.
        The changes dropped from the schedule history. This will happen if the schedule history is too large

        :param dropped_changes: The dropped_changes of this BuAgentScheduleHistoryResponse.
        :type: list[BuAgentScheduleHistoryDroppedChange]
        """
        

        self._dropped_changes = dropped_changes

    @property
    def changes(self) -> List['BuAgentScheduleHistoryChange']:
        """
        Gets the changes of this BuAgentScheduleHistoryResponse.
        The list of changes for the schedule history

        :return: The changes of this BuAgentScheduleHistoryResponse.
        :rtype: list[BuAgentScheduleHistoryChange]
        """
        return self._changes

    @changes.setter
    def changes(self, changes: List['BuAgentScheduleHistoryChange']) -> None:
        """
        Sets the changes of this BuAgentScheduleHistoryResponse.
        The list of changes for the schedule history

        :param changes: The changes of this BuAgentScheduleHistoryResponse.
        :type: list[BuAgentScheduleHistoryChange]
        """
        

        self._changes = changes

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

