# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class BuRescheduleRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BuRescheduleRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'start_date': 'datetime',
            'end_date': 'datetime',
            'agent_ids': 'list[str]',
            'activity_code_ids': 'list[str]',
            'management_unit_ids': 'list[str]',
            'do_not_change_weekly_paid_time': 'bool',
            'do_not_change_daily_paid_time': 'bool',
            'do_not_change_shift_start_times': 'bool',
            'do_not_change_manually_edited_shifts': 'bool',
            'activity_smoothing_type': 'str',
            'induce_schedule_variability': 'bool'
        }

        self.attribute_map = {
            'start_date': 'startDate',
            'end_date': 'endDate',
            'agent_ids': 'agentIds',
            'activity_code_ids': 'activityCodeIds',
            'management_unit_ids': 'managementUnitIds',
            'do_not_change_weekly_paid_time': 'doNotChangeWeeklyPaidTime',
            'do_not_change_daily_paid_time': 'doNotChangeDailyPaidTime',
            'do_not_change_shift_start_times': 'doNotChangeShiftStartTimes',
            'do_not_change_manually_edited_shifts': 'doNotChangeManuallyEditedShifts',
            'activity_smoothing_type': 'activitySmoothingType',
            'induce_schedule_variability': 'induceScheduleVariability'
        }

        self._start_date = None
        self._end_date = None
        self._agent_ids = None
        self._activity_code_ids = None
        self._management_unit_ids = None
        self._do_not_change_weekly_paid_time = None
        self._do_not_change_daily_paid_time = None
        self._do_not_change_shift_start_times = None
        self._do_not_change_manually_edited_shifts = None
        self._activity_smoothing_type = None
        self._induce_schedule_variability = None

    @property
    def start_date(self) -> datetime:
        """
        Gets the start_date of this BuRescheduleRequest.
        The start of the range to reschedule.  Defaults to the beginning of the schedule. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The start_date of this BuRescheduleRequest.
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date: datetime) -> None:
        """
        Sets the start_date of this BuRescheduleRequest.
        The start of the range to reschedule.  Defaults to the beginning of the schedule. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param start_date: The start_date of this BuRescheduleRequest.
        :type: datetime
        """
        

        self._start_date = start_date

    @property
    def end_date(self) -> datetime:
        """
        Gets the end_date of this BuRescheduleRequest.
        The end of the range to reschedule.  Defaults the the end of the schedule. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The end_date of this BuRescheduleRequest.
        :rtype: datetime
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date: datetime) -> None:
        """
        Sets the end_date of this BuRescheduleRequest.
        The end of the range to reschedule.  Defaults the the end of the schedule. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param end_date: The end_date of this BuRescheduleRequest.
        :type: datetime
        """
        

        self._end_date = end_date

    @property
    def agent_ids(self) -> List[str]:
        """
        Gets the agent_ids of this BuRescheduleRequest.
        The IDs of the agents to consider for rescheduling.  Omit to consider all agents in the specified management units.Agents not in the specified management units will be ignored

        :return: The agent_ids of this BuRescheduleRequest.
        :rtype: list[str]
        """
        return self._agent_ids

    @agent_ids.setter
    def agent_ids(self, agent_ids: List[str]) -> None:
        """
        Sets the agent_ids of this BuRescheduleRequest.
        The IDs of the agents to consider for rescheduling.  Omit to consider all agents in the specified management units.Agents not in the specified management units will be ignored

        :param agent_ids: The agent_ids of this BuRescheduleRequest.
        :type: list[str]
        """
        

        self._agent_ids = agent_ids

    @property
    def activity_code_ids(self) -> List[str]:
        """
        Gets the activity_code_ids of this BuRescheduleRequest.
        The IDs of the activity codes to consider for rescheduling.  Omit to consider all activity codes

        :return: The activity_code_ids of this BuRescheduleRequest.
        :rtype: list[str]
        """
        return self._activity_code_ids

    @activity_code_ids.setter
    def activity_code_ids(self, activity_code_ids: List[str]) -> None:
        """
        Sets the activity_code_ids of this BuRescheduleRequest.
        The IDs of the activity codes to consider for rescheduling.  Omit to consider all activity codes

        :param activity_code_ids: The activity_code_ids of this BuRescheduleRequest.
        :type: list[str]
        """
        

        self._activity_code_ids = activity_code_ids

    @property
    def management_unit_ids(self) -> List[str]:
        """
        Gets the management_unit_ids of this BuRescheduleRequest.
        The IDs of the management units to reschedule

        :return: The management_unit_ids of this BuRescheduleRequest.
        :rtype: list[str]
        """
        return self._management_unit_ids

    @management_unit_ids.setter
    def management_unit_ids(self, management_unit_ids: List[str]) -> None:
        """
        Sets the management_unit_ids of this BuRescheduleRequest.
        The IDs of the management units to reschedule

        :param management_unit_ids: The management_unit_ids of this BuRescheduleRequest.
        :type: list[str]
        """
        

        self._management_unit_ids = management_unit_ids

    @property
    def do_not_change_weekly_paid_time(self) -> bool:
        """
        Gets the do_not_change_weekly_paid_time of this BuRescheduleRequest.
        Instructs the scheduler whether it is allowed to change weekly paid time

        :return: The do_not_change_weekly_paid_time of this BuRescheduleRequest.
        :rtype: bool
        """
        return self._do_not_change_weekly_paid_time

    @do_not_change_weekly_paid_time.setter
    def do_not_change_weekly_paid_time(self, do_not_change_weekly_paid_time: bool) -> None:
        """
        Sets the do_not_change_weekly_paid_time of this BuRescheduleRequest.
        Instructs the scheduler whether it is allowed to change weekly paid time

        :param do_not_change_weekly_paid_time: The do_not_change_weekly_paid_time of this BuRescheduleRequest.
        :type: bool
        """
        

        self._do_not_change_weekly_paid_time = do_not_change_weekly_paid_time

    @property
    def do_not_change_daily_paid_time(self) -> bool:
        """
        Gets the do_not_change_daily_paid_time of this BuRescheduleRequest.
        Instructs the scheduler whether it is allowed to change daily paid time

        :return: The do_not_change_daily_paid_time of this BuRescheduleRequest.
        :rtype: bool
        """
        return self._do_not_change_daily_paid_time

    @do_not_change_daily_paid_time.setter
    def do_not_change_daily_paid_time(self, do_not_change_daily_paid_time: bool) -> None:
        """
        Sets the do_not_change_daily_paid_time of this BuRescheduleRequest.
        Instructs the scheduler whether it is allowed to change daily paid time

        :param do_not_change_daily_paid_time: The do_not_change_daily_paid_time of this BuRescheduleRequest.
        :type: bool
        """
        

        self._do_not_change_daily_paid_time = do_not_change_daily_paid_time

    @property
    def do_not_change_shift_start_times(self) -> bool:
        """
        Gets the do_not_change_shift_start_times of this BuRescheduleRequest.
        Instructs the scheduler whether it is allowed to change shift start times

        :return: The do_not_change_shift_start_times of this BuRescheduleRequest.
        :rtype: bool
        """
        return self._do_not_change_shift_start_times

    @do_not_change_shift_start_times.setter
    def do_not_change_shift_start_times(self, do_not_change_shift_start_times: bool) -> None:
        """
        Sets the do_not_change_shift_start_times of this BuRescheduleRequest.
        Instructs the scheduler whether it is allowed to change shift start times

        :param do_not_change_shift_start_times: The do_not_change_shift_start_times of this BuRescheduleRequest.
        :type: bool
        """
        

        self._do_not_change_shift_start_times = do_not_change_shift_start_times

    @property
    def do_not_change_manually_edited_shifts(self) -> bool:
        """
        Gets the do_not_change_manually_edited_shifts of this BuRescheduleRequest.
        Instructs the scheduler whether it is allowed to change manually edited shifts

        :return: The do_not_change_manually_edited_shifts of this BuRescheduleRequest.
        :rtype: bool
        """
        return self._do_not_change_manually_edited_shifts

    @do_not_change_manually_edited_shifts.setter
    def do_not_change_manually_edited_shifts(self, do_not_change_manually_edited_shifts: bool) -> None:
        """
        Sets the do_not_change_manually_edited_shifts of this BuRescheduleRequest.
        Instructs the scheduler whether it is allowed to change manually edited shifts

        :param do_not_change_manually_edited_shifts: The do_not_change_manually_edited_shifts of this BuRescheduleRequest.
        :type: bool
        """
        

        self._do_not_change_manually_edited_shifts = do_not_change_manually_edited_shifts

    @property
    def activity_smoothing_type(self) -> str:
        """
        Gets the activity_smoothing_type of this BuRescheduleRequest.
        Overrides the default BU level activity smoothing type for this reschedule run

        :return: The activity_smoothing_type of this BuRescheduleRequest.
        :rtype: str
        """
        return self._activity_smoothing_type

    @activity_smoothing_type.setter
    def activity_smoothing_type(self, activity_smoothing_type: str) -> None:
        """
        Sets the activity_smoothing_type of this BuRescheduleRequest.
        Overrides the default BU level activity smoothing type for this reschedule run

        :param activity_smoothing_type: The activity_smoothing_type of this BuRescheduleRequest.
        :type: str
        """
        if isinstance(activity_smoothing_type, int):
            activity_smoothing_type = str(activity_smoothing_type)
        allowed_values = ["ReduceConcurrentActivitiesAcrossBu", "ReduceConcurrentActivitiesAcrossMu", "ConsistentServiceLevel"]
        if activity_smoothing_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for activity_smoothing_type -> " + activity_smoothing_type)
            self._activity_smoothing_type = "outdated_sdk_version"
        else:
            self._activity_smoothing_type = activity_smoothing_type

    @property
    def induce_schedule_variability(self) -> bool:
        """
        Gets the induce_schedule_variability of this BuRescheduleRequest.
        Overrides the default BU level induce schedule variability setting for this reschedule run

        :return: The induce_schedule_variability of this BuRescheduleRequest.
        :rtype: bool
        """
        return self._induce_schedule_variability

    @induce_schedule_variability.setter
    def induce_schedule_variability(self, induce_schedule_variability: bool) -> None:
        """
        Sets the induce_schedule_variability of this BuRescheduleRequest.
        Overrides the default BU level induce schedule variability setting for this reschedule run

        :param induce_schedule_variability: The induce_schedule_variability of this BuRescheduleRequest.
        :type: bool
        """
        

        self._induce_schedule_variability = induce_schedule_variability

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

