# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import SchedulerMessageTypeSeverity
    from . import WfmServiceGoalImpactSettings

class BuSchedulingSettingsResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BuSchedulingSettingsResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'message_severities': 'list[SchedulerMessageTypeSeverity]',
            'sync_time_off_properties': 'list[str]',
            'service_goal_impact': 'WfmServiceGoalImpactSettings',
            'allow_work_plan_per_minute_granularity': 'bool',
            'activity_smoothing_type': 'str',
            'induce_schedule_variability': 'bool'
        }

        self.attribute_map = {
            'message_severities': 'messageSeverities',
            'sync_time_off_properties': 'syncTimeOffProperties',
            'service_goal_impact': 'serviceGoalImpact',
            'allow_work_plan_per_minute_granularity': 'allowWorkPlanPerMinuteGranularity',
            'activity_smoothing_type': 'activitySmoothingType',
            'induce_schedule_variability': 'induceScheduleVariability'
        }

        self._message_severities = None
        self._sync_time_off_properties = None
        self._service_goal_impact = None
        self._allow_work_plan_per_minute_granularity = None
        self._activity_smoothing_type = None
        self._induce_schedule_variability = None

    @property
    def message_severities(self) -> List['SchedulerMessageTypeSeverity']:
        """
        Gets the message_severities of this BuSchedulingSettingsResponse.
        Schedule generation message severity configuration

        :return: The message_severities of this BuSchedulingSettingsResponse.
        :rtype: list[SchedulerMessageTypeSeverity]
        """
        return self._message_severities

    @message_severities.setter
    def message_severities(self, message_severities: List['SchedulerMessageTypeSeverity']) -> None:
        """
        Sets the message_severities of this BuSchedulingSettingsResponse.
        Schedule generation message severity configuration

        :param message_severities: The message_severities of this BuSchedulingSettingsResponse.
        :type: list[SchedulerMessageTypeSeverity]
        """
        

        self._message_severities = message_severities

    @property
    def sync_time_off_properties(self) -> List[str]:
        """
        Gets the sync_time_off_properties of this BuSchedulingSettingsResponse.
        Synchronize set of time off properties from scheduled activities to time off requests when the schedule is published.

        :return: The sync_time_off_properties of this BuSchedulingSettingsResponse.
        :rtype: list[str]
        """
        return self._sync_time_off_properties

    @sync_time_off_properties.setter
    def sync_time_off_properties(self, sync_time_off_properties: List[str]) -> None:
        """
        Sets the sync_time_off_properties of this BuSchedulingSettingsResponse.
        Synchronize set of time off properties from scheduled activities to time off requests when the schedule is published.

        :param sync_time_off_properties: The sync_time_off_properties of this BuSchedulingSettingsResponse.
        :type: list[str]
        """
        

        self._sync_time_off_properties = sync_time_off_properties

    @property
    def service_goal_impact(self) -> 'WfmServiceGoalImpactSettings':
        """
        Gets the service_goal_impact of this BuSchedulingSettingsResponse.
        Configures the max percent increase and decrease of service goals for this business unit

        :return: The service_goal_impact of this BuSchedulingSettingsResponse.
        :rtype: WfmServiceGoalImpactSettings
        """
        return self._service_goal_impact

    @service_goal_impact.setter
    def service_goal_impact(self, service_goal_impact: 'WfmServiceGoalImpactSettings') -> None:
        """
        Sets the service_goal_impact of this BuSchedulingSettingsResponse.
        Configures the max percent increase and decrease of service goals for this business unit

        :param service_goal_impact: The service_goal_impact of this BuSchedulingSettingsResponse.
        :type: WfmServiceGoalImpactSettings
        """
        

        self._service_goal_impact = service_goal_impact

    @property
    def allow_work_plan_per_minute_granularity(self) -> bool:
        """
        Gets the allow_work_plan_per_minute_granularity of this BuSchedulingSettingsResponse.
        Indicates whether or not per minute granularity for scheduling will be enabled for this business unit. Defaults to false.

        :return: The allow_work_plan_per_minute_granularity of this BuSchedulingSettingsResponse.
        :rtype: bool
        """
        return self._allow_work_plan_per_minute_granularity

    @allow_work_plan_per_minute_granularity.setter
    def allow_work_plan_per_minute_granularity(self, allow_work_plan_per_minute_granularity: bool) -> None:
        """
        Sets the allow_work_plan_per_minute_granularity of this BuSchedulingSettingsResponse.
        Indicates whether or not per minute granularity for scheduling will be enabled for this business unit. Defaults to false.

        :param allow_work_plan_per_minute_granularity: The allow_work_plan_per_minute_granularity of this BuSchedulingSettingsResponse.
        :type: bool
        """
        

        self._allow_work_plan_per_minute_granularity = allow_work_plan_per_minute_granularity

    @property
    def activity_smoothing_type(self) -> str:
        """
        Gets the activity_smoothing_type of this BuSchedulingSettingsResponse.
        The activity smoothing type for schedule generation in this business unit

        :return: The activity_smoothing_type of this BuSchedulingSettingsResponse.
        :rtype: str
        """
        return self._activity_smoothing_type

    @activity_smoothing_type.setter
    def activity_smoothing_type(self, activity_smoothing_type: str) -> None:
        """
        Sets the activity_smoothing_type of this BuSchedulingSettingsResponse.
        The activity smoothing type for schedule generation in this business unit

        :param activity_smoothing_type: The activity_smoothing_type of this BuSchedulingSettingsResponse.
        :type: str
        """
        if isinstance(activity_smoothing_type, int):
            activity_smoothing_type = str(activity_smoothing_type)
        allowed_values = ["ReduceConcurrentActivitiesAcrossBu", "ReduceConcurrentActivitiesAcrossMu", "ConsistentServiceLevel"]
        if activity_smoothing_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for activity_smoothing_type -> " + activity_smoothing_type)
            self._activity_smoothing_type = "outdated_sdk_version"
        else:
            self._activity_smoothing_type = activity_smoothing_type

    @property
    def induce_schedule_variability(self) -> bool:
        """
        Gets the induce_schedule_variability of this BuSchedulingSettingsResponse.
        Indicates whether to provide variability in schedule generation

        :return: The induce_schedule_variability of this BuSchedulingSettingsResponse.
        :rtype: bool
        """
        return self._induce_schedule_variability

    @induce_schedule_variability.setter
    def induce_schedule_variability(self, induce_schedule_variability: bool) -> None:
        """
        Sets the induce_schedule_variability of this BuSchedulingSettingsResponse.
        Indicates whether to provide variability in schedule generation

        :param induce_schedule_variability: The induce_schedule_variability of this BuSchedulingSettingsResponse.
        :type: bool
        """
        

        self._induce_schedule_variability = induce_schedule_variability

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

