# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import CallHistoryParticipant

class CallHistoryConversation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CallHistoryConversation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'participants': 'list[CallHistoryParticipant]',
            'direction': 'str',
            'went_to_voicemail': 'bool',
            'missed_call': 'bool',
            'start_time': 'datetime',
            'was_conference': 'bool',
            'was_callback': 'bool',
            'had_screen_share': 'bool',
            'had_cobrowse': 'bool',
            'was_outbound_campaign': 'bool',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'participants': 'participants',
            'direction': 'direction',
            'went_to_voicemail': 'wentToVoicemail',
            'missed_call': 'missedCall',
            'start_time': 'startTime',
            'was_conference': 'wasConference',
            'was_callback': 'wasCallback',
            'had_screen_share': 'hadScreenShare',
            'had_cobrowse': 'hadCobrowse',
            'was_outbound_campaign': 'wasOutboundCampaign',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._participants = None
        self._direction = None
        self._went_to_voicemail = None
        self._missed_call = None
        self._start_time = None
        self._was_conference = None
        self._was_callback = None
        self._had_screen_share = None
        self._had_cobrowse = None
        self._was_outbound_campaign = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this CallHistoryConversation.
        The globally unique identifier for the object.

        :return: The id of this CallHistoryConversation.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this CallHistoryConversation.
        The globally unique identifier for the object.

        :param id: The id of this CallHistoryConversation.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this CallHistoryConversation.


        :return: The name of this CallHistoryConversation.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this CallHistoryConversation.


        :param name: The name of this CallHistoryConversation.
        :type: str
        """
        

        self._name = name

    @property
    def participants(self) -> List['CallHistoryParticipant']:
        """
        Gets the participants of this CallHistoryConversation.
        The list of participants involved in the conversation.

        :return: The participants of this CallHistoryConversation.
        :rtype: list[CallHistoryParticipant]
        """
        return self._participants

    @participants.setter
    def participants(self, participants: List['CallHistoryParticipant']) -> None:
        """
        Sets the participants of this CallHistoryConversation.
        The list of participants involved in the conversation.

        :param participants: The participants of this CallHistoryConversation.
        :type: list[CallHistoryParticipant]
        """
        

        self._participants = participants

    @property
    def direction(self) -> str:
        """
        Gets the direction of this CallHistoryConversation.
        The direction of the call relating to the current user

        :return: The direction of this CallHistoryConversation.
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction: str) -> None:
        """
        Sets the direction of this CallHistoryConversation.
        The direction of the call relating to the current user

        :param direction: The direction of this CallHistoryConversation.
        :type: str
        """
        if isinstance(direction, int):
            direction = str(direction)
        allowed_values = ["inbound", "outbound"]
        if direction.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for direction -> " + direction)
            self._direction = "outdated_sdk_version"
        else:
            self._direction = direction

    @property
    def went_to_voicemail(self) -> bool:
        """
        Gets the went_to_voicemail of this CallHistoryConversation.
        Did the call end in the current user's voicemail

        :return: The went_to_voicemail of this CallHistoryConversation.
        :rtype: bool
        """
        return self._went_to_voicemail

    @went_to_voicemail.setter
    def went_to_voicemail(self, went_to_voicemail: bool) -> None:
        """
        Sets the went_to_voicemail of this CallHistoryConversation.
        Did the call end in the current user's voicemail

        :param went_to_voicemail: The went_to_voicemail of this CallHistoryConversation.
        :type: bool
        """
        

        self._went_to_voicemail = went_to_voicemail

    @property
    def missed_call(self) -> bool:
        """
        Gets the missed_call of this CallHistoryConversation.
        Did the user not answer this conversation

        :return: The missed_call of this CallHistoryConversation.
        :rtype: bool
        """
        return self._missed_call

    @missed_call.setter
    def missed_call(self, missed_call: bool) -> None:
        """
        Sets the missed_call of this CallHistoryConversation.
        Did the user not answer this conversation

        :param missed_call: The missed_call of this CallHistoryConversation.
        :type: bool
        """
        

        self._missed_call = missed_call

    @property
    def start_time(self) -> datetime:
        """
        Gets the start_time of this CallHistoryConversation.
        The time the user joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The start_time of this CallHistoryConversation.
        :rtype: datetime
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time: datetime) -> None:
        """
        Sets the start_time of this CallHistoryConversation.
        The time the user joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param start_time: The start_time of this CallHistoryConversation.
        :type: datetime
        """
        

        self._start_time = start_time

    @property
    def was_conference(self) -> bool:
        """
        Gets the was_conference of this CallHistoryConversation.
        Was this conversation a conference

        :return: The was_conference of this CallHistoryConversation.
        :rtype: bool
        """
        return self._was_conference

    @was_conference.setter
    def was_conference(self, was_conference: bool) -> None:
        """
        Sets the was_conference of this CallHistoryConversation.
        Was this conversation a conference

        :param was_conference: The was_conference of this CallHistoryConversation.
        :type: bool
        """
        

        self._was_conference = was_conference

    @property
    def was_callback(self) -> bool:
        """
        Gets the was_callback of this CallHistoryConversation.
        Was this conversation a callback

        :return: The was_callback of this CallHistoryConversation.
        :rtype: bool
        """
        return self._was_callback

    @was_callback.setter
    def was_callback(self, was_callback: bool) -> None:
        """
        Sets the was_callback of this CallHistoryConversation.
        Was this conversation a callback

        :param was_callback: The was_callback of this CallHistoryConversation.
        :type: bool
        """
        

        self._was_callback = was_callback

    @property
    def had_screen_share(self) -> bool:
        """
        Gets the had_screen_share of this CallHistoryConversation.
        Did this conversation have a screen share session

        :return: The had_screen_share of this CallHistoryConversation.
        :rtype: bool
        """
        return self._had_screen_share

    @had_screen_share.setter
    def had_screen_share(self, had_screen_share: bool) -> None:
        """
        Sets the had_screen_share of this CallHistoryConversation.
        Did this conversation have a screen share session

        :param had_screen_share: The had_screen_share of this CallHistoryConversation.
        :type: bool
        """
        

        self._had_screen_share = had_screen_share

    @property
    def had_cobrowse(self) -> bool:
        """
        Gets the had_cobrowse of this CallHistoryConversation.
        Did this conversation have a cobrowse session

        :return: The had_cobrowse of this CallHistoryConversation.
        :rtype: bool
        """
        return self._had_cobrowse

    @had_cobrowse.setter
    def had_cobrowse(self, had_cobrowse: bool) -> None:
        """
        Sets the had_cobrowse of this CallHistoryConversation.
        Did this conversation have a cobrowse session

        :param had_cobrowse: The had_cobrowse of this CallHistoryConversation.
        :type: bool
        """
        

        self._had_cobrowse = had_cobrowse

    @property
    def was_outbound_campaign(self) -> bool:
        """
        Gets the was_outbound_campaign of this CallHistoryConversation.
        Was this conversation associated with an outbound campaign

        :return: The was_outbound_campaign of this CallHistoryConversation.
        :rtype: bool
        """
        return self._was_outbound_campaign

    @was_outbound_campaign.setter
    def was_outbound_campaign(self, was_outbound_campaign: bool) -> None:
        """
        Sets the was_outbound_campaign of this CallHistoryConversation.
        Was this conversation associated with an outbound campaign

        :param was_outbound_campaign: The was_outbound_campaign of this CallHistoryConversation.
        :type: bool
        """
        

        self._was_outbound_campaign = was_outbound_campaign

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this CallHistoryConversation.
        The URI for this object

        :return: The self_uri of this CallHistoryConversation.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this CallHistoryConversation.
        The URI for this object

        :param self_uri: The self_uri of this CallHistoryConversation.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

