# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AfterCallWork
    from . import ConversationQueueMediaSettings
    from . import DialerPreview
    from . import Segment
    from . import Voicemail
    from . import Wrapup

class Callback(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Callback - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'state': 'str',
            'initial_state': 'str',
            'id': 'str',
            'segments': 'list[Segment]',
            'direction': 'str',
            'held': 'bool',
            'disconnect_type': 'str',
            'start_hold_time': 'datetime',
            'dialer_preview': 'DialerPreview',
            'voicemail': 'Voicemail',
            'callback_numbers': 'list[str]',
            'callback_user_name': 'str',
            'script_id': 'str',
            'external_campaign': 'bool',
            'skip_enabled': 'bool',
            'timeout_seconds': 'int',
            'start_alerting_time': 'datetime',
            'connected_time': 'datetime',
            'disconnected_time': 'datetime',
            'callback_scheduled_time': 'datetime',
            'automated_callback_config_id': 'str',
            'provider': 'str',
            'peer_id': 'str',
            'wrapup': 'Wrapup',
            'after_call_work': 'AfterCallWork',
            'after_call_work_required': 'bool',
            'caller_id': 'str',
            'caller_id_name': 'str',
            'queue_media_settings': 'ConversationQueueMediaSettings'
        }

        self.attribute_map = {
            'state': 'state',
            'initial_state': 'initialState',
            'id': 'id',
            'segments': 'segments',
            'direction': 'direction',
            'held': 'held',
            'disconnect_type': 'disconnectType',
            'start_hold_time': 'startHoldTime',
            'dialer_preview': 'dialerPreview',
            'voicemail': 'voicemail',
            'callback_numbers': 'callbackNumbers',
            'callback_user_name': 'callbackUserName',
            'script_id': 'scriptId',
            'external_campaign': 'externalCampaign',
            'skip_enabled': 'skipEnabled',
            'timeout_seconds': 'timeoutSeconds',
            'start_alerting_time': 'startAlertingTime',
            'connected_time': 'connectedTime',
            'disconnected_time': 'disconnectedTime',
            'callback_scheduled_time': 'callbackScheduledTime',
            'automated_callback_config_id': 'automatedCallbackConfigId',
            'provider': 'provider',
            'peer_id': 'peerId',
            'wrapup': 'wrapup',
            'after_call_work': 'afterCallWork',
            'after_call_work_required': 'afterCallWorkRequired',
            'caller_id': 'callerId',
            'caller_id_name': 'callerIdName',
            'queue_media_settings': 'queueMediaSettings'
        }

        self._state = None
        self._initial_state = None
        self._id = None
        self._segments = None
        self._direction = None
        self._held = None
        self._disconnect_type = None
        self._start_hold_time = None
        self._dialer_preview = None
        self._voicemail = None
        self._callback_numbers = None
        self._callback_user_name = None
        self._script_id = None
        self._external_campaign = None
        self._skip_enabled = None
        self._timeout_seconds = None
        self._start_alerting_time = None
        self._connected_time = None
        self._disconnected_time = None
        self._callback_scheduled_time = None
        self._automated_callback_config_id = None
        self._provider = None
        self._peer_id = None
        self._wrapup = None
        self._after_call_work = None
        self._after_call_work_required = None
        self._caller_id = None
        self._caller_id_name = None
        self._queue_media_settings = None

    @property
    def state(self) -> str:
        """
        Gets the state of this Callback.
        The connection state of this communication.

        :return: The state of this Callback.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this Callback.
        The connection state of this communication.

        :param state: The state of this Callback.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "scheduled", "none"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def initial_state(self) -> str:
        """
        Gets the initial_state of this Callback.
        The initial connection state of this communication.

        :return: The initial_state of this Callback.
        :rtype: str
        """
        return self._initial_state

    @initial_state.setter
    def initial_state(self, initial_state: str) -> None:
        """
        Sets the initial_state of this Callback.
        The initial connection state of this communication.

        :param initial_state: The initial_state of this Callback.
        :type: str
        """
        if isinstance(initial_state, int):
            initial_state = str(initial_state)
        allowed_values = ["alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "scheduled", "none"]
        if initial_state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for initial_state -> " + initial_state)
            self._initial_state = "outdated_sdk_version"
        else:
            self._initial_state = initial_state

    @property
    def id(self) -> str:
        """
        Gets the id of this Callback.
        A globally unique identifier for this communication.

        :return: The id of this Callback.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this Callback.
        A globally unique identifier for this communication.

        :param id: The id of this Callback.
        :type: str
        """
        

        self._id = id

    @property
    def segments(self) -> List['Segment']:
        """
        Gets the segments of this Callback.
        The time line of the participant's callback, divided into activity segments.

        :return: The segments of this Callback.
        :rtype: list[Segment]
        """
        return self._segments

    @segments.setter
    def segments(self, segments: List['Segment']) -> None:
        """
        Sets the segments of this Callback.
        The time line of the participant's callback, divided into activity segments.

        :param segments: The segments of this Callback.
        :type: list[Segment]
        """
        

        self._segments = segments

    @property
    def direction(self) -> str:
        """
        Gets the direction of this Callback.
        The direction of the call

        :return: The direction of this Callback.
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction: str) -> None:
        """
        Sets the direction of this Callback.
        The direction of the call

        :param direction: The direction of this Callback.
        :type: str
        """
        if isinstance(direction, int):
            direction = str(direction)
        allowed_values = ["inbound", "outbound"]
        if direction.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for direction -> " + direction)
            self._direction = "outdated_sdk_version"
        else:
            self._direction = direction

    @property
    def held(self) -> bool:
        """
        Gets the held of this Callback.
        True if this call is held and the person on this side hears silence.

        :return: The held of this Callback.
        :rtype: bool
        """
        return self._held

    @held.setter
    def held(self, held: bool) -> None:
        """
        Sets the held of this Callback.
        True if this call is held and the person on this side hears silence.

        :param held: The held of this Callback.
        :type: bool
        """
        

        self._held = held

    @property
    def disconnect_type(self) -> str:
        """
        Gets the disconnect_type of this Callback.
        System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.

        :return: The disconnect_type of this Callback.
        :rtype: str
        """
        return self._disconnect_type

    @disconnect_type.setter
    def disconnect_type(self, disconnect_type: str) -> None:
        """
        Sets the disconnect_type of this Callback.
        System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.

        :param disconnect_type: The disconnect_type of this Callback.
        :type: str
        """
        if isinstance(disconnect_type, int):
            disconnect_type = str(disconnect_type)
        allowed_values = ["endpoint", "client", "system", "timeout", "transfer", "transfer.conference", "transfer.consult", "transfer.forward", "transfer.noanswer", "transfer.notavailable", "transport.failure", "error", "peer", "other", "spam", "uncallable"]
        if disconnect_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for disconnect_type -> " + disconnect_type)
            self._disconnect_type = "outdated_sdk_version"
        else:
            self._disconnect_type = disconnect_type

    @property
    def start_hold_time(self) -> datetime:
        """
        Gets the start_hold_time of this Callback.
        The timestamp the callback was placed on hold in the cloud clock if the callback is currently on hold. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The start_hold_time of this Callback.
        :rtype: datetime
        """
        return self._start_hold_time

    @start_hold_time.setter
    def start_hold_time(self, start_hold_time: datetime) -> None:
        """
        Sets the start_hold_time of this Callback.
        The timestamp the callback was placed on hold in the cloud clock if the callback is currently on hold. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param start_hold_time: The start_hold_time of this Callback.
        :type: datetime
        """
        

        self._start_hold_time = start_hold_time

    @property
    def dialer_preview(self) -> 'DialerPreview':
        """
        Gets the dialer_preview of this Callback.
        The preview data to be used when this callback is a Preview.

        :return: The dialer_preview of this Callback.
        :rtype: DialerPreview
        """
        return self._dialer_preview

    @dialer_preview.setter
    def dialer_preview(self, dialer_preview: 'DialerPreview') -> None:
        """
        Sets the dialer_preview of this Callback.
        The preview data to be used when this callback is a Preview.

        :param dialer_preview: The dialer_preview of this Callback.
        :type: DialerPreview
        """
        

        self._dialer_preview = dialer_preview

    @property
    def voicemail(self) -> 'Voicemail':
        """
        Gets the voicemail of this Callback.
        The voicemail data to be used when this callback is an ACD voicemail.

        :return: The voicemail of this Callback.
        :rtype: Voicemail
        """
        return self._voicemail

    @voicemail.setter
    def voicemail(self, voicemail: 'Voicemail') -> None:
        """
        Sets the voicemail of this Callback.
        The voicemail data to be used when this callback is an ACD voicemail.

        :param voicemail: The voicemail of this Callback.
        :type: Voicemail
        """
        

        self._voicemail = voicemail

    @property
    def callback_numbers(self) -> List[str]:
        """
        Gets the callback_numbers of this Callback.
        The phone number(s) to use to place the callback.

        :return: The callback_numbers of this Callback.
        :rtype: list[str]
        """
        return self._callback_numbers

    @callback_numbers.setter
    def callback_numbers(self, callback_numbers: List[str]) -> None:
        """
        Sets the callback_numbers of this Callback.
        The phone number(s) to use to place the callback.

        :param callback_numbers: The callback_numbers of this Callback.
        :type: list[str]
        """
        

        self._callback_numbers = callback_numbers

    @property
    def callback_user_name(self) -> str:
        """
        Gets the callback_user_name of this Callback.
        The name of the user requesting a callback.

        :return: The callback_user_name of this Callback.
        :rtype: str
        """
        return self._callback_user_name

    @callback_user_name.setter
    def callback_user_name(self, callback_user_name: str) -> None:
        """
        Sets the callback_user_name of this Callback.
        The name of the user requesting a callback.

        :param callback_user_name: The callback_user_name of this Callback.
        :type: str
        """
        

        self._callback_user_name = callback_user_name

    @property
    def script_id(self) -> str:
        """
        Gets the script_id of this Callback.
        The UUID of the script to use.

        :return: The script_id of this Callback.
        :rtype: str
        """
        return self._script_id

    @script_id.setter
    def script_id(self, script_id: str) -> None:
        """
        Sets the script_id of this Callback.
        The UUID of the script to use.

        :param script_id: The script_id of this Callback.
        :type: str
        """
        

        self._script_id = script_id

    @property
    def external_campaign(self) -> bool:
        """
        Gets the external_campaign of this Callback.
        True if the call for the callback uses external dialing.

        :return: The external_campaign of this Callback.
        :rtype: bool
        """
        return self._external_campaign

    @external_campaign.setter
    def external_campaign(self, external_campaign: bool) -> None:
        """
        Sets the external_campaign of this Callback.
        True if the call for the callback uses external dialing.

        :param external_campaign: The external_campaign of this Callback.
        :type: bool
        """
        

        self._external_campaign = external_campaign

    @property
    def skip_enabled(self) -> bool:
        """
        Gets the skip_enabled of this Callback.
        True if the ability to skip a callback should be enabled.

        :return: The skip_enabled of this Callback.
        :rtype: bool
        """
        return self._skip_enabled

    @skip_enabled.setter
    def skip_enabled(self, skip_enabled: bool) -> None:
        """
        Sets the skip_enabled of this Callback.
        True if the ability to skip a callback should be enabled.

        :param skip_enabled: The skip_enabled of this Callback.
        :type: bool
        """
        

        self._skip_enabled = skip_enabled

    @property
    def timeout_seconds(self) -> int:
        """
        Gets the timeout_seconds of this Callback.
        The number of seconds before the system automatically places a call for a callback.  0 means the automatic placement is disabled.

        :return: The timeout_seconds of this Callback.
        :rtype: int
        """
        return self._timeout_seconds

    @timeout_seconds.setter
    def timeout_seconds(self, timeout_seconds: int) -> None:
        """
        Sets the timeout_seconds of this Callback.
        The number of seconds before the system automatically places a call for a callback.  0 means the automatic placement is disabled.

        :param timeout_seconds: The timeout_seconds of this Callback.
        :type: int
        """
        

        self._timeout_seconds = timeout_seconds

    @property
    def start_alerting_time(self) -> datetime:
        """
        Gets the start_alerting_time of this Callback.
        The timestamp the communication has when it is first put into an alerting state. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The start_alerting_time of this Callback.
        :rtype: datetime
        """
        return self._start_alerting_time

    @start_alerting_time.setter
    def start_alerting_time(self, start_alerting_time: datetime) -> None:
        """
        Sets the start_alerting_time of this Callback.
        The timestamp the communication has when it is first put into an alerting state. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param start_alerting_time: The start_alerting_time of this Callback.
        :type: datetime
        """
        

        self._start_alerting_time = start_alerting_time

    @property
    def connected_time(self) -> datetime:
        """
        Gets the connected_time of this Callback.
        The timestamp when this communication was connected in the cloud clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The connected_time of this Callback.
        :rtype: datetime
        """
        return self._connected_time

    @connected_time.setter
    def connected_time(self, connected_time: datetime) -> None:
        """
        Sets the connected_time of this Callback.
        The timestamp when this communication was connected in the cloud clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param connected_time: The connected_time of this Callback.
        :type: datetime
        """
        

        self._connected_time = connected_time

    @property
    def disconnected_time(self) -> datetime:
        """
        Gets the disconnected_time of this Callback.
        The timestamp when this communication disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The disconnected_time of this Callback.
        :rtype: datetime
        """
        return self._disconnected_time

    @disconnected_time.setter
    def disconnected_time(self, disconnected_time: datetime) -> None:
        """
        Sets the disconnected_time of this Callback.
        The timestamp when this communication disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param disconnected_time: The disconnected_time of this Callback.
        :type: datetime
        """
        

        self._disconnected_time = disconnected_time

    @property
    def callback_scheduled_time(self) -> datetime:
        """
        Gets the callback_scheduled_time of this Callback.
        The timestamp when this communication is scheduled in the provider clock. If this value is missing it indicates the callback will be placed immediately. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The callback_scheduled_time of this Callback.
        :rtype: datetime
        """
        return self._callback_scheduled_time

    @callback_scheduled_time.setter
    def callback_scheduled_time(self, callback_scheduled_time: datetime) -> None:
        """
        Sets the callback_scheduled_time of this Callback.
        The timestamp when this communication is scheduled in the provider clock. If this value is missing it indicates the callback will be placed immediately. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param callback_scheduled_time: The callback_scheduled_time of this Callback.
        :type: datetime
        """
        

        self._callback_scheduled_time = callback_scheduled_time

    @property
    def automated_callback_config_id(self) -> str:
        """
        Gets the automated_callback_config_id of this Callback.
        The id of the config for automatically placing the callback (and handling the disposition). If null, the callback will not be placed automatically but routed to an agent as per normal.

        :return: The automated_callback_config_id of this Callback.
        :rtype: str
        """
        return self._automated_callback_config_id

    @automated_callback_config_id.setter
    def automated_callback_config_id(self, automated_callback_config_id: str) -> None:
        """
        Sets the automated_callback_config_id of this Callback.
        The id of the config for automatically placing the callback (and handling the disposition). If null, the callback will not be placed automatically but routed to an agent as per normal.

        :param automated_callback_config_id: The automated_callback_config_id of this Callback.
        :type: str
        """
        

        self._automated_callback_config_id = automated_callback_config_id

    @property
    def provider(self) -> str:
        """
        Gets the provider of this Callback.
        The source provider for the callback.

        :return: The provider of this Callback.
        :rtype: str
        """
        return self._provider

    @provider.setter
    def provider(self, provider: str) -> None:
        """
        Sets the provider of this Callback.
        The source provider for the callback.

        :param provider: The provider of this Callback.
        :type: str
        """
        

        self._provider = provider

    @property
    def peer_id(self) -> str:
        """
        Gets the peer_id of this Callback.
        The id of the peer communication corresponding to a matching leg for this communication.

        :return: The peer_id of this Callback.
        :rtype: str
        """
        return self._peer_id

    @peer_id.setter
    def peer_id(self, peer_id: str) -> None:
        """
        Sets the peer_id of this Callback.
        The id of the peer communication corresponding to a matching leg for this communication.

        :param peer_id: The peer_id of this Callback.
        :type: str
        """
        

        self._peer_id = peer_id

    @property
    def wrapup(self) -> 'Wrapup':
        """
        Gets the wrapup of this Callback.
        Call wrap up or disposition data.

        :return: The wrapup of this Callback.
        :rtype: Wrapup
        """
        return self._wrapup

    @wrapup.setter
    def wrapup(self, wrapup: 'Wrapup') -> None:
        """
        Sets the wrapup of this Callback.
        Call wrap up or disposition data.

        :param wrapup: The wrapup of this Callback.
        :type: Wrapup
        """
        

        self._wrapup = wrapup

    @property
    def after_call_work(self) -> 'AfterCallWork':
        """
        Gets the after_call_work of this Callback.
        After-call work for the communication.

        :return: The after_call_work of this Callback.
        :rtype: AfterCallWork
        """
        return self._after_call_work

    @after_call_work.setter
    def after_call_work(self, after_call_work: 'AfterCallWork') -> None:
        """
        Sets the after_call_work of this Callback.
        After-call work for the communication.

        :param after_call_work: The after_call_work of this Callback.
        :type: AfterCallWork
        """
        

        self._after_call_work = after_call_work

    @property
    def after_call_work_required(self) -> bool:
        """
        Gets the after_call_work_required of this Callback.
        Indicates if after-call work is required for a communication. Only used when the ACW Setting is Agent Requested.

        :return: The after_call_work_required of this Callback.
        :rtype: bool
        """
        return self._after_call_work_required

    @after_call_work_required.setter
    def after_call_work_required(self, after_call_work_required: bool) -> None:
        """
        Sets the after_call_work_required of this Callback.
        Indicates if after-call work is required for a communication. Only used when the ACW Setting is Agent Requested.

        :param after_call_work_required: The after_call_work_required of this Callback.
        :type: bool
        """
        

        self._after_call_work_required = after_call_work_required

    @property
    def caller_id(self) -> str:
        """
        Gets the caller_id of this Callback.
        The phone number displayed to recipients of the phone call. The value should conform to the E164 format.

        :return: The caller_id of this Callback.
        :rtype: str
        """
        return self._caller_id

    @caller_id.setter
    def caller_id(self, caller_id: str) -> None:
        """
        Sets the caller_id of this Callback.
        The phone number displayed to recipients of the phone call. The value should conform to the E164 format.

        :param caller_id: The caller_id of this Callback.
        :type: str
        """
        

        self._caller_id = caller_id

    @property
    def caller_id_name(self) -> str:
        """
        Gets the caller_id_name of this Callback.
        The name displayed to recipients of the phone call.

        :return: The caller_id_name of this Callback.
        :rtype: str
        """
        return self._caller_id_name

    @caller_id_name.setter
    def caller_id_name(self, caller_id_name: str) -> None:
        """
        Sets the caller_id_name of this Callback.
        The name displayed to recipients of the phone call.

        :param caller_id_name: The caller_id_name of this Callback.
        :type: str
        """
        

        self._caller_id_name = caller_id_name

    @property
    def queue_media_settings(self) -> 'ConversationQueueMediaSettings':
        """
        Gets the queue_media_settings of this Callback.
        Represents the queue settings for this media type.

        :return: The queue_media_settings of this Callback.
        :rtype: ConversationQueueMediaSettings
        """
        return self._queue_media_settings

    @queue_media_settings.setter
    def queue_media_settings(self, queue_media_settings: 'ConversationQueueMediaSettings') -> None:
        """
        Sets the queue_media_settings of this Callback.
        Represents the queue settings for this media type.

        :param queue_media_settings: The queue_media_settings of this Callback.
        :type: ConversationQueueMediaSettings
        """
        

        self._queue_media_settings = queue_media_settings

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

