# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class CampaignBusinessCategoryMetrics(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CampaignBusinessCategoryMetrics - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'success_count': 'int',
            'neutral_count': 'int',
            'failure_count': 'int'
        }

        self.attribute_map = {
            'success_count': 'successCount',
            'neutral_count': 'neutralCount',
            'failure_count': 'failureCount'
        }

        self._success_count = None
        self._neutral_count = None
        self._failure_count = None

    @property
    def success_count(self) -> int:
        """
        Gets the success_count of this CampaignBusinessCategoryMetrics.
        Number of calls categorized as business success

        :return: The success_count of this CampaignBusinessCategoryMetrics.
        :rtype: int
        """
        return self._success_count

    @success_count.setter
    def success_count(self, success_count: int) -> None:
        """
        Sets the success_count of this CampaignBusinessCategoryMetrics.
        Number of calls categorized as business success

        :param success_count: The success_count of this CampaignBusinessCategoryMetrics.
        :type: int
        """
        

        self._success_count = success_count

    @property
    def neutral_count(self) -> int:
        """
        Gets the neutral_count of this CampaignBusinessCategoryMetrics.
        Number of calls categorized as business neutral

        :return: The neutral_count of this CampaignBusinessCategoryMetrics.
        :rtype: int
        """
        return self._neutral_count

    @neutral_count.setter
    def neutral_count(self, neutral_count: int) -> None:
        """
        Sets the neutral_count of this CampaignBusinessCategoryMetrics.
        Number of calls categorized as business neutral

        :param neutral_count: The neutral_count of this CampaignBusinessCategoryMetrics.
        :type: int
        """
        

        self._neutral_count = neutral_count

    @property
    def failure_count(self) -> int:
        """
        Gets the failure_count of this CampaignBusinessCategoryMetrics.
        Number of calls categorized as business failure

        :return: The failure_count of this CampaignBusinessCategoryMetrics.
        :rtype: int
        """
        return self._failure_count

    @failure_count.setter
    def failure_count(self, failure_count: int) -> None:
        """
        Sets the failure_count of this CampaignBusinessCategoryMetrics.
        Number of calls categorized as business failure

        :param failure_count: The failure_count of this CampaignBusinessCategoryMetrics.
        :type: int
        """
        

        self._failure_count = failure_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

