# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import CallableContactsDiagnostic
    from . import CampaignLinesUtilization
    from . import CampaignSkillStatistics
    from . import QueueUtilizationDiagnostic
    from . import RestErrorDetail
    from . import RuleSetDiagnostic

class CampaignDiagnostics(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CampaignDiagnostics - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'callable_contacts': 'CallableContactsDiagnostic',
            'queue_utilization_diagnostic': 'QueueUtilizationDiagnostic',
            'rule_set_diagnostics': 'list[RuleSetDiagnostic]',
            'outstanding_interactions_count': 'int',
            'scheduled_interactions_count': 'int',
            'time_zone_rescheduled_calls_count': 'int',
            'filtered_out_contacts_count': 'int',
            'idle_agents': 'int',
            'effective_idle_agents': 'float',
            'lines_utilization': 'CampaignLinesUtilization',
            'number_of_contacts_called': 'int',
            'total_number_of_contacts': 'int',
            'campaign_errors': 'list[RestErrorDetail]',
            'campaign_skill_statistics': 'CampaignSkillStatistics'
        }

        self.attribute_map = {
            'callable_contacts': 'callableContacts',
            'queue_utilization_diagnostic': 'queueUtilizationDiagnostic',
            'rule_set_diagnostics': 'ruleSetDiagnostics',
            'outstanding_interactions_count': 'outstandingInteractionsCount',
            'scheduled_interactions_count': 'scheduledInteractionsCount',
            'time_zone_rescheduled_calls_count': 'timeZoneRescheduledCallsCount',
            'filtered_out_contacts_count': 'filteredOutContactsCount',
            'idle_agents': 'idleAgents',
            'effective_idle_agents': 'effectiveIdleAgents',
            'lines_utilization': 'linesUtilization',
            'number_of_contacts_called': 'numberOfContactsCalled',
            'total_number_of_contacts': 'totalNumberOfContacts',
            'campaign_errors': 'campaignErrors',
            'campaign_skill_statistics': 'campaignSkillStatistics'
        }

        self._callable_contacts = None
        self._queue_utilization_diagnostic = None
        self._rule_set_diagnostics = None
        self._outstanding_interactions_count = None
        self._scheduled_interactions_count = None
        self._time_zone_rescheduled_calls_count = None
        self._filtered_out_contacts_count = None
        self._idle_agents = None
        self._effective_idle_agents = None
        self._lines_utilization = None
        self._number_of_contacts_called = None
        self._total_number_of_contacts = None
        self._campaign_errors = None
        self._campaign_skill_statistics = None

    @property
    def callable_contacts(self) -> 'CallableContactsDiagnostic':
        """
        Gets the callable_contacts of this CampaignDiagnostics.
        Campaign properties that can impact which contacts are callable

        :return: The callable_contacts of this CampaignDiagnostics.
        :rtype: CallableContactsDiagnostic
        """
        return self._callable_contacts

    @callable_contacts.setter
    def callable_contacts(self, callable_contacts: 'CallableContactsDiagnostic') -> None:
        """
        Sets the callable_contacts of this CampaignDiagnostics.
        Campaign properties that can impact which contacts are callable

        :param callable_contacts: The callable_contacts of this CampaignDiagnostics.
        :type: CallableContactsDiagnostic
        """
        

        self._callable_contacts = callable_contacts

    @property
    def queue_utilization_diagnostic(self) -> 'QueueUtilizationDiagnostic':
        """
        Gets the queue_utilization_diagnostic of this CampaignDiagnostics.
        Information regarding the campaign's queue

        :return: The queue_utilization_diagnostic of this CampaignDiagnostics.
        :rtype: QueueUtilizationDiagnostic
        """
        return self._queue_utilization_diagnostic

    @queue_utilization_diagnostic.setter
    def queue_utilization_diagnostic(self, queue_utilization_diagnostic: 'QueueUtilizationDiagnostic') -> None:
        """
        Sets the queue_utilization_diagnostic of this CampaignDiagnostics.
        Information regarding the campaign's queue

        :param queue_utilization_diagnostic: The queue_utilization_diagnostic of this CampaignDiagnostics.
        :type: QueueUtilizationDiagnostic
        """
        

        self._queue_utilization_diagnostic = queue_utilization_diagnostic

    @property
    def rule_set_diagnostics(self) -> List['RuleSetDiagnostic']:
        """
        Gets the rule_set_diagnostics of this CampaignDiagnostics.
        Information regarding the campaign's rule sets

        :return: The rule_set_diagnostics of this CampaignDiagnostics.
        :rtype: list[RuleSetDiagnostic]
        """
        return self._rule_set_diagnostics

    @rule_set_diagnostics.setter
    def rule_set_diagnostics(self, rule_set_diagnostics: List['RuleSetDiagnostic']) -> None:
        """
        Sets the rule_set_diagnostics of this CampaignDiagnostics.
        Information regarding the campaign's rule sets

        :param rule_set_diagnostics: The rule_set_diagnostics of this CampaignDiagnostics.
        :type: list[RuleSetDiagnostic]
        """
        

        self._rule_set_diagnostics = rule_set_diagnostics

    @property
    def outstanding_interactions_count(self) -> int:
        """
        Gets the outstanding_interactions_count of this CampaignDiagnostics.
        Current number of outstanding interactions on the campaign

        :return: The outstanding_interactions_count of this CampaignDiagnostics.
        :rtype: int
        """
        return self._outstanding_interactions_count

    @outstanding_interactions_count.setter
    def outstanding_interactions_count(self, outstanding_interactions_count: int) -> None:
        """
        Sets the outstanding_interactions_count of this CampaignDiagnostics.
        Current number of outstanding interactions on the campaign

        :param outstanding_interactions_count: The outstanding_interactions_count of this CampaignDiagnostics.
        :type: int
        """
        

        self._outstanding_interactions_count = outstanding_interactions_count

    @property
    def scheduled_interactions_count(self) -> int:
        """
        Gets the scheduled_interactions_count of this CampaignDiagnostics.
        Current number of scheduled interactions on the campaign

        :return: The scheduled_interactions_count of this CampaignDiagnostics.
        :rtype: int
        """
        return self._scheduled_interactions_count

    @scheduled_interactions_count.setter
    def scheduled_interactions_count(self, scheduled_interactions_count: int) -> None:
        """
        Sets the scheduled_interactions_count of this CampaignDiagnostics.
        Current number of scheduled interactions on the campaign

        :param scheduled_interactions_count: The scheduled_interactions_count of this CampaignDiagnostics.
        :type: int
        """
        

        self._scheduled_interactions_count = scheduled_interactions_count

    @property
    def time_zone_rescheduled_calls_count(self) -> int:
        """
        Gets the time_zone_rescheduled_calls_count of this CampaignDiagnostics.
        Current number of time zone rescheduled calls on the campaign

        :return: The time_zone_rescheduled_calls_count of this CampaignDiagnostics.
        :rtype: int
        """
        return self._time_zone_rescheduled_calls_count

    @time_zone_rescheduled_calls_count.setter
    def time_zone_rescheduled_calls_count(self, time_zone_rescheduled_calls_count: int) -> None:
        """
        Sets the time_zone_rescheduled_calls_count of this CampaignDiagnostics.
        Current number of time zone rescheduled calls on the campaign

        :param time_zone_rescheduled_calls_count: The time_zone_rescheduled_calls_count of this CampaignDiagnostics.
        :type: int
        """
        

        self._time_zone_rescheduled_calls_count = time_zone_rescheduled_calls_count

    @property
    def filtered_out_contacts_count(self) -> int:
        """
        Gets the filtered_out_contacts_count of this CampaignDiagnostics.
        Number of contacts that don't match filter. This is currently supported only for Campaigns with dynamic filter on.

        :return: The filtered_out_contacts_count of this CampaignDiagnostics.
        :rtype: int
        """
        return self._filtered_out_contacts_count

    @filtered_out_contacts_count.setter
    def filtered_out_contacts_count(self, filtered_out_contacts_count: int) -> None:
        """
        Sets the filtered_out_contacts_count of this CampaignDiagnostics.
        Number of contacts that don't match filter. This is currently supported only for Campaigns with dynamic filter on.

        :param filtered_out_contacts_count: The filtered_out_contacts_count of this CampaignDiagnostics.
        :type: int
        """
        

        self._filtered_out_contacts_count = filtered_out_contacts_count

    @property
    def idle_agents(self) -> int:
        """
        Gets the idle_agents of this CampaignDiagnostics.
        Information regarding the campaign's available agents.

        :return: The idle_agents of this CampaignDiagnostics.
        :rtype: int
        """
        return self._idle_agents

    @idle_agents.setter
    def idle_agents(self, idle_agents: int) -> None:
        """
        Sets the idle_agents of this CampaignDiagnostics.
        Information regarding the campaign's available agents.

        :param idle_agents: The idle_agents of this CampaignDiagnostics.
        :type: int
        """
        

        self._idle_agents = idle_agents

    @property
    def effective_idle_agents(self) -> float:
        """
        Gets the effective_idle_agents of this CampaignDiagnostics.
        Information regarding the campaign's effective available agents.

        :return: The effective_idle_agents of this CampaignDiagnostics.
        :rtype: float
        """
        return self._effective_idle_agents

    @effective_idle_agents.setter
    def effective_idle_agents(self, effective_idle_agents: float) -> None:
        """
        Sets the effective_idle_agents of this CampaignDiagnostics.
        Information regarding the campaign's effective available agents.

        :param effective_idle_agents: The effective_idle_agents of this CampaignDiagnostics.
        :type: float
        """
        

        self._effective_idle_agents = effective_idle_agents

    @property
    def lines_utilization(self) -> 'CampaignLinesUtilization':
        """
        Gets the lines_utilization of this CampaignDiagnostics.
        Information on the campaign's lines utilization.

        :return: The lines_utilization of this CampaignDiagnostics.
        :rtype: CampaignLinesUtilization
        """
        return self._lines_utilization

    @lines_utilization.setter
    def lines_utilization(self, lines_utilization: 'CampaignLinesUtilization') -> None:
        """
        Sets the lines_utilization of this CampaignDiagnostics.
        Information on the campaign's lines utilization.

        :param lines_utilization: The lines_utilization of this CampaignDiagnostics.
        :type: CampaignLinesUtilization
        """
        

        self._lines_utilization = lines_utilization

    @property
    def number_of_contacts_called(self) -> int:
        """
        Gets the number_of_contacts_called of this CampaignDiagnostics.
        Number of contacts called during the campaign.

        :return: The number_of_contacts_called of this CampaignDiagnostics.
        :rtype: int
        """
        return self._number_of_contacts_called

    @number_of_contacts_called.setter
    def number_of_contacts_called(self, number_of_contacts_called: int) -> None:
        """
        Sets the number_of_contacts_called of this CampaignDiagnostics.
        Number of contacts called during the campaign.

        :param number_of_contacts_called: The number_of_contacts_called of this CampaignDiagnostics.
        :type: int
        """
        

        self._number_of_contacts_called = number_of_contacts_called

    @property
    def total_number_of_contacts(self) -> int:
        """
        Gets the total_number_of_contacts of this CampaignDiagnostics.
        Total number of contacts in the campaign.

        :return: The total_number_of_contacts of this CampaignDiagnostics.
        :rtype: int
        """
        return self._total_number_of_contacts

    @total_number_of_contacts.setter
    def total_number_of_contacts(self, total_number_of_contacts: int) -> None:
        """
        Sets the total_number_of_contacts of this CampaignDiagnostics.
        Total number of contacts in the campaign.

        :param total_number_of_contacts: The total_number_of_contacts of this CampaignDiagnostics.
        :type: int
        """
        

        self._total_number_of_contacts = total_number_of_contacts

    @property
    def campaign_errors(self) -> List['RestErrorDetail']:
        """
        Gets the campaign_errors of this CampaignDiagnostics.
        A list of current error conditions associated with the campaign.

        :return: The campaign_errors of this CampaignDiagnostics.
        :rtype: list[RestErrorDetail]
        """
        return self._campaign_errors

    @campaign_errors.setter
    def campaign_errors(self, campaign_errors: List['RestErrorDetail']) -> None:
        """
        Sets the campaign_errors of this CampaignDiagnostics.
        A list of current error conditions associated with the campaign.

        :param campaign_errors: The campaign_errors of this CampaignDiagnostics.
        :type: list[RestErrorDetail]
        """
        

        self._campaign_errors = campaign_errors

    @property
    def campaign_skill_statistics(self) -> 'CampaignSkillStatistics':
        """
        Gets the campaign_skill_statistics of this CampaignDiagnostics.
        Information regarding the campaign's skills

        :return: The campaign_skill_statistics of this CampaignDiagnostics.
        :rtype: CampaignSkillStatistics
        """
        return self._campaign_skill_statistics

    @campaign_skill_statistics.setter
    def campaign_skill_statistics(self, campaign_skill_statistics: 'CampaignSkillStatistics') -> None:
        """
        Sets the campaign_skill_statistics of this CampaignDiagnostics.
        Information regarding the campaign's skills

        :param campaign_skill_statistics: The campaign_skill_statistics of this CampaignDiagnostics.
        :type: CampaignSkillStatistics
        """
        

        self._campaign_skill_statistics = campaign_skill_statistics

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

