# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class CampaignLinesUtilization(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CampaignLinesUtilization - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'assigned_outbound_lines': 'int',
            'total_available_outbound_lines': 'int'
        }

        self.attribute_map = {
            'assigned_outbound_lines': 'assignedOutboundLines',
            'total_available_outbound_lines': 'totalAvailableOutboundLines'
        }

        self._assigned_outbound_lines = None
        self._total_available_outbound_lines = None

    @property
    def assigned_outbound_lines(self) -> int:
        """
        Gets the assigned_outbound_lines of this CampaignLinesUtilization.
        Number of outbound lines assigned to the campaign

        :return: The assigned_outbound_lines of this CampaignLinesUtilization.
        :rtype: int
        """
        return self._assigned_outbound_lines

    @assigned_outbound_lines.setter
    def assigned_outbound_lines(self, assigned_outbound_lines: int) -> None:
        """
        Sets the assigned_outbound_lines of this CampaignLinesUtilization.
        Number of outbound lines assigned to the campaign

        :param assigned_outbound_lines: The assigned_outbound_lines of this CampaignLinesUtilization.
        :type: int
        """
        

        self._assigned_outbound_lines = assigned_outbound_lines

    @property
    def total_available_outbound_lines(self) -> int:
        """
        Gets the total_available_outbound_lines of this CampaignLinesUtilization.
        Total number of available outbound lines in Campaign's Edge Group or Site

        :return: The total_available_outbound_lines of this CampaignLinesUtilization.
        :rtype: int
        """
        return self._total_available_outbound_lines

    @total_available_outbound_lines.setter
    def total_available_outbound_lines(self, total_available_outbound_lines: int) -> None:
        """
        Sets the total_available_outbound_lines of this CampaignLinesUtilization.
        Total number of available outbound lines in Campaign's Edge Group or Site

        :param total_available_outbound_lines: The total_available_outbound_lines of this CampaignLinesUtilization.
        :type: int
        """
        

        self._total_available_outbound_lines = total_available_outbound_lines

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

