# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import DynamicLineBalancingSettingsPatchRequest

class CampaignPatchRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CampaignPatchRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'outbound_line_count': 'int',
            'abandon_rate': 'float',
            'max_calls_per_agent': 'float',
            'dynamic_line_balancing_settings': 'DynamicLineBalancingSettingsPatchRequest',
            'queue': 'AddressableEntityRef'
        }

        self.attribute_map = {
            'outbound_line_count': 'outboundLineCount',
            'abandon_rate': 'abandonRate',
            'max_calls_per_agent': 'maxCallsPerAgent',
            'dynamic_line_balancing_settings': 'dynamicLineBalancingSettings',
            'queue': 'queue'
        }

        self._outbound_line_count = None
        self._abandon_rate = None
        self._max_calls_per_agent = None
        self._dynamic_line_balancing_settings = None
        self._queue = None

    @property
    def outbound_line_count(self) -> int:
        """
        Gets the outbound_line_count of this CampaignPatchRequest.
        The number of outbound lines to be concurrently dialed.

        :return: The outbound_line_count of this CampaignPatchRequest.
        :rtype: int
        """
        return self._outbound_line_count

    @outbound_line_count.setter
    def outbound_line_count(self, outbound_line_count: int) -> None:
        """
        Sets the outbound_line_count of this CampaignPatchRequest.
        The number of outbound lines to be concurrently dialed.

        :param outbound_line_count: The outbound_line_count of this CampaignPatchRequest.
        :type: int
        """
        

        self._outbound_line_count = outbound_line_count

    @property
    def abandon_rate(self) -> float:
        """
        Gets the abandon_rate of this CampaignPatchRequest.
        The targeted compliance abandon rate percentage

        :return: The abandon_rate of this CampaignPatchRequest.
        :rtype: float
        """
        return self._abandon_rate

    @abandon_rate.setter
    def abandon_rate(self, abandon_rate: float) -> None:
        """
        Sets the abandon_rate of this CampaignPatchRequest.
        The targeted compliance abandon rate percentage

        :param abandon_rate: The abandon_rate of this CampaignPatchRequest.
        :type: float
        """
        

        self._abandon_rate = abandon_rate

    @property
    def max_calls_per_agent(self) -> float:
        """
        Gets the max_calls_per_agent of this CampaignPatchRequest.
        The maximum number of calls that can be placed per agent on this campaign

        :return: The max_calls_per_agent of this CampaignPatchRequest.
        :rtype: float
        """
        return self._max_calls_per_agent

    @max_calls_per_agent.setter
    def max_calls_per_agent(self, max_calls_per_agent: float) -> None:
        """
        Sets the max_calls_per_agent of this CampaignPatchRequest.
        The maximum number of calls that can be placed per agent on this campaign

        :param max_calls_per_agent: The max_calls_per_agent of this CampaignPatchRequest.
        :type: float
        """
        

        self._max_calls_per_agent = max_calls_per_agent

    @property
    def dynamic_line_balancing_settings(self) -> 'DynamicLineBalancingSettingsPatchRequest':
        """
        Gets the dynamic_line_balancing_settings of this CampaignPatchRequest.
        Dynamic line balancing settings

        :return: The dynamic_line_balancing_settings of this CampaignPatchRequest.
        :rtype: DynamicLineBalancingSettingsPatchRequest
        """
        return self._dynamic_line_balancing_settings

    @dynamic_line_balancing_settings.setter
    def dynamic_line_balancing_settings(self, dynamic_line_balancing_settings: 'DynamicLineBalancingSettingsPatchRequest') -> None:
        """
        Sets the dynamic_line_balancing_settings of this CampaignPatchRequest.
        Dynamic line balancing settings

        :param dynamic_line_balancing_settings: The dynamic_line_balancing_settings of this CampaignPatchRequest.
        :type: DynamicLineBalancingSettingsPatchRequest
        """
        

        self._dynamic_line_balancing_settings = dynamic_line_balancing_settings

    @property
    def queue(self) -> 'AddressableEntityRef':
        """
        Gets the queue of this CampaignPatchRequest.
        The Queue for this Campaign to route calls to.

        :return: The queue of this CampaignPatchRequest.
        :rtype: AddressableEntityRef
        """
        return self._queue

    @queue.setter
    def queue(self, queue: 'AddressableEntityRef') -> None:
        """
        Sets the queue of this CampaignPatchRequest.
        The Queue for this Campaign to route calls to.

        :param queue: The queue of this CampaignPatchRequest.
        :type: AddressableEntityRef
        """
        

        self._queue = queue

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

