# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DomainEntityRef

class CampaignRuleParameters(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CampaignRuleParameters - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'operator': 'str',
            'value': 'str',
            'priority': 'str',
            'dialing_mode': 'str',
            'abandon_rate': 'float',
            'outbound_line_count': 'int',
            'relative_weight': 'int',
            'max_calls_per_agent': 'float',
            'queue': 'DomainEntityRef',
            'messages_per_minute': 'int',
            'sms_messages_per_minute': 'int',
            'email_messages_per_minute': 'int',
            'sms_content_template': 'DomainEntityRef',
            'email_content_template': 'DomainEntityRef'
        }

        self.attribute_map = {
            'operator': 'operator',
            'value': 'value',
            'priority': 'priority',
            'dialing_mode': 'dialingMode',
            'abandon_rate': 'abandonRate',
            'outbound_line_count': 'outboundLineCount',
            'relative_weight': 'relativeWeight',
            'max_calls_per_agent': 'maxCallsPerAgent',
            'queue': 'queue',
            'messages_per_minute': 'messagesPerMinute',
            'sms_messages_per_minute': 'smsMessagesPerMinute',
            'email_messages_per_minute': 'emailMessagesPerMinute',
            'sms_content_template': 'smsContentTemplate',
            'email_content_template': 'emailContentTemplate'
        }

        self._operator = None
        self._value = None
        self._priority = None
        self._dialing_mode = None
        self._abandon_rate = None
        self._outbound_line_count = None
        self._relative_weight = None
        self._max_calls_per_agent = None
        self._queue = None
        self._messages_per_minute = None
        self._sms_messages_per_minute = None
        self._email_messages_per_minute = None
        self._sms_content_template = None
        self._email_content_template = None

    @property
    def operator(self) -> str:
        """
        Gets the operator of this CampaignRuleParameters.
        The operator for comparison. Required for a CampaignRuleCondition.

        :return: The operator of this CampaignRuleParameters.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator: str) -> None:
        """
        Sets the operator of this CampaignRuleParameters.
        The operator for comparison. Required for a CampaignRuleCondition.

        :param operator: The operator of this CampaignRuleParameters.
        :type: str
        """
        if isinstance(operator, int):
            operator = str(operator)
        allowed_values = ["equals", "greaterThan", "greaterThanEqualTo", "lessThan", "lessThanEqualTo"]
        if operator.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for operator -> " + operator)
            self._operator = "outdated_sdk_version"
        else:
            self._operator = operator

    @property
    def value(self) -> str:
        """
        Gets the value of this CampaignRuleParameters.
        The value for comparison. Required for a CampaignRuleCondition.

        :return: The value of this CampaignRuleParameters.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value: str) -> None:
        """
        Sets the value of this CampaignRuleParameters.
        The value for comparison. Required for a CampaignRuleCondition.

        :param value: The value of this CampaignRuleParameters.
        :type: str
        """
        

        self._value = value

    @property
    def priority(self) -> str:
        """
        Gets the priority of this CampaignRuleParameters.
        The priority to set a campaign to. Required for the 'setCampaignPriority' action.

        :return: The priority of this CampaignRuleParameters.
        :rtype: str
        """
        return self._priority

    @priority.setter
    def priority(self, priority: str) -> None:
        """
        Sets the priority of this CampaignRuleParameters.
        The priority to set a campaign to. Required for the 'setCampaignPriority' action.

        :param priority: The priority of this CampaignRuleParameters.
        :type: str
        """
        if isinstance(priority, int):
            priority = str(priority)
        allowed_values = ["1", "2", "3", "4", "5"]
        if priority.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for priority -> " + priority)
            self._priority = "outdated_sdk_version"
        else:
            self._priority = priority

    @property
    def dialing_mode(self) -> str:
        """
        Gets the dialing_mode of this CampaignRuleParameters.
        The dialing mode to set a campaign to. Required for the 'setCampaignDialingMode' action.

        :return: The dialing_mode of this CampaignRuleParameters.
        :rtype: str
        """
        return self._dialing_mode

    @dialing_mode.setter
    def dialing_mode(self, dialing_mode: str) -> None:
        """
        Sets the dialing_mode of this CampaignRuleParameters.
        The dialing mode to set a campaign to. Required for the 'setCampaignDialingMode' action.

        :param dialing_mode: The dialing_mode of this CampaignRuleParameters.
        :type: str
        """
        if isinstance(dialing_mode, int):
            dialing_mode = str(dialing_mode)
        allowed_values = ["agentless", "preview", "power", "predictive", "progressive", "external"]
        if dialing_mode.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for dialing_mode -> " + dialing_mode)
            self._dialing_mode = "outdated_sdk_version"
        else:
            self._dialing_mode = dialing_mode

    @property
    def abandon_rate(self) -> float:
        """
        Gets the abandon_rate of this CampaignRuleParameters.
        The abandon rate to set a campaign to. Required for the 'setCampaignAbandonRate' action.

        :return: The abandon_rate of this CampaignRuleParameters.
        :rtype: float
        """
        return self._abandon_rate

    @abandon_rate.setter
    def abandon_rate(self, abandon_rate: float) -> None:
        """
        Sets the abandon_rate of this CampaignRuleParameters.
        The abandon rate to set a campaign to. Required for the 'setCampaignAbandonRate' action.

        :param abandon_rate: The abandon_rate of this CampaignRuleParameters.
        :type: float
        """
        

        self._abandon_rate = abandon_rate

    @property
    def outbound_line_count(self) -> int:
        """
        Gets the outbound_line_count of this CampaignRuleParameters.
        The  number of outbound lines to set a campaign to. Required for the 'setCampaignNumberOfLines' action.

        :return: The outbound_line_count of this CampaignRuleParameters.
        :rtype: int
        """
        return self._outbound_line_count

    @outbound_line_count.setter
    def outbound_line_count(self, outbound_line_count: int) -> None:
        """
        Sets the outbound_line_count of this CampaignRuleParameters.
        The  number of outbound lines to set a campaign to. Required for the 'setCampaignNumberOfLines' action.

        :param outbound_line_count: The outbound_line_count of this CampaignRuleParameters.
        :type: int
        """
        

        self._outbound_line_count = outbound_line_count

    @property
    def relative_weight(self) -> int:
        """
        Gets the relative_weight of this CampaignRuleParameters.
        The relative weight to set a campaign to. Required for the 'setCampaignWeight' action.

        :return: The relative_weight of this CampaignRuleParameters.
        :rtype: int
        """
        return self._relative_weight

    @relative_weight.setter
    def relative_weight(self, relative_weight: int) -> None:
        """
        Sets the relative_weight of this CampaignRuleParameters.
        The relative weight to set a campaign to. Required for the 'setCampaignWeight' action.

        :param relative_weight: The relative_weight of this CampaignRuleParameters.
        :type: int
        """
        

        self._relative_weight = relative_weight

    @property
    def max_calls_per_agent(self) -> float:
        """
        Gets the max_calls_per_agent of this CampaignRuleParameters.
        The maximum number of calls per agent to set a campaign to. Required for the 'setCampaignMaxCallsPerAgent' action.

        :return: The max_calls_per_agent of this CampaignRuleParameters.
        :rtype: float
        """
        return self._max_calls_per_agent

    @max_calls_per_agent.setter
    def max_calls_per_agent(self, max_calls_per_agent: float) -> None:
        """
        Sets the max_calls_per_agent of this CampaignRuleParameters.
        The maximum number of calls per agent to set a campaign to. Required for the 'setCampaignMaxCallsPerAgent' action.

        :param max_calls_per_agent: The max_calls_per_agent of this CampaignRuleParameters.
        :type: float
        """
        

        self._max_calls_per_agent = max_calls_per_agent

    @property
    def queue(self) -> 'DomainEntityRef':
        """
        Gets the queue of this CampaignRuleParameters.
        The queue a campaign to. Required for the 'changeCampaignQueue' action.

        :return: The queue of this CampaignRuleParameters.
        :rtype: DomainEntityRef
        """
        return self._queue

    @queue.setter
    def queue(self, queue: 'DomainEntityRef') -> None:
        """
        Sets the queue of this CampaignRuleParameters.
        The queue a campaign to. Required for the 'changeCampaignQueue' action.

        :param queue: The queue of this CampaignRuleParameters.
        :type: DomainEntityRef
        """
        

        self._queue = queue

    @property
    def messages_per_minute(self) -> int:
        """
        Gets the messages_per_minute of this CampaignRuleParameters.
        The number of messages per minute to set a messaging campaign to.

        :return: The messages_per_minute of this CampaignRuleParameters.
        :rtype: int
        """
        return self._messages_per_minute

    @messages_per_minute.setter
    def messages_per_minute(self, messages_per_minute: int) -> None:
        """
        Sets the messages_per_minute of this CampaignRuleParameters.
        The number of messages per minute to set a messaging campaign to.

        :param messages_per_minute: The messages_per_minute of this CampaignRuleParameters.
        :type: int
        """
        

        self._messages_per_minute = messages_per_minute

    @property
    def sms_messages_per_minute(self) -> int:
        """
        Gets the sms_messages_per_minute of this CampaignRuleParameters.
        The number of messages per minute to set a SMS messaging campaign to.

        :return: The sms_messages_per_minute of this CampaignRuleParameters.
        :rtype: int
        """
        return self._sms_messages_per_minute

    @sms_messages_per_minute.setter
    def sms_messages_per_minute(self, sms_messages_per_minute: int) -> None:
        """
        Sets the sms_messages_per_minute of this CampaignRuleParameters.
        The number of messages per minute to set a SMS messaging campaign to.

        :param sms_messages_per_minute: The sms_messages_per_minute of this CampaignRuleParameters.
        :type: int
        """
        

        self._sms_messages_per_minute = sms_messages_per_minute

    @property
    def email_messages_per_minute(self) -> int:
        """
        Gets the email_messages_per_minute of this CampaignRuleParameters.
        The number of messages per minute to set a Email messaging campaign to.

        :return: The email_messages_per_minute of this CampaignRuleParameters.
        :rtype: int
        """
        return self._email_messages_per_minute

    @email_messages_per_minute.setter
    def email_messages_per_minute(self, email_messages_per_minute: int) -> None:
        """
        Sets the email_messages_per_minute of this CampaignRuleParameters.
        The number of messages per minute to set a Email messaging campaign to.

        :param email_messages_per_minute: The email_messages_per_minute of this CampaignRuleParameters.
        :type: int
        """
        

        self._email_messages_per_minute = email_messages_per_minute

    @property
    def sms_content_template(self) -> 'DomainEntityRef':
        """
        Gets the sms_content_template of this CampaignRuleParameters.
        The content template to set a SMS campaign to.

        :return: The sms_content_template of this CampaignRuleParameters.
        :rtype: DomainEntityRef
        """
        return self._sms_content_template

    @sms_content_template.setter
    def sms_content_template(self, sms_content_template: 'DomainEntityRef') -> None:
        """
        Sets the sms_content_template of this CampaignRuleParameters.
        The content template to set a SMS campaign to.

        :param sms_content_template: The sms_content_template of this CampaignRuleParameters.
        :type: DomainEntityRef
        """
        

        self._sms_content_template = sms_content_template

    @property
    def email_content_template(self) -> 'DomainEntityRef':
        """
        Gets the email_content_template of this CampaignRuleParameters.
        The content template to set a Email campaign to.

        :return: The email_content_template of this CampaignRuleParameters.
        :rtype: DomainEntityRef
        """
        return self._email_content_template

    @email_content_template.setter
    def email_content_template(self, email_content_template: 'DomainEntityRef') -> None:
        """
        Sets the email_content_template of this CampaignRuleParameters.
        The content template to set a Email campaign to.

        :param email_content_template: The email_content_template of this CampaignRuleParameters.
        :type: DomainEntityRef
        """
        

        self._email_content_template = email_content_template

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

