# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DivisionedDomainEntityRef
    from . import Reoccurrence
    from . import ScheduleInterval

class CampaignSchedule(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CampaignSchedule - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'version': 'int',
            'intervals': 'list[ScheduleInterval]',
            'recurrences': 'list[Reoccurrence]',
            'time_zone': 'str',
            'campaign': 'DivisionedDomainEntityRef',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'version': 'version',
            'intervals': 'intervals',
            'recurrences': 'recurrences',
            'time_zone': 'timeZone',
            'campaign': 'campaign',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._date_created = None
        self._date_modified = None
        self._version = None
        self._intervals = None
        self._recurrences = None
        self._time_zone = None
        self._campaign = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this CampaignSchedule.
        The globally unique identifier for the object.

        :return: The id of this CampaignSchedule.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this CampaignSchedule.
        The globally unique identifier for the object.

        :param id: The id of this CampaignSchedule.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this CampaignSchedule.


        :return: The name of this CampaignSchedule.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this CampaignSchedule.


        :param name: The name of this CampaignSchedule.
        :type: str
        """
        

        self._name = name

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this CampaignSchedule.
        Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this CampaignSchedule.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this CampaignSchedule.
        Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this CampaignSchedule.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this CampaignSchedule.
        Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this CampaignSchedule.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this CampaignSchedule.
        Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this CampaignSchedule.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def version(self) -> int:
        """
        Gets the version of this CampaignSchedule.
        Required for updates, must match the version number of the most recent update

        :return: The version of this CampaignSchedule.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this CampaignSchedule.
        Required for updates, must match the version number of the most recent update

        :param version: The version of this CampaignSchedule.
        :type: int
        """
        

        self._version = version

    @property
    def intervals(self) -> List['ScheduleInterval']:
        """
        Gets the intervals of this CampaignSchedule.
        A list of intervals during which to run the associated Campaign.

        :return: The intervals of this CampaignSchedule.
        :rtype: list[ScheduleInterval]
        """
        return self._intervals

    @intervals.setter
    def intervals(self, intervals: List['ScheduleInterval']) -> None:
        """
        Sets the intervals of this CampaignSchedule.
        A list of intervals during which to run the associated Campaign.

        :param intervals: The intervals of this CampaignSchedule.
        :type: list[ScheduleInterval]
        """
        

        self._intervals = intervals

    @property
    def recurrences(self) -> List['Reoccurrence']:
        """
        Gets the recurrences of this CampaignSchedule.
        Recurring schedules of the campaign

        :return: The recurrences of this CampaignSchedule.
        :rtype: list[Reoccurrence]
        """
        return self._recurrences

    @recurrences.setter
    def recurrences(self, recurrences: List['Reoccurrence']) -> None:
        """
        Sets the recurrences of this CampaignSchedule.
        Recurring schedules of the campaign

        :param recurrences: The recurrences of this CampaignSchedule.
        :type: list[Reoccurrence]
        """
        

        self._recurrences = recurrences

    @property
    def time_zone(self) -> str:
        """
        Gets the time_zone of this CampaignSchedule.
        The time zone for this CampaignSchedule. Defaults to UTC if empty or not provided. See here for a list of valid time zones https://www.iana.org/time-zones

        :return: The time_zone of this CampaignSchedule.
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone: str) -> None:
        """
        Sets the time_zone of this CampaignSchedule.
        The time zone for this CampaignSchedule. Defaults to UTC if empty or not provided. See here for a list of valid time zones https://www.iana.org/time-zones

        :param time_zone: The time_zone of this CampaignSchedule.
        :type: str
        """
        

        self._time_zone = time_zone

    @property
    def campaign(self) -> 'DivisionedDomainEntityRef':
        """
        Gets the campaign of this CampaignSchedule.
        The Campaign that this CampaignSchedule is for.

        :return: The campaign of this CampaignSchedule.
        :rtype: DivisionedDomainEntityRef
        """
        return self._campaign

    @campaign.setter
    def campaign(self, campaign: 'DivisionedDomainEntityRef') -> None:
        """
        Sets the campaign of this CampaignSchedule.
        The Campaign that this CampaignSchedule is for.

        :param campaign: The campaign of this CampaignSchedule.
        :type: DivisionedDomainEntityRef
        """
        

        self._campaign = campaign

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this CampaignSchedule.
        The URI for this object

        :return: The self_uri of this CampaignSchedule.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this CampaignSchedule.
        The URI for this object

        :param self_uri: The self_uri of this CampaignSchedule.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

