# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import UserReference

class CapacityPlanMetadata(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CapacityPlanMetadata - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'modified_by': 'UserReference',
            'modified_date': 'datetime',
            'created_date': 'datetime',
            'created_by': 'UserReference',
            'version': 'int'
        }

        self.attribute_map = {
            'modified_by': 'modifiedBy',
            'modified_date': 'modifiedDate',
            'created_date': 'createdDate',
            'created_by': 'createdBy',
            'version': 'version'
        }

        self._modified_by = None
        self._modified_date = None
        self._created_date = None
        self._created_by = None
        self._version = None

    @property
    def modified_by(self) -> 'UserReference':
        """
        Gets the modified_by of this CapacityPlanMetadata.
        The user who modified the entity

        :return: The modified_by of this CapacityPlanMetadata.
        :rtype: UserReference
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by: 'UserReference') -> None:
        """
        Sets the modified_by of this CapacityPlanMetadata.
        The user who modified the entity

        :param modified_by: The modified_by of this CapacityPlanMetadata.
        :type: UserReference
        """
        

        self._modified_by = modified_by

    @property
    def modified_date(self) -> datetime:
        """
        Gets the modified_date of this CapacityPlanMetadata.
        The entity last modified date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The modified_date of this CapacityPlanMetadata.
        :rtype: datetime
        """
        return self._modified_date

    @modified_date.setter
    def modified_date(self, modified_date: datetime) -> None:
        """
        Sets the modified_date of this CapacityPlanMetadata.
        The entity last modified date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param modified_date: The modified_date of this CapacityPlanMetadata.
        :type: datetime
        """
        

        self._modified_date = modified_date

    @property
    def created_date(self) -> datetime:
        """
        Gets the created_date of this CapacityPlanMetadata.
        The date the entity created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The created_date of this CapacityPlanMetadata.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date: datetime) -> None:
        """
        Sets the created_date of this CapacityPlanMetadata.
        The date the entity created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param created_date: The created_date of this CapacityPlanMetadata.
        :type: datetime
        """
        

        self._created_date = created_date

    @property
    def created_by(self) -> 'UserReference':
        """
        Gets the created_by of this CapacityPlanMetadata.
        The user who created the associated entity

        :return: The created_by of this CapacityPlanMetadata.
        :rtype: UserReference
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'UserReference') -> None:
        """
        Sets the created_by of this CapacityPlanMetadata.
        The user who created the associated entity

        :param created_by: The created_by of this CapacityPlanMetadata.
        :type: UserReference
        """
        

        self._created_by = created_by

    @property
    def version(self) -> int:
        """
        Gets the version of this CapacityPlanMetadata.
        The version of the capacity plan

        :return: The version of this CapacityPlanMetadata.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this CapacityPlanMetadata.
        The version of the capacity plan

        :param version: The version of this CapacityPlanMetadata.
        :type: int
        """
        

        self._version = version

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

