# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BuShortTermForecastReference
    from . import CreateStaffingGroupAllocation

class CapacityPlanRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CapacityPlanRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'start_business_unit_date': 'date',
            'end_business_unit_date': 'date',
            'forecast': 'BuShortTermForecastReference',
            'full_time_equivalent_weekly_hours': 'float',
            'staffing_group_allocations': 'list[CreateStaffingGroupAllocation]'
        }

        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'start_business_unit_date': 'startBusinessUnitDate',
            'end_business_unit_date': 'endBusinessUnitDate',
            'forecast': 'forecast',
            'full_time_equivalent_weekly_hours': 'fullTimeEquivalentWeeklyHours',
            'staffing_group_allocations': 'staffingGroupAllocations'
        }

        self._name = None
        self._description = None
        self._start_business_unit_date = None
        self._end_business_unit_date = None
        self._forecast = None
        self._full_time_equivalent_weekly_hours = None
        self._staffing_group_allocations = None

    @property
    def name(self) -> str:
        """
        Gets the name of this CapacityPlanRequest.
        The name of the capacity plan

        :return: The name of this CapacityPlanRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this CapacityPlanRequest.
        The name of the capacity plan

        :param name: The name of this CapacityPlanRequest.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this CapacityPlanRequest.
        Description of the capacity plan

        :return: The description of this CapacityPlanRequest.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this CapacityPlanRequest.
        Description of the capacity plan

        :param description: The description of this CapacityPlanRequest.
        :type: str
        """
        

        self._description = description

    @property
    def start_business_unit_date(self) -> date:
        """
        Gets the start_business_unit_date of this CapacityPlanRequest.
        The start date for the capacity plan relative to the business unit time zone in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The start_business_unit_date of this CapacityPlanRequest.
        :rtype: date
        """
        return self._start_business_unit_date

    @start_business_unit_date.setter
    def start_business_unit_date(self, start_business_unit_date: date) -> None:
        """
        Sets the start_business_unit_date of this CapacityPlanRequest.
        The start date for the capacity plan relative to the business unit time zone in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param start_business_unit_date: The start_business_unit_date of this CapacityPlanRequest.
        :type: date
        """
        

        self._start_business_unit_date = start_business_unit_date

    @property
    def end_business_unit_date(self) -> date:
        """
        Gets the end_business_unit_date of this CapacityPlanRequest.
        The end date for the capacity plan relative to the business unit time zone in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The end_business_unit_date of this CapacityPlanRequest.
        :rtype: date
        """
        return self._end_business_unit_date

    @end_business_unit_date.setter
    def end_business_unit_date(self, end_business_unit_date: date) -> None:
        """
        Sets the end_business_unit_date of this CapacityPlanRequest.
        The end date for the capacity plan relative to the business unit time zone in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param end_business_unit_date: The end_business_unit_date of this CapacityPlanRequest.
        :type: date
        """
        

        self._end_business_unit_date = end_business_unit_date

    @property
    def forecast(self) -> 'BuShortTermForecastReference':
        """
        Gets the forecast of this CapacityPlanRequest.
        The selected forecast for this capacity plan. Null when main forecast is used in the future

        :return: The forecast of this CapacityPlanRequest.
        :rtype: BuShortTermForecastReference
        """
        return self._forecast

    @forecast.setter
    def forecast(self, forecast: 'BuShortTermForecastReference') -> None:
        """
        Sets the forecast of this CapacityPlanRequest.
        The selected forecast for this capacity plan. Null when main forecast is used in the future

        :param forecast: The forecast of this CapacityPlanRequest.
        :type: BuShortTermForecastReference
        """
        

        self._forecast = forecast

    @property
    def full_time_equivalent_weekly_hours(self) -> float:
        """
        Gets the full_time_equivalent_weekly_hours of this CapacityPlanRequest.
        The weekly hours used to calculate full time equivalent agents

        :return: The full_time_equivalent_weekly_hours of this CapacityPlanRequest.
        :rtype: float
        """
        return self._full_time_equivalent_weekly_hours

    @full_time_equivalent_weekly_hours.setter
    def full_time_equivalent_weekly_hours(self, full_time_equivalent_weekly_hours: float) -> None:
        """
        Sets the full_time_equivalent_weekly_hours of this CapacityPlanRequest.
        The weekly hours used to calculate full time equivalent agents

        :param full_time_equivalent_weekly_hours: The full_time_equivalent_weekly_hours of this CapacityPlanRequest.
        :type: float
        """
        

        self._full_time_equivalent_weekly_hours = full_time_equivalent_weekly_hours

    @property
    def staffing_group_allocations(self) -> List['CreateStaffingGroupAllocation']:
        """
        Gets the staffing_group_allocations of this CapacityPlanRequest.
        List of staffing group allocations to be used for the capacity plan

        :return: The staffing_group_allocations of this CapacityPlanRequest.
        :rtype: list[CreateStaffingGroupAllocation]
        """
        return self._staffing_group_allocations

    @staffing_group_allocations.setter
    def staffing_group_allocations(self, staffing_group_allocations: List['CreateStaffingGroupAllocation']) -> None:
        """
        Sets the staffing_group_allocations of this CapacityPlanRequest.
        List of staffing group allocations to be used for the capacity plan

        :param staffing_group_allocations: The staffing_group_allocations of this CapacityPlanRequest.
        :type: list[CreateStaffingGroupAllocation]
        """
        

        self._staffing_group_allocations = staffing_group_allocations

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

