# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BuShortTermForecastReference
    from . import CapacityPlanMetadata

class CapacityPlanResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CapacityPlanResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'forecast': 'BuShortTermForecastReference',
            'start_business_unit_date': 'date',
            'end_business_unit_date': 'date',
            'full_time_equivalent_weekly_hours': 'float',
            'metadata': 'CapacityPlanMetadata',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'forecast': 'forecast',
            'start_business_unit_date': 'startBusinessUnitDate',
            'end_business_unit_date': 'endBusinessUnitDate',
            'full_time_equivalent_weekly_hours': 'fullTimeEquivalentWeeklyHours',
            'metadata': 'metadata',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._forecast = None
        self._start_business_unit_date = None
        self._end_business_unit_date = None
        self._full_time_equivalent_weekly_hours = None
        self._metadata = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this CapacityPlanResponse.
        The globally unique identifier for the object.

        :return: The id of this CapacityPlanResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this CapacityPlanResponse.
        The globally unique identifier for the object.

        :param id: The id of this CapacityPlanResponse.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this CapacityPlanResponse.


        :return: The name of this CapacityPlanResponse.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this CapacityPlanResponse.


        :param name: The name of this CapacityPlanResponse.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this CapacityPlanResponse.
        Description of the capacity plan

        :return: The description of this CapacityPlanResponse.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this CapacityPlanResponse.
        Description of the capacity plan

        :param description: The description of this CapacityPlanResponse.
        :type: str
        """
        

        self._description = description

    @property
    def forecast(self) -> 'BuShortTermForecastReference':
        """
        Gets the forecast of this CapacityPlanResponse.
        The selected forecast for this capacity plan. Null when main forecast is used in the future

        :return: The forecast of this CapacityPlanResponse.
        :rtype: BuShortTermForecastReference
        """
        return self._forecast

    @forecast.setter
    def forecast(self, forecast: 'BuShortTermForecastReference') -> None:
        """
        Sets the forecast of this CapacityPlanResponse.
        The selected forecast for this capacity plan. Null when main forecast is used in the future

        :param forecast: The forecast of this CapacityPlanResponse.
        :type: BuShortTermForecastReference
        """
        

        self._forecast = forecast

    @property
    def start_business_unit_date(self) -> date:
        """
        Gets the start_business_unit_date of this CapacityPlanResponse.
        The start date for the capacity plan relative to the business unit time zone in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The start_business_unit_date of this CapacityPlanResponse.
        :rtype: date
        """
        return self._start_business_unit_date

    @start_business_unit_date.setter
    def start_business_unit_date(self, start_business_unit_date: date) -> None:
        """
        Sets the start_business_unit_date of this CapacityPlanResponse.
        The start date for the capacity plan relative to the business unit time zone in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param start_business_unit_date: The start_business_unit_date of this CapacityPlanResponse.
        :type: date
        """
        

        self._start_business_unit_date = start_business_unit_date

    @property
    def end_business_unit_date(self) -> date:
        """
        Gets the end_business_unit_date of this CapacityPlanResponse.
        The end date for the capacity plan relative to the business unit time zone in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The end_business_unit_date of this CapacityPlanResponse.
        :rtype: date
        """
        return self._end_business_unit_date

    @end_business_unit_date.setter
    def end_business_unit_date(self, end_business_unit_date: date) -> None:
        """
        Sets the end_business_unit_date of this CapacityPlanResponse.
        The end date for the capacity plan relative to the business unit time zone in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param end_business_unit_date: The end_business_unit_date of this CapacityPlanResponse.
        :type: date
        """
        

        self._end_business_unit_date = end_business_unit_date

    @property
    def full_time_equivalent_weekly_hours(self) -> float:
        """
        Gets the full_time_equivalent_weekly_hours of this CapacityPlanResponse.
        The weekly hours used to calculate full time equivalent agents

        :return: The full_time_equivalent_weekly_hours of this CapacityPlanResponse.
        :rtype: float
        """
        return self._full_time_equivalent_weekly_hours

    @full_time_equivalent_weekly_hours.setter
    def full_time_equivalent_weekly_hours(self, full_time_equivalent_weekly_hours: float) -> None:
        """
        Sets the full_time_equivalent_weekly_hours of this CapacityPlanResponse.
        The weekly hours used to calculate full time equivalent agents

        :param full_time_equivalent_weekly_hours: The full_time_equivalent_weekly_hours of this CapacityPlanResponse.
        :type: float
        """
        

        self._full_time_equivalent_weekly_hours = full_time_equivalent_weekly_hours

    @property
    def metadata(self) -> 'CapacityPlanMetadata':
        """
        Gets the metadata of this CapacityPlanResponse.
        The metadata of this capacity plan

        :return: The metadata of this CapacityPlanResponse.
        :rtype: CapacityPlanMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata: 'CapacityPlanMetadata') -> None:
        """
        Sets the metadata of this CapacityPlanResponse.
        The metadata of this capacity plan

        :param metadata: The metadata of this CapacityPlanResponse.
        :type: CapacityPlanMetadata
        """
        

        self._metadata = metadata

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this CapacityPlanResponse.
        The URI for this object

        :return: The self_uri of this CapacityPlanResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this CapacityPlanResponse.
        The URI for this object

        :param self_uri: The self_uri of this CapacityPlanResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

