# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import CapacityPlanReference
    from . import StaffingGroupAllocationsResponseTemplate

class CapacityPlanStaffingGroupAllocationsResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CapacityPlanStaffingGroupAllocationsResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'capacity_plan': 'CapacityPlanReference',
            'full_time_equivalent_weekly_hours': 'float',
            'download_url': 'str',
            'download_template': 'StaffingGroupAllocationsResponseTemplate'
        }

        self.attribute_map = {
            'capacity_plan': 'capacityPlan',
            'full_time_equivalent_weekly_hours': 'fullTimeEquivalentWeeklyHours',
            'download_url': 'downloadUrl',
            'download_template': 'downloadTemplate'
        }

        self._capacity_plan = None
        self._full_time_equivalent_weekly_hours = None
        self._download_url = None
        self._download_template = None

    @property
    def capacity_plan(self) -> 'CapacityPlanReference':
        """
        Gets the capacity_plan of this CapacityPlanStaffingGroupAllocationsResponse.
        The capacity plan to which the staffing groups belong

        :return: The capacity_plan of this CapacityPlanStaffingGroupAllocationsResponse.
        :rtype: CapacityPlanReference
        """
        return self._capacity_plan

    @capacity_plan.setter
    def capacity_plan(self, capacity_plan: 'CapacityPlanReference') -> None:
        """
        Sets the capacity_plan of this CapacityPlanStaffingGroupAllocationsResponse.
        The capacity plan to which the staffing groups belong

        :param capacity_plan: The capacity_plan of this CapacityPlanStaffingGroupAllocationsResponse.
        :type: CapacityPlanReference
        """
        

        self._capacity_plan = capacity_plan

    @property
    def full_time_equivalent_weekly_hours(self) -> float:
        """
        Gets the full_time_equivalent_weekly_hours of this CapacityPlanStaffingGroupAllocationsResponse.
        The weekly hours used to calculate full time equivalent agents

        :return: The full_time_equivalent_weekly_hours of this CapacityPlanStaffingGroupAllocationsResponse.
        :rtype: float
        """
        return self._full_time_equivalent_weekly_hours

    @full_time_equivalent_weekly_hours.setter
    def full_time_equivalent_weekly_hours(self, full_time_equivalent_weekly_hours: float) -> None:
        """
        Sets the full_time_equivalent_weekly_hours of this CapacityPlanStaffingGroupAllocationsResponse.
        The weekly hours used to calculate full time equivalent agents

        :param full_time_equivalent_weekly_hours: The full_time_equivalent_weekly_hours of this CapacityPlanStaffingGroupAllocationsResponse.
        :type: float
        """
        

        self._full_time_equivalent_weekly_hours = full_time_equivalent_weekly_hours

    @property
    def download_url(self) -> str:
        """
        Gets the download_url of this CapacityPlanStaffingGroupAllocationsResponse.
        The URL to download the staffing group allocations

        :return: The download_url of this CapacityPlanStaffingGroupAllocationsResponse.
        :rtype: str
        """
        return self._download_url

    @download_url.setter
    def download_url(self, download_url: str) -> None:
        """
        Sets the download_url of this CapacityPlanStaffingGroupAllocationsResponse.
        The URL to download the staffing group allocations

        :param download_url: The download_url of this CapacityPlanStaffingGroupAllocationsResponse.
        :type: str
        """
        

        self._download_url = download_url

    @property
    def download_template(self) -> 'StaffingGroupAllocationsResponseTemplate':
        """
        Gets the download_template of this CapacityPlanStaffingGroupAllocationsResponse.
        Staffing groups allocation results always come through downloadUrl, the schema included here is just for documentation

        :return: The download_template of this CapacityPlanStaffingGroupAllocationsResponse.
        :rtype: StaffingGroupAllocationsResponseTemplate
        """
        return self._download_template

    @download_template.setter
    def download_template(self, download_template: 'StaffingGroupAllocationsResponseTemplate') -> None:
        """
        Sets the download_template of this CapacityPlanStaffingGroupAllocationsResponse.
        Staffing groups allocation results always come through downloadUrl, the schema included here is just for documentation

        :param download_template: The download_template of this CapacityPlanStaffingGroupAllocationsResponse.
        :type: StaffingGroupAllocationsResponseTemplate
        """
        

        self._download_template = download_template

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

