# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BusinessUnitReference
    from . import CapacityPlanReference
    from . import StaffingRequirementResultResponseTemplate

class CapacityPlanStaffingRequirementResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CapacityPlanStaffingRequirementResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'business_unit': 'BusinessUnitReference',
            'capacity_plan': 'CapacityPlanReference',
            'status': 'str',
            'reference_business_unit_date': 'date',
            'granularity': 'str',
            'error_code': 'str',
            'download_url': 'str',
            'download_template': 'StaffingRequirementResultResponseTemplate'
        }

        self.attribute_map = {
            'business_unit': 'businessUnit',
            'capacity_plan': 'capacityPlan',
            'status': 'status',
            'reference_business_unit_date': 'referenceBusinessUnitDate',
            'granularity': 'granularity',
            'error_code': 'errorCode',
            'download_url': 'downloadUrl',
            'download_template': 'downloadTemplate'
        }

        self._business_unit = None
        self._capacity_plan = None
        self._status = None
        self._reference_business_unit_date = None
        self._granularity = None
        self._error_code = None
        self._download_url = None
        self._download_template = None

    @property
    def business_unit(self) -> 'BusinessUnitReference':
        """
        Gets the business_unit of this CapacityPlanStaffingRequirementResult.
        The business unit to which the capacity plan belongs

        :return: The business_unit of this CapacityPlanStaffingRequirementResult.
        :rtype: BusinessUnitReference
        """
        return self._business_unit

    @business_unit.setter
    def business_unit(self, business_unit: 'BusinessUnitReference') -> None:
        """
        Sets the business_unit of this CapacityPlanStaffingRequirementResult.
        The business unit to which the capacity plan belongs

        :param business_unit: The business_unit of this CapacityPlanStaffingRequirementResult.
        :type: BusinessUnitReference
        """
        

        self._business_unit = business_unit

    @property
    def capacity_plan(self) -> 'CapacityPlanReference':
        """
        Gets the capacity_plan of this CapacityPlanStaffingRequirementResult.
        The capacity plan for which requirements are generated

        :return: The capacity_plan of this CapacityPlanStaffingRequirementResult.
        :rtype: CapacityPlanReference
        """
        return self._capacity_plan

    @capacity_plan.setter
    def capacity_plan(self, capacity_plan: 'CapacityPlanReference') -> None:
        """
        Sets the capacity_plan of this CapacityPlanStaffingRequirementResult.
        The capacity plan for which requirements are generated

        :param capacity_plan: The capacity_plan of this CapacityPlanStaffingRequirementResult.
        :type: CapacityPlanReference
        """
        

        self._capacity_plan = capacity_plan

    @property
    def status(self) -> str:
        """
        Gets the status of this CapacityPlanStaffingRequirementResult.
        The status of the requirement generation of the capacity plan

        :return: The status of this CapacityPlanStaffingRequirementResult.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this CapacityPlanStaffingRequirementResult.
        The status of the requirement generation of the capacity plan

        :param status: The status of this CapacityPlanStaffingRequirementResult.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Processing", "Complete", "Canceled", "Error"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def reference_business_unit_date(self) -> date:
        """
        Gets the reference_business_unit_date of this CapacityPlanStaffingRequirementResult.
        The reference date for interval-based data for the requirements. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The reference_business_unit_date of this CapacityPlanStaffingRequirementResult.
        :rtype: date
        """
        return self._reference_business_unit_date

    @reference_business_unit_date.setter
    def reference_business_unit_date(self, reference_business_unit_date: date) -> None:
        """
        Sets the reference_business_unit_date of this CapacityPlanStaffingRequirementResult.
        The reference date for interval-based data for the requirements. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param reference_business_unit_date: The reference_business_unit_date of this CapacityPlanStaffingRequirementResult.
        :type: date
        """
        

        self._reference_business_unit_date = reference_business_unit_date

    @property
    def granularity(self) -> str:
        """
        Gets the granularity of this CapacityPlanStaffingRequirementResult.
        Granularity of the intervals

        :return: The granularity of this CapacityPlanStaffingRequirementResult.
        :rtype: str
        """
        return self._granularity

    @granularity.setter
    def granularity(self, granularity: str) -> None:
        """
        Sets the granularity of this CapacityPlanStaffingRequirementResult.
        Granularity of the intervals

        :param granularity: The granularity of this CapacityPlanStaffingRequirementResult.
        :type: str
        """
        if isinstance(granularity, int):
            granularity = str(granularity)
        allowed_values = ["Weekly"]
        if granularity.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for granularity -> " + granularity)
            self._granularity = "outdated_sdk_version"
        else:
            self._granularity = granularity

    @property
    def error_code(self) -> str:
        """
        Gets the error_code of this CapacityPlanStaffingRequirementResult.
        The error code when status is 'Failed'

        :return: The error_code of this CapacityPlanStaffingRequirementResult.
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code: str) -> None:
        """
        Sets the error_code of this CapacityPlanStaffingRequirementResult.
        The error code when status is 'Failed'

        :param error_code: The error_code of this CapacityPlanStaffingRequirementResult.
        :type: str
        """
        if isinstance(error_code, int):
            error_code = str(error_code)
        allowed_values = ["TimedOut", "NoData", "ClientDataInvalid", "ConfigurationInvalid", "RequirementsFailed"]
        if error_code.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for error_code -> " + error_code)
            self._error_code = "outdated_sdk_version"
        else:
            self._error_code = error_code

    @property
    def download_url(self) -> str:
        """
        Gets the download_url of this CapacityPlanStaffingRequirementResult.
        The URL to get the requirements results for the capacity plan. It will be populated if the status is 'Complete'

        :return: The download_url of this CapacityPlanStaffingRequirementResult.
        :rtype: str
        """
        return self._download_url

    @download_url.setter
    def download_url(self, download_url: str) -> None:
        """
        Sets the download_url of this CapacityPlanStaffingRequirementResult.
        The URL to get the requirements results for the capacity plan. It will be populated if the status is 'Complete'

        :param download_url: The download_url of this CapacityPlanStaffingRequirementResult.
        :type: str
        """
        

        self._download_url = download_url

    @property
    def download_template(self) -> 'StaffingRequirementResultResponseTemplate':
        """
        Gets the download_template of this CapacityPlanStaffingRequirementResult.
        Staffing requirement results always come through downloadUrl, the schema included here is just for documentation

        :return: The download_template of this CapacityPlanStaffingRequirementResult.
        :rtype: StaffingRequirementResultResponseTemplate
        """
        return self._download_template

    @download_template.setter
    def download_template(self, download_template: 'StaffingRequirementResultResponseTemplate') -> None:
        """
        Sets the download_template of this CapacityPlanStaffingRequirementResult.
        Staffing requirement results always come through downloadUrl, the schema included here is just for documentation

        :param download_template: The download_template of this CapacityPlanStaffingRequirementResult.
        :type: StaffingRequirementResultResponseTemplate
        """
        

        self._download_template = download_template

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

