# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import CapacityPlanningRequirementsResultTopicBusinessUnit
    from . import CapacityPlanningRequirementsResultTopicCapacityPlanReference

class CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'capacity_plan': 'CapacityPlanningRequirementsResultTopicCapacityPlanReference',
            'business_unit': 'CapacityPlanningRequirementsResultTopicBusinessUnit',
            'status': 'str',
            'reference_business_unit_date': 'datetime',
            'granularity': 'str',
            'download_url': 'str',
            'error_code': 'str'
        }

        self.attribute_map = {
            'capacity_plan': 'capacityPlan',
            'business_unit': 'businessUnit',
            'status': 'status',
            'reference_business_unit_date': 'referenceBusinessUnitDate',
            'granularity': 'granularity',
            'download_url': 'downloadUrl',
            'error_code': 'errorCode'
        }

        self._capacity_plan = None
        self._business_unit = None
        self._status = None
        self._reference_business_unit_date = None
        self._granularity = None
        self._download_url = None
        self._error_code = None

    @property
    def capacity_plan(self) -> 'CapacityPlanningRequirementsResultTopicCapacityPlanReference':
        """
        Gets the capacity_plan of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.


        :return: The capacity_plan of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.
        :rtype: CapacityPlanningRequirementsResultTopicCapacityPlanReference
        """
        return self._capacity_plan

    @capacity_plan.setter
    def capacity_plan(self, capacity_plan: 'CapacityPlanningRequirementsResultTopicCapacityPlanReference') -> None:
        """
        Sets the capacity_plan of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.


        :param capacity_plan: The capacity_plan of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.
        :type: CapacityPlanningRequirementsResultTopicCapacityPlanReference
        """
        

        self._capacity_plan = capacity_plan

    @property
    def business_unit(self) -> 'CapacityPlanningRequirementsResultTopicBusinessUnit':
        """
        Gets the business_unit of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.


        :return: The business_unit of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.
        :rtype: CapacityPlanningRequirementsResultTopicBusinessUnit
        """
        return self._business_unit

    @business_unit.setter
    def business_unit(self, business_unit: 'CapacityPlanningRequirementsResultTopicBusinessUnit') -> None:
        """
        Sets the business_unit of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.


        :param business_unit: The business_unit of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.
        :type: CapacityPlanningRequirementsResultTopicBusinessUnit
        """
        

        self._business_unit = business_unit

    @property
    def status(self) -> str:
        """
        Gets the status of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.


        :return: The status of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.


        :param status: The status of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Processing", "Complete", "Canceled", "Error"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def reference_business_unit_date(self) -> datetime:
        """
        Gets the reference_business_unit_date of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.


        :return: The reference_business_unit_date of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.
        :rtype: datetime
        """
        return self._reference_business_unit_date

    @reference_business_unit_date.setter
    def reference_business_unit_date(self, reference_business_unit_date: datetime) -> None:
        """
        Sets the reference_business_unit_date of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.


        :param reference_business_unit_date: The reference_business_unit_date of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.
        :type: datetime
        """
        

        self._reference_business_unit_date = reference_business_unit_date

    @property
    def granularity(self) -> str:
        """
        Gets the granularity of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.


        :return: The granularity of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.
        :rtype: str
        """
        return self._granularity

    @granularity.setter
    def granularity(self, granularity: str) -> None:
        """
        Sets the granularity of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.


        :param granularity: The granularity of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.
        :type: str
        """
        if isinstance(granularity, int):
            granularity = str(granularity)
        allowed_values = ["Weekly"]
        if granularity.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for granularity -> " + granularity)
            self._granularity = "outdated_sdk_version"
        else:
            self._granularity = granularity

    @property
    def download_url(self) -> str:
        """
        Gets the download_url of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.


        :return: The download_url of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.
        :rtype: str
        """
        return self._download_url

    @download_url.setter
    def download_url(self, download_url: str) -> None:
        """
        Sets the download_url of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.


        :param download_url: The download_url of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.
        :type: str
        """
        

        self._download_url = download_url

    @property
    def error_code(self) -> str:
        """
        Gets the error_code of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.


        :return: The error_code of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code: str) -> None:
        """
        Sets the error_code of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.


        :param error_code: The error_code of this CapacityPlanningRequirementsResultTopicStaffingRequirementsNotification.
        :type: str
        """
        if isinstance(error_code, int):
            error_code = str(error_code)
        allowed_values = ["TimedOut", "NoData", "ClientDataInvalid", "ConfigurationInvalid", "RequirementsFailed"]
        if error_code.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for error_code -> " + error_code)
            self._error_code = "outdated_sdk_version"
        else:
            self._error_code = error_code

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

