# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import ChatReaction
    from . import Entity

class ChatMessageResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ChatMessageResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'to_jid': 'str',
            'jid': 'str',
            'body': 'str',
            'mentions': 'dict(str, str)',
            'edited': 'bool',
            'attachment_deleted': 'bool',
            'file_uri': 'str',
            'thread': 'Entity',
            'parent_thread': 'Entity',
            'user': 'AddressableEntityRef',
            'to_user': 'AddressableEntityRef',
            'reactions': 'list[ChatReaction]'
        }

        self.attribute_map = {
            'id': 'id',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'to_jid': 'toJid',
            'jid': 'jid',
            'body': 'body',
            'mentions': 'mentions',
            'edited': 'edited',
            'attachment_deleted': 'attachmentDeleted',
            'file_uri': 'fileUri',
            'thread': 'thread',
            'parent_thread': 'parentThread',
            'user': 'user',
            'to_user': 'toUser',
            'reactions': 'reactions'
        }

        self._id = None
        self._date_created = None
        self._date_modified = None
        self._to_jid = None
        self._jid = None
        self._body = None
        self._mentions = None
        self._edited = None
        self._attachment_deleted = None
        self._file_uri = None
        self._thread = None
        self._parent_thread = None
        self._user = None
        self._to_user = None
        self._reactions = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ChatMessageResponse.
        The id of the message

        :return: The id of this ChatMessageResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ChatMessageResponse.
        The id of the message

        :param id: The id of this ChatMessageResponse.
        :type: str
        """
        

        self._id = id

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this ChatMessageResponse.
        Message's created time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this ChatMessageResponse.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this ChatMessageResponse.
        Message's created time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this ChatMessageResponse.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this ChatMessageResponse.
        Message's last updated time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this ChatMessageResponse.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this ChatMessageResponse.
        Message's last updated time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this ChatMessageResponse.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def to_jid(self) -> str:
        """
        Gets the to_jid of this ChatMessageResponse.
        Jid of message's recipient (roomJid or userJid)

        :return: The to_jid of this ChatMessageResponse.
        :rtype: str
        """
        return self._to_jid

    @to_jid.setter
    def to_jid(self, to_jid: str) -> None:
        """
        Sets the to_jid of this ChatMessageResponse.
        Jid of message's recipient (roomJid or userJid)

        :param to_jid: The to_jid of this ChatMessageResponse.
        :type: str
        """
        

        self._to_jid = to_jid

    @property
    def jid(self) -> str:
        """
        Gets the jid of this ChatMessageResponse.
        Jid of message's sender (userJid)

        :return: The jid of this ChatMessageResponse.
        :rtype: str
        """
        return self._jid

    @jid.setter
    def jid(self, jid: str) -> None:
        """
        Sets the jid of this ChatMessageResponse.
        Jid of message's sender (userJid)

        :param jid: The jid of this ChatMessageResponse.
        :type: str
        """
        

        self._jid = jid

    @property
    def body(self) -> str:
        """
        Gets the body of this ChatMessageResponse.
        Message's body

        :return: The body of this ChatMessageResponse.
        :rtype: str
        """
        return self._body

    @body.setter
    def body(self, body: str) -> None:
        """
        Sets the body of this ChatMessageResponse.
        Message's body

        :param body: The body of this ChatMessageResponse.
        :type: str
        """
        

        self._body = body

    @property
    def mentions(self) -> Dict[str, str]:
        """
        Gets the mentions of this ChatMessageResponse.
        Message's mentions

        :return: The mentions of this ChatMessageResponse.
        :rtype: dict(str, str)
        """
        return self._mentions

    @mentions.setter
    def mentions(self, mentions: Dict[str, str]) -> None:
        """
        Sets the mentions of this ChatMessageResponse.
        Message's mentions

        :param mentions: The mentions of this ChatMessageResponse.
        :type: dict(str, str)
        """
        

        self._mentions = mentions

    @property
    def edited(self) -> bool:
        """
        Gets the edited of this ChatMessageResponse.
        If message was edited

        :return: The edited of this ChatMessageResponse.
        :rtype: bool
        """
        return self._edited

    @edited.setter
    def edited(self, edited: bool) -> None:
        """
        Sets the edited of this ChatMessageResponse.
        If message was edited

        :param edited: The edited of this ChatMessageResponse.
        :type: bool
        """
        

        self._edited = edited

    @property
    def attachment_deleted(self) -> bool:
        """
        Gets the attachment_deleted of this ChatMessageResponse.
        If message's attachment was deleted

        :return: The attachment_deleted of this ChatMessageResponse.
        :rtype: bool
        """
        return self._attachment_deleted

    @attachment_deleted.setter
    def attachment_deleted(self, attachment_deleted: bool) -> None:
        """
        Sets the attachment_deleted of this ChatMessageResponse.
        If message's attachment was deleted

        :param attachment_deleted: The attachment_deleted of this ChatMessageResponse.
        :type: bool
        """
        

        self._attachment_deleted = attachment_deleted

    @property
    def file_uri(self) -> str:
        """
        Gets the file_uri of this ChatMessageResponse.
        URI of file attachment

        :return: The file_uri of this ChatMessageResponse.
        :rtype: str
        """
        return self._file_uri

    @file_uri.setter
    def file_uri(self, file_uri: str) -> None:
        """
        Sets the file_uri of this ChatMessageResponse.
        URI of file attachment

        :param file_uri: The file_uri of this ChatMessageResponse.
        :type: str
        """
        

        self._file_uri = file_uri

    @property
    def thread(self) -> 'Entity':
        """
        Gets the thread of this ChatMessageResponse.
        The id for a thread this message corresponds to

        :return: The thread of this ChatMessageResponse.
        :rtype: Entity
        """
        return self._thread

    @thread.setter
    def thread(self, thread: 'Entity') -> None:
        """
        Sets the thread of this ChatMessageResponse.
        The id for a thread this message corresponds to

        :param thread: The thread of this ChatMessageResponse.
        :type: Entity
        """
        

        self._thread = thread

    @property
    def parent_thread(self) -> 'Entity':
        """
        Gets the parent_thread of this ChatMessageResponse.
        Parent thread id for thread replies

        :return: The parent_thread of this ChatMessageResponse.
        :rtype: Entity
        """
        return self._parent_thread

    @parent_thread.setter
    def parent_thread(self, parent_thread: 'Entity') -> None:
        """
        Sets the parent_thread of this ChatMessageResponse.
        Parent thread id for thread replies

        :param parent_thread: The parent_thread of this ChatMessageResponse.
        :type: Entity
        """
        

        self._parent_thread = parent_thread

    @property
    def user(self) -> 'AddressableEntityRef':
        """
        Gets the user of this ChatMessageResponse.
        The user who sent the message

        :return: The user of this ChatMessageResponse.
        :rtype: AddressableEntityRef
        """
        return self._user

    @user.setter
    def user(self, user: 'AddressableEntityRef') -> None:
        """
        Sets the user of this ChatMessageResponse.
        The user who sent the message

        :param user: The user of this ChatMessageResponse.
        :type: AddressableEntityRef
        """
        

        self._user = user

    @property
    def to_user(self) -> 'AddressableEntityRef':
        """
        Gets the to_user of this ChatMessageResponse.
        The receiving user of the message

        :return: The to_user of this ChatMessageResponse.
        :rtype: AddressableEntityRef
        """
        return self._to_user

    @to_user.setter
    def to_user(self, to_user: 'AddressableEntityRef') -> None:
        """
        Sets the to_user of this ChatMessageResponse.
        The receiving user of the message

        :param to_user: The to_user of this ChatMessageResponse.
        :type: AddressableEntityRef
        """
        

        self._to_user = to_user

    @property
    def reactions(self) -> List['ChatReaction']:
        """
        Gets the reactions of this ChatMessageResponse.
        The emoji reactions to this message

        :return: The reactions of this ChatMessageResponse.
        :rtype: list[ChatReaction]
        """
        return self._reactions

    @reactions.setter
    def reactions(self, reactions: List['ChatReaction']) -> None:
        """
        Sets the reactions of this ChatMessageResponse.
        The emoji reactions to this message

        :param reactions: The reactions of this ChatMessageResponse.
        :type: list[ChatReaction]
        """
        

        self._reactions = reactions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

