# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import OrganizationPresence
    from . import OutOfOffice

class ChatPresence(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ChatPresence - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'source': 'str',
            'organization_presence': 'OrganizationPresence',
            'system_presence': 'str',
            'message': 'str',
            'date_modified': 'datetime',
            'out_of_office': 'OutOfOffice'
        }

        self.attribute_map = {
            'source': 'source',
            'organization_presence': 'organizationPresence',
            'system_presence': 'systemPresence',
            'message': 'message',
            'date_modified': 'dateModified',
            'out_of_office': 'outOfOffice'
        }

        self._source = None
        self._organization_presence = None
        self._system_presence = None
        self._message = None
        self._date_modified = None
        self._out_of_office = None

    @property
    def source(self) -> str:
        """
        Gets the source of this ChatPresence.


        :return: The source of this ChatPresence.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source: str) -> None:
        """
        Sets the source of this ChatPresence.


        :param source: The source of this ChatPresence.
        :type: str
        """
        

        self._source = source

    @property
    def organization_presence(self) -> 'OrganizationPresence':
        """
        Gets the organization_presence of this ChatPresence.


        :return: The organization_presence of this ChatPresence.
        :rtype: OrganizationPresence
        """
        return self._organization_presence

    @organization_presence.setter
    def organization_presence(self, organization_presence: 'OrganizationPresence') -> None:
        """
        Sets the organization_presence of this ChatPresence.


        :param organization_presence: The organization_presence of this ChatPresence.
        :type: OrganizationPresence
        """
        

        self._organization_presence = organization_presence

    @property
    def system_presence(self) -> str:
        """
        Gets the system_presence of this ChatPresence.


        :return: The system_presence of this ChatPresence.
        :rtype: str
        """
        return self._system_presence

    @system_presence.setter
    def system_presence(self, system_presence: str) -> None:
        """
        Sets the system_presence of this ChatPresence.


        :param system_presence: The system_presence of this ChatPresence.
        :type: str
        """
        if isinstance(system_presence, int):
            system_presence = str(system_presence)
        allowed_values = ["Available", "Away", "Busy", "Offline", "Idle", "OnQueue", "Meal", "Training", "Meeting", "Break"]
        if system_presence.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for system_presence -> " + system_presence)
            self._system_presence = "outdated_sdk_version"
        else:
            self._system_presence = system_presence

    @property
    def message(self) -> str:
        """
        Gets the message of this ChatPresence.


        :return: The message of this ChatPresence.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message: str) -> None:
        """
        Sets the message of this ChatPresence.


        :param message: The message of this ChatPresence.
        :type: str
        """
        

        self._message = message

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this ChatPresence.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this ChatPresence.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this ChatPresence.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this ChatPresence.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def out_of_office(self) -> 'OutOfOffice':
        """
        Gets the out_of_office of this ChatPresence.


        :return: The out_of_office of this ChatPresence.
        :rtype: OutOfOffice
        """
        return self._out_of_office

    @out_of_office.setter
    def out_of_office(self, out_of_office: 'OutOfOffice') -> None:
        """
        Sets the out_of_office of this ChatPresence.


        :param out_of_office: The out_of_office of this ChatPresence.
        :type: OutOfOffice
        """
        

        self._out_of_office = out_of_office

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

