# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ClientPublicApiUsage
    from . import ErrorBody

class ClientPublicApiUsageResultsResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ClientPublicApiUsageResultsResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'query_status': 'str',
            'error_body': 'ErrorBody',
            'next_uri': 'str',
            'entities': 'list[ClientPublicApiUsage]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'query_status': 'queryStatus',
            'error_body': 'errorBody',
            'next_uri': 'nextUri',
            'entities': 'entities',
            'self_uri': 'selfUri'
        }

        self._name = None
        self._query_status = None
        self._error_body = None
        self._next_uri = None
        self._entities = None
        self._self_uri = None

    @property
    def name(self) -> str:
        """
        Gets the name of this ClientPublicApiUsageResultsResponse.


        :return: The name of this ClientPublicApiUsageResultsResponse.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this ClientPublicApiUsageResultsResponse.


        :param name: The name of this ClientPublicApiUsageResultsResponse.
        :type: str
        """
        

        self._name = name

    @property
    def query_status(self) -> str:
        """
        Gets the query_status of this ClientPublicApiUsageResultsResponse.
        The status of the query.

        :return: The query_status of this ClientPublicApiUsageResultsResponse.
        :rtype: str
        """
        return self._query_status

    @query_status.setter
    def query_status(self, query_status: str) -> None:
        """
        Sets the query_status of this ClientPublicApiUsageResultsResponse.
        The status of the query.

        :param query_status: The query_status of this ClientPublicApiUsageResultsResponse.
        :type: str
        """
        if isinstance(query_status, int):
            query_status = str(query_status)
        allowed_values = ["Queued", "Running", "Succeeded", "Failed", "Cancelled"]
        if query_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for query_status -> " + query_status)
            self._query_status = "outdated_sdk_version"
        else:
            self._query_status = query_status

    @property
    def error_body(self) -> 'ErrorBody':
        """
        Gets the error_body of this ClientPublicApiUsageResultsResponse.
        The reason for the failure. This will only be present if the query is in a FAILURE state but may not be included even if the state is FAILURE

        :return: The error_body of this ClientPublicApiUsageResultsResponse.
        :rtype: ErrorBody
        """
        return self._error_body

    @error_body.setter
    def error_body(self, error_body: 'ErrorBody') -> None:
        """
        Sets the error_body of this ClientPublicApiUsageResultsResponse.
        The reason for the failure. This will only be present if the query is in a FAILURE state but may not be included even if the state is FAILURE

        :param error_body: The error_body of this ClientPublicApiUsageResultsResponse.
        :type: ErrorBody
        """
        

        self._error_body = error_body

    @property
    def next_uri(self) -> str:
        """
        Gets the next_uri of this ClientPublicApiUsageResultsResponse.
        The uri to get the next set of results. Will only be included if there is another page to retrieve.

        :return: The next_uri of this ClientPublicApiUsageResultsResponse.
        :rtype: str
        """
        return self._next_uri

    @next_uri.setter
    def next_uri(self, next_uri: str) -> None:
        """
        Sets the next_uri of this ClientPublicApiUsageResultsResponse.
        The uri to get the next set of results. Will only be included if there is another page to retrieve.

        :param next_uri: The next_uri of this ClientPublicApiUsageResultsResponse.
        :type: str
        """
        

        self._next_uri = next_uri

    @property
    def entities(self) -> List['ClientPublicApiUsage']:
        """
        Gets the entities of this ClientPublicApiUsageResultsResponse.
        The results of the query.

        :return: The entities of this ClientPublicApiUsageResultsResponse.
        :rtype: list[ClientPublicApiUsage]
        """
        return self._entities

    @entities.setter
    def entities(self, entities: List['ClientPublicApiUsage']) -> None:
        """
        Sets the entities of this ClientPublicApiUsageResultsResponse.
        The results of the query.

        :param entities: The entities of this ClientPublicApiUsageResultsResponse.
        :type: list[ClientPublicApiUsage]
        """
        

        self._entities = entities

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ClientPublicApiUsageResultsResponse.
        The URI for this object

        :return: The self_uri of this ClientPublicApiUsageResultsResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ClientPublicApiUsageResultsResponse.
        The URI for this object

        :param self_uri: The self_uri of this ClientPublicApiUsageResultsResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

