# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import CollaborateChatAdhocMessageEventTopicCollaborateChatEntity

class CollaborateChatAdhocMessageEventTopicCollaborateChatMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CollaborateChatAdhocMessageEventTopicCollaborateChatMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'message_id': 'str',
            'created': 'str',
            'action_type': 'str',
            'body': 'str',
            'pcFrom': 'CollaborateChatAdhocMessageEventTopicCollaborateChatEntity',
            'to': 'CollaborateChatAdhocMessageEventTopicCollaborateChatEntity',
            'mentions': 'list[CollaborateChatAdhocMessageEventTopicCollaborateChatEntity]',
            'notify_all': 'bool',
            'reactions': 'dict(str, list[str])'
        }

        self.attribute_map = {
            'message_id': 'messageId',
            'created': 'created',
            'action_type': 'actionType',
            'body': 'body',
            'pcFrom': 'from',
            'to': 'to',
            'mentions': 'mentions',
            'notify_all': 'notifyAll',
            'reactions': 'reactions'
        }

        self._message_id = None
        self._created = None
        self._action_type = None
        self._body = None
        self._pcFrom = None
        self._to = None
        self._mentions = None
        self._notify_all = None
        self._reactions = None

    @property
    def message_id(self) -> str:
        """
        Gets the message_id of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.


        :return: The message_id of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.
        :rtype: str
        """
        return self._message_id

    @message_id.setter
    def message_id(self, message_id: str) -> None:
        """
        Sets the message_id of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.


        :param message_id: The message_id of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.
        :type: str
        """
        

        self._message_id = message_id

    @property
    def created(self) -> str:
        """
        Gets the created of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.


        :return: The created of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.
        :rtype: str
        """
        return self._created

    @created.setter
    def created(self, created: str) -> None:
        """
        Sets the created of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.


        :param created: The created of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.
        :type: str
        """
        

        self._created = created

    @property
    def action_type(self) -> str:
        """
        Gets the action_type of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.


        :return: The action_type of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.
        :rtype: str
        """
        return self._action_type

    @action_type.setter
    def action_type(self, action_type: str) -> None:
        """
        Sets the action_type of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.


        :param action_type: The action_type of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.
        :type: str
        """
        if isinstance(action_type, int):
            action_type = str(action_type)
        allowed_values = ["Create", "Edit", "Delete"]
        if action_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for action_type -> " + action_type)
            self._action_type = "outdated_sdk_version"
        else:
            self._action_type = action_type

    @property
    def body(self) -> str:
        """
        Gets the body of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.


        :return: The body of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.
        :rtype: str
        """
        return self._body

    @body.setter
    def body(self, body: str) -> None:
        """
        Sets the body of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.


        :param body: The body of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.
        :type: str
        """
        

        self._body = body

    @property
    def pcFrom(self) -> 'CollaborateChatAdhocMessageEventTopicCollaborateChatEntity':
        """
        Gets the pcFrom of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.


        :return: The pcFrom of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.
        :rtype: CollaborateChatAdhocMessageEventTopicCollaborateChatEntity
        """
        return self._pcFrom

    @pcFrom.setter
    def pcFrom(self, pcFrom: 'CollaborateChatAdhocMessageEventTopicCollaborateChatEntity') -> None:
        """
        Sets the pcFrom of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.


        :param pcFrom: The pcFrom of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.
        :type: CollaborateChatAdhocMessageEventTopicCollaborateChatEntity
        """
        

        self._pcFrom = pcFrom

    @property
    def to(self) -> 'CollaborateChatAdhocMessageEventTopicCollaborateChatEntity':
        """
        Gets the to of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.


        :return: The to of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.
        :rtype: CollaborateChatAdhocMessageEventTopicCollaborateChatEntity
        """
        return self._to

    @to.setter
    def to(self, to: 'CollaborateChatAdhocMessageEventTopicCollaborateChatEntity') -> None:
        """
        Sets the to of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.


        :param to: The to of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.
        :type: CollaborateChatAdhocMessageEventTopicCollaborateChatEntity
        """
        

        self._to = to

    @property
    def mentions(self) -> List['CollaborateChatAdhocMessageEventTopicCollaborateChatEntity']:
        """
        Gets the mentions of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.


        :return: The mentions of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.
        :rtype: list[CollaborateChatAdhocMessageEventTopicCollaborateChatEntity]
        """
        return self._mentions

    @mentions.setter
    def mentions(self, mentions: List['CollaborateChatAdhocMessageEventTopicCollaborateChatEntity']) -> None:
        """
        Sets the mentions of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.


        :param mentions: The mentions of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.
        :type: list[CollaborateChatAdhocMessageEventTopicCollaborateChatEntity]
        """
        

        self._mentions = mentions

    @property
    def notify_all(self) -> bool:
        """
        Gets the notify_all of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.


        :return: The notify_all of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.
        :rtype: bool
        """
        return self._notify_all

    @notify_all.setter
    def notify_all(self, notify_all: bool) -> None:
        """
        Sets the notify_all of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.


        :param notify_all: The notify_all of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.
        :type: bool
        """
        

        self._notify_all = notify_all

    @property
    def reactions(self) -> List[str]:
        """
        Gets the reactions of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.


        :return: The reactions of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.
        :rtype: dict(str, list[str])
        """
        return self._reactions

    @reactions.setter
    def reactions(self, reactions: List[str]) -> None:
        """
        Sets the reactions of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.


        :param reactions: The reactions of this CollaborateChatAdhocMessageEventTopicCollaborateChatMessage.
        :type: dict(str, list[str])
        """
        

        self._reactions = reactions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

