# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AlertNotification
    from . import AlertRuleProperties
    from . import AlertSummary
    from . import CommonRuleConditions
    from . import UserReference

class CommonAlert(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CommonAlert - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'user': 'UserReference',
            'rule': 'AlertRuleProperties',
            'notifications': 'list[AlertNotification]',
            'date_start': 'datetime',
            'date_end': 'datetime',
            'active': 'bool',
            'unread': 'bool',
            'wait_between_notification_ms': 'int',
            'muted': 'bool',
            'snoozed': 'bool',
            'date_muted_until': 'datetime',
            'date_snoozed_until': 'datetime',
            'conditions': 'CommonRuleConditions',
            'conversation_id': 'str',
            'alert_summary': 'AlertSummary',
            'rule_uri': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'user': 'user',
            'rule': 'rule',
            'notifications': 'notifications',
            'date_start': 'dateStart',
            'date_end': 'dateEnd',
            'active': 'active',
            'unread': 'unread',
            'wait_between_notification_ms': 'waitBetweenNotificationMs',
            'muted': 'muted',
            'snoozed': 'snoozed',
            'date_muted_until': 'dateMutedUntil',
            'date_snoozed_until': 'dateSnoozedUntil',
            'conditions': 'conditions',
            'conversation_id': 'conversationId',
            'alert_summary': 'alertSummary',
            'rule_uri': 'ruleUri',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._user = None
        self._rule = None
        self._notifications = None
        self._date_start = None
        self._date_end = None
        self._active = None
        self._unread = None
        self._wait_between_notification_ms = None
        self._muted = None
        self._snoozed = None
        self._date_muted_until = None
        self._date_snoozed_until = None
        self._conditions = None
        self._conversation_id = None
        self._alert_summary = None
        self._rule_uri = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this CommonAlert.
        The globally unique identifier for the object.

        :return: The id of this CommonAlert.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this CommonAlert.
        The globally unique identifier for the object.

        :param id: The id of this CommonAlert.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this CommonAlert.


        :return: The name of this CommonAlert.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this CommonAlert.


        :param name: The name of this CommonAlert.
        :type: str
        """
        

        self._name = name

    @property
    def user(self) -> 'UserReference':
        """
        Gets the user of this CommonAlert.
        The user who created the rule that triggered the alert.

        :return: The user of this CommonAlert.
        :rtype: UserReference
        """
        return self._user

    @user.setter
    def user(self, user: 'UserReference') -> None:
        """
        Sets the user of this CommonAlert.
        The user who created the rule that triggered the alert.

        :param user: The user of this CommonAlert.
        :type: UserReference
        """
        

        self._user = user

    @property
    def rule(self) -> 'AlertRuleProperties':
        """
        Gets the rule of this CommonAlert.
        The properties of the rule that triggered the alert.

        :return: The rule of this CommonAlert.
        :rtype: AlertRuleProperties
        """
        return self._rule

    @rule.setter
    def rule(self, rule: 'AlertRuleProperties') -> None:
        """
        Sets the rule of this CommonAlert.
        The properties of the rule that triggered the alert.

        :param rule: The rule of this CommonAlert.
        :type: AlertRuleProperties
        """
        

        self._rule = rule

    @property
    def notifications(self) -> List['AlertNotification']:
        """
        Gets the notifications of this CommonAlert.
        The collection of notification methods and the ids of users who were notified by those methods.

        :return: The notifications of this CommonAlert.
        :rtype: list[AlertNotification]
        """
        return self._notifications

    @notifications.setter
    def notifications(self, notifications: List['AlertNotification']) -> None:
        """
        Sets the notifications of this CommonAlert.
        The collection of notification methods and the ids of users who were notified by those methods.

        :param notifications: The notifications of this CommonAlert.
        :type: list[AlertNotification]
        """
        

        self._notifications = notifications

    @property
    def date_start(self) -> datetime:
        """
        Gets the date_start of this CommonAlert.
        The timestamp of when the alert was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_start of this CommonAlert.
        :rtype: datetime
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start: datetime) -> None:
        """
        Sets the date_start of this CommonAlert.
        The timestamp of when the alert was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_start: The date_start of this CommonAlert.
        :type: datetime
        """
        

        self._date_start = date_start

    @property
    def date_end(self) -> datetime:
        """
        Gets the date_end of this CommonAlert.
        The timestamp of when the alert ended. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_end of this CommonAlert.
        :rtype: datetime
        """
        return self._date_end

    @date_end.setter
    def date_end(self, date_end: datetime) -> None:
        """
        Sets the date_end of this CommonAlert.
        The timestamp of when the alert ended. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_end: The date_end of this CommonAlert.
        :type: datetime
        """
        

        self._date_end = date_end

    @property
    def active(self) -> bool:
        """
        Gets the active of this CommonAlert.
        Indicates if an alert is currently active.

        :return: The active of this CommonAlert.
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active: bool) -> None:
        """
        Sets the active of this CommonAlert.
        Indicates if an alert is currently active.

        :param active: The active of this CommonAlert.
        :type: bool
        """
        

        self._active = active

    @property
    def unread(self) -> bool:
        """
        Gets the unread of this CommonAlert.
        Indicates if an alert has not been read.

        :return: The unread of this CommonAlert.
        :rtype: bool
        """
        return self._unread

    @unread.setter
    def unread(self, unread: bool) -> None:
        """
        Sets the unread of this CommonAlert.
        Indicates if an alert has not been read.

        :param unread: The unread of this CommonAlert.
        :type: bool
        """
        

        self._unread = unread

    @property
    def wait_between_notification_ms(self) -> int:
        """
        Gets the wait_between_notification_ms of this CommonAlert.
        The amount of time to wait between notification. Time is in milliseconds.

        :return: The wait_between_notification_ms of this CommonAlert.
        :rtype: int
        """
        return self._wait_between_notification_ms

    @wait_between_notification_ms.setter
    def wait_between_notification_ms(self, wait_between_notification_ms: int) -> None:
        """
        Sets the wait_between_notification_ms of this CommonAlert.
        The amount of time to wait between notification. Time is in milliseconds.

        :param wait_between_notification_ms: The wait_between_notification_ms of this CommonAlert.
        :type: int
        """
        

        self._wait_between_notification_ms = wait_between_notification_ms

    @property
    def muted(self) -> bool:
        """
        Gets the muted of this CommonAlert.
        Flag indicating if the alert is in a muted state.

        :return: The muted of this CommonAlert.
        :rtype: bool
        """
        return self._muted

    @muted.setter
    def muted(self, muted: bool) -> None:
        """
        Sets the muted of this CommonAlert.
        Flag indicating if the alert is in a muted state.

        :param muted: The muted of this CommonAlert.
        :type: bool
        """
        

        self._muted = muted

    @property
    def snoozed(self) -> bool:
        """
        Gets the snoozed of this CommonAlert.
        Flag indicating if the alert is in a snoozed state.

        :return: The snoozed of this CommonAlert.
        :rtype: bool
        """
        return self._snoozed

    @snoozed.setter
    def snoozed(self, snoozed: bool) -> None:
        """
        Sets the snoozed of this CommonAlert.
        Flag indicating if the alert is in a snoozed state.

        :param snoozed: The snoozed of this CommonAlert.
        :type: bool
        """
        

        self._snoozed = snoozed

    @property
    def date_muted_until(self) -> datetime:
        """
        Gets the date_muted_until of this CommonAlert.
        Timestamp of when the mute status of the alert should end. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_muted_until of this CommonAlert.
        :rtype: datetime
        """
        return self._date_muted_until

    @date_muted_until.setter
    def date_muted_until(self, date_muted_until: datetime) -> None:
        """
        Sets the date_muted_until of this CommonAlert.
        Timestamp of when the mute status of the alert should end. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_muted_until: The date_muted_until of this CommonAlert.
        :type: datetime
        """
        

        self._date_muted_until = date_muted_until

    @property
    def date_snoozed_until(self) -> datetime:
        """
        Gets the date_snoozed_until of this CommonAlert.
        Timestamp of when the snooze status of the alert should end. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_snoozed_until of this CommonAlert.
        :rtype: datetime
        """
        return self._date_snoozed_until

    @date_snoozed_until.setter
    def date_snoozed_until(self, date_snoozed_until: datetime) -> None:
        """
        Sets the date_snoozed_until of this CommonAlert.
        Timestamp of when the snooze status of the alert should end. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_snoozed_until: The date_snoozed_until of this CommonAlert.
        :type: datetime
        """
        

        self._date_snoozed_until = date_snoozed_until

    @property
    def conditions(self) -> 'CommonRuleConditions':
        """
        Gets the conditions of this CommonAlert.
        The conditions that make up the rule.

        :return: The conditions of this CommonAlert.
        :rtype: CommonRuleConditions
        """
        return self._conditions

    @conditions.setter
    def conditions(self, conditions: 'CommonRuleConditions') -> None:
        """
        Sets the conditions of this CommonAlert.
        The conditions that make up the rule.

        :param conditions: The conditions of this CommonAlert.
        :type: CommonRuleConditions
        """
        

        self._conditions = conditions

    @property
    def conversation_id(self) -> str:
        """
        Gets the conversation_id of this CommonAlert.
        The id of the conversation instance that caused the alert to trigger.

        :return: The conversation_id of this CommonAlert.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id: str) -> None:
        """
        Sets the conversation_id of this CommonAlert.
        The id of the conversation instance that caused the alert to trigger.

        :param conversation_id: The conversation_id of this CommonAlert.
        :type: str
        """
        

        self._conversation_id = conversation_id

    @property
    def alert_summary(self) -> 'AlertSummary':
        """
        Gets the alert_summary of this CommonAlert.
        Summary of the alert status of the entities defined in the conditions.  Is set when rule has instance-based or team member based rule predicates

        :return: The alert_summary of this CommonAlert.
        :rtype: AlertSummary
        """
        return self._alert_summary

    @alert_summary.setter
    def alert_summary(self, alert_summary: 'AlertSummary') -> None:
        """
        Sets the alert_summary of this CommonAlert.
        Summary of the alert status of the entities defined in the conditions.  Is set when rule has instance-based or team member based rule predicates

        :param alert_summary: The alert_summary of this CommonAlert.
        :type: AlertSummary
        """
        

        self._alert_summary = alert_summary

    @property
    def rule_uri(self) -> str:
        """
        Gets the rule_uri of this CommonAlert.


        :return: The rule_uri of this CommonAlert.
        :rtype: str
        """
        return self._rule_uri

    @rule_uri.setter
    def rule_uri(self, rule_uri: str) -> None:
        """
        Sets the rule_uri of this CommonAlert.


        :param rule_uri: The rule_uri of this CommonAlert.
        :type: str
        """
        

        self._rule_uri = rule_uri

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this CommonAlert.
        The URI for this object

        :return: The self_uri of this CommonAlert.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this CommonAlert.
        The URI for this object

        :param self_uri: The self_uri of this CommonAlert.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

