# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ConditionalGroupActivationCondition
    from . import MemberGroup

class ConditionalGroupActivationRule(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ConditionalGroupActivationRule - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'conditions': 'list[ConditionalGroupActivationCondition]',
            'condition_expression': 'str',
            'groups': 'list[MemberGroup]'
        }

        self.attribute_map = {
            'conditions': 'conditions',
            'condition_expression': 'conditionExpression',
            'groups': 'groups'
        }

        self._conditions = None
        self._condition_expression = None
        self._groups = None

    @property
    def conditions(self) -> List['ConditionalGroupActivationCondition']:
        """
        Gets the conditions of this ConditionalGroupActivationRule.
        The list of conditions used in this rule

        :return: The conditions of this ConditionalGroupActivationRule.
        :rtype: list[ConditionalGroupActivationCondition]
        """
        return self._conditions

    @conditions.setter
    def conditions(self, conditions: List['ConditionalGroupActivationCondition']) -> None:
        """
        Sets the conditions of this ConditionalGroupActivationRule.
        The list of conditions used in this rule

        :param conditions: The conditions of this ConditionalGroupActivationRule.
        :type: list[ConditionalGroupActivationCondition]
        """
        

        self._conditions = conditions

    @property
    def condition_expression(self) -> str:
        """
        Gets the condition_expression of this ConditionalGroupActivationRule.
        A string expression that defines the relationships of conditions in this rule

        :return: The condition_expression of this ConditionalGroupActivationRule.
        :rtype: str
        """
        return self._condition_expression

    @condition_expression.setter
    def condition_expression(self, condition_expression: str) -> None:
        """
        Sets the condition_expression of this ConditionalGroupActivationRule.
        A string expression that defines the relationships of conditions in this rule

        :param condition_expression: The condition_expression of this ConditionalGroupActivationRule.
        :type: str
        """
        

        self._condition_expression = condition_expression

    @property
    def groups(self) -> List['MemberGroup']:
        """
        Gets the groups of this ConditionalGroupActivationRule.
        The group(s) that this rule activates (if rule evaluates as true) or deactivates (if rule evaluates as false)

        :return: The groups of this ConditionalGroupActivationRule.
        :rtype: list[MemberGroup]
        """
        return self._groups

    @groups.setter
    def groups(self, groups: List['MemberGroup']) -> None:
        """
        Sets the groups of this ConditionalGroupActivationRule.
        The group(s) that this rule activates (if rule evaluates as true) or deactivates (if rule evaluates as false)

        :param groups: The groups of this ConditionalGroupActivationRule.
        :type: list[MemberGroup]
        """
        

        self._groups = groups

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

