# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import ContactImportJobMetadata
    from . import StarrableDivision

class ContactImportJobResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContactImportJobResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'status': 'str',
            'status_details': 'str',
            'execution_step': 'str',
            'metadata': 'ContactImportJobMetadata',
            'date_created': 'datetime',
            'division': 'StarrableDivision',
            'self_uri': 'str',
            'settings': 'AddressableEntityRef'
        }

        self.attribute_map = {
            'id': 'id',
            'status': 'status',
            'status_details': 'statusDetails',
            'execution_step': 'executionStep',
            'metadata': 'metadata',
            'date_created': 'dateCreated',
            'division': 'division',
            'self_uri': 'selfUri',
            'settings': 'settings'
        }

        self._id = None
        self._status = None
        self._status_details = None
        self._execution_step = None
        self._metadata = None
        self._date_created = None
        self._division = None
        self._self_uri = None
        self._settings = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ContactImportJobResponse.
        The globally unique identifier for the object.

        :return: The id of this ContactImportJobResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ContactImportJobResponse.
        The globally unique identifier for the object.

        :param id: The id of this ContactImportJobResponse.
        :type: str
        """
        

        self._id = id

    @property
    def status(self) -> str:
        """
        Gets the status of this ContactImportJobResponse.


        :return: The status of this ContactImportJobResponse.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this ContactImportJobResponse.


        :param status: The status of this ContactImportJobResponse.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Created", "Running", "Completed", "Failed", "Cancelled"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def status_details(self) -> str:
        """
        Gets the status_details of this ContactImportJobResponse.
        Detailed description for JobStatus.

        :return: The status_details of this ContactImportJobResponse.
        :rtype: str
        """
        return self._status_details

    @status_details.setter
    def status_details(self, status_details: str) -> None:
        """
        Sets the status_details of this ContactImportJobResponse.
        Detailed description for JobStatus.

        :param status_details: The status_details of this ContactImportJobResponse.
        :type: str
        """
        

        self._status_details = status_details

    @property
    def execution_step(self) -> str:
        """
        Gets the execution_step of this ContactImportJobResponse.
        Detailed description for the Job execution state

        :return: The execution_step of this ContactImportJobResponse.
        :rtype: str
        """
        return self._execution_step

    @execution_step.setter
    def execution_step(self, execution_step: str) -> None:
        """
        Sets the execution_step of this ContactImportJobResponse.
        Detailed description for the Job execution state

        :param execution_step: The execution_step of this ContactImportJobResponse.
        :type: str
        """
        if isinstance(execution_step, int):
            execution_step = str(execution_step)
        allowed_values = ["Validating", "Validated", "Importing"]
        if execution_step.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for execution_step -> " + execution_step)
            self._execution_step = "outdated_sdk_version"
        else:
            self._execution_step = execution_step

    @property
    def metadata(self) -> 'ContactImportJobMetadata':
        """
        Gets the metadata of this ContactImportJobResponse.
        Metadata for the job

        :return: The metadata of this ContactImportJobResponse.
        :rtype: ContactImportJobMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata: 'ContactImportJobMetadata') -> None:
        """
        Sets the metadata of this ContactImportJobResponse.
        Metadata for the job

        :param metadata: The metadata of this ContactImportJobResponse.
        :type: ContactImportJobMetadata
        """
        

        self._metadata = metadata

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this ContactImportJobResponse.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this ContactImportJobResponse.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this ContactImportJobResponse.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this ContactImportJobResponse.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def division(self) -> 'StarrableDivision':
        """
        Gets the division of this ContactImportJobResponse.
        Division for the job

        :return: The division of this ContactImportJobResponse.
        :rtype: StarrableDivision
        """
        return self._division

    @division.setter
    def division(self, division: 'StarrableDivision') -> None:
        """
        Sets the division of this ContactImportJobResponse.
        Division for the job

        :param division: The division of this ContactImportJobResponse.
        :type: StarrableDivision
        """
        

        self._division = division

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ContactImportJobResponse.
        The URI for this object

        :return: The self_uri of this ContactImportJobResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ContactImportJobResponse.
        The URI for this object

        :param self_uri: The self_uri of this ContactImportJobResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    @property
    def settings(self) -> 'AddressableEntityRef':
        """
        Gets the settings of this ContactImportJobResponse.
        Settings

        :return: The settings of this ContactImportJobResponse.
        :rtype: AddressableEntityRef
        """
        return self._settings

    @settings.setter
    def settings(self, settings: 'AddressableEntityRef') -> None:
        """
        Sets the settings of this ContactImportJobResponse.
        Settings

        :param settings: The settings of this ContactImportJobResponse.
        :type: AddressableEntityRef
        """
        

        self._settings = settings

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

