# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ContactImportField

class ContactImportSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContactImportSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'matching_criteria': 'list[str]',
            'merge_contacts': 'bool',
            'external_source_id': 'str',
            'import_fields': 'list[ContactImportField]',
            'date_created': 'datetime',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'matching_criteria': 'matchingCriteria',
            'merge_contacts': 'mergeContacts',
            'external_source_id': 'externalSourceId',
            'import_fields': 'importFields',
            'date_created': 'dateCreated',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._matching_criteria = None
        self._merge_contacts = None
        self._external_source_id = None
        self._import_fields = None
        self._date_created = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ContactImportSettings.
        The globally unique identifier for the object.

        :return: The id of this ContactImportSettings.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ContactImportSettings.
        The globally unique identifier for the object.

        :param id: The id of this ContactImportSettings.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this ContactImportSettings.
        Display name for the settings

        :return: The name of this ContactImportSettings.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this ContactImportSettings.
        Display name for the settings

        :param name: The name of this ContactImportSettings.
        :type: str
        """
        

        self._name = name

    @property
    def matching_criteria(self) -> List[str]:
        """
        Gets the matching_criteria of this ContactImportSettings.
        Which fields you want to identity resolution based on. (e.g.: Email, Phone). It can be empty, populated only one of them or it can be both for now. The order of the items is important for identity resolution

        :return: The matching_criteria of this ContactImportSettings.
        :rtype: list[str]
        """
        return self._matching_criteria

    @matching_criteria.setter
    def matching_criteria(self, matching_criteria: List[str]) -> None:
        """
        Sets the matching_criteria of this ContactImportSettings.
        Which fields you want to identity resolution based on. (e.g.: Email, Phone). It can be empty, populated only one of them or it can be both for now. The order of the items is important for identity resolution

        :param matching_criteria: The matching_criteria of this ContactImportSettings.
        :type: list[str]
        """
        

        self._matching_criteria = matching_criteria

    @property
    def merge_contacts(self) -> bool:
        """
        Gets the merge_contacts of this ContactImportSettings.
        Decides what happens when a record already found in the system. Action will be Upsert or Merge

        :return: The merge_contacts of this ContactImportSettings.
        :rtype: bool
        """
        return self._merge_contacts

    @merge_contacts.setter
    def merge_contacts(self, merge_contacts: bool) -> None:
        """
        Sets the merge_contacts of this ContactImportSettings.
        Decides what happens when a record already found in the system. Action will be Upsert or Merge

        :param merge_contacts: The merge_contacts of this ContactImportSettings.
        :type: bool
        """
        

        self._merge_contacts = merge_contacts

    @property
    def external_source_id(self) -> str:
        """
        Gets the external_source_id of this ContactImportSettings.
        Define the corresponding source system by the customer, the customer can have different externalId source, they can collect this id from contact service

        :return: The external_source_id of this ContactImportSettings.
        :rtype: str
        """
        return self._external_source_id

    @external_source_id.setter
    def external_source_id(self, external_source_id: str) -> None:
        """
        Sets the external_source_id of this ContactImportSettings.
        Define the corresponding source system by the customer, the customer can have different externalId source, they can collect this id from contact service

        :param external_source_id: The external_source_id of this ContactImportSettings.
        :type: str
        """
        

        self._external_source_id = external_source_id

    @property
    def import_fields(self) -> List['ContactImportField']:
        """
        Gets the import_fields of this ContactImportSettings.
        Decides which field we need to send towards contact service

        :return: The import_fields of this ContactImportSettings.
        :rtype: list[ContactImportField]
        """
        return self._import_fields

    @import_fields.setter
    def import_fields(self, import_fields: List['ContactImportField']) -> None:
        """
        Sets the import_fields of this ContactImportSettings.
        Decides which field we need to send towards contact service

        :param import_fields: The import_fields of this ContactImportSettings.
        :type: list[ContactImportField]
        """
        

        self._import_fields = import_fields

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this ContactImportSettings.
        Creation date for the settings. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this ContactImportSettings.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this ContactImportSettings.
        Creation date for the settings. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this ContactImportSettings.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ContactImportSettings.
        The URI for this object

        :return: The self_uri of this ContactImportSettings.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ContactImportSettings.
        The URI for this object

        :param self_uri: The self_uri of this ContactImportSettings.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

