# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ErrorInfo

class ContactsBulkOperationJob(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContactsBulkOperationJob - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'state': 'str',
            'type': 'str',
            'total_records': 'int',
            'completed_records': 'int',
            'percent_complete': 'int',
            'failure_reason': 'ErrorInfo',
            'download_uri': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'state': 'state',
            'type': 'type',
            'total_records': 'totalRecords',
            'completed_records': 'completedRecords',
            'percent_complete': 'percentComplete',
            'failure_reason': 'failureReason',
            'download_uri': 'downloadURI',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._state = None
        self._type = None
        self._total_records = None
        self._completed_records = None
        self._percent_complete = None
        self._failure_reason = None
        self._download_uri = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ContactsBulkOperationJob.
        The globally unique job identifier.

        :return: The id of this ContactsBulkOperationJob.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ContactsBulkOperationJob.
        The globally unique job identifier.

        :param id: The id of this ContactsBulkOperationJob.
        :type: str
        """
        

        self._id = id

    @property
    def state(self) -> str:
        """
        Gets the state of this ContactsBulkOperationJob.
        The job state.

        :return: The state of this ContactsBulkOperationJob.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this ContactsBulkOperationJob.
        The job state.

        :param state: The state of this ContactsBulkOperationJob.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["InProgress", "Complete", "Failed"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def type(self) -> str:
        """
        Gets the type of this ContactsBulkOperationJob.
        The job type.

        :return: The type of this ContactsBulkOperationJob.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this ContactsBulkOperationJob.
        The job type.

        :param type: The type of this ContactsBulkOperationJob.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["BulkDelete", "BulkEdit"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def total_records(self) -> int:
        """
        Gets the total_records of this ContactsBulkOperationJob.
        Total records that will be impacted by the bulk operation.

        :return: The total_records of this ContactsBulkOperationJob.
        :rtype: int
        """
        return self._total_records

    @total_records.setter
    def total_records(self, total_records: int) -> None:
        """
        Sets the total_records of this ContactsBulkOperationJob.
        Total records that will be impacted by the bulk operation.

        :param total_records: The total_records of this ContactsBulkOperationJob.
        :type: int
        """
        

        self._total_records = total_records

    @property
    def completed_records(self) -> int:
        """
        Gets the completed_records of this ContactsBulkOperationJob.
        Amount of records that have been impacted by the bulk operation.

        :return: The completed_records of this ContactsBulkOperationJob.
        :rtype: int
        """
        return self._completed_records

    @completed_records.setter
    def completed_records(self, completed_records: int) -> None:
        """
        Sets the completed_records of this ContactsBulkOperationJob.
        Amount of records that have been impacted by the bulk operation.

        :param completed_records: The completed_records of this ContactsBulkOperationJob.
        :type: int
        """
        

        self._completed_records = completed_records

    @property
    def percent_complete(self) -> int:
        """
        Gets the percent_complete of this ContactsBulkOperationJob.
        Percentage of records that have been impacted by the bulk operation.

        :return: The percent_complete of this ContactsBulkOperationJob.
        :rtype: int
        """
        return self._percent_complete

    @percent_complete.setter
    def percent_complete(self, percent_complete: int) -> None:
        """
        Sets the percent_complete of this ContactsBulkOperationJob.
        Percentage of records that have been impacted by the bulk operation.

        :param percent_complete: The percent_complete of this ContactsBulkOperationJob.
        :type: int
        """
        

        self._percent_complete = percent_complete

    @property
    def failure_reason(self) -> 'ErrorInfo':
        """
        Gets the failure_reason of this ContactsBulkOperationJob.
        Information on failure reason.

        :return: The failure_reason of this ContactsBulkOperationJob.
        :rtype: ErrorInfo
        """
        return self._failure_reason

    @failure_reason.setter
    def failure_reason(self, failure_reason: 'ErrorInfo') -> None:
        """
        Sets the failure_reason of this ContactsBulkOperationJob.
        Information on failure reason.

        :param failure_reason: The failure_reason of this ContactsBulkOperationJob.
        :type: ErrorInfo
        """
        

        self._failure_reason = failure_reason

    @property
    def download_uri(self) -> str:
        """
        Gets the download_uri of this ContactsBulkOperationJob.
        URI to download the original backup contacts.

        :return: The download_uri of this ContactsBulkOperationJob.
        :rtype: str
        """
        return self._download_uri

    @download_uri.setter
    def download_uri(self, download_uri: str) -> None:
        """
        Sets the download_uri of this ContactsBulkOperationJob.
        URI to download the original backup contacts.

        :param download_uri: The download_uri of this ContactsBulkOperationJob.
        :type: str
        """
        

        self._download_uri = download_uri

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ContactsBulkOperationJob.
        The URI for this object

        :return: The self_uri of this ContactsBulkOperationJob.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ContactsBulkOperationJob.
        The URI for this object

        :param self_uri: The self_uri of this ContactsBulkOperationJob.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

