# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ContactsExportQueryConditions
    from . import DomainEntityRef

class ContactsExport(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContactsExport - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'division_ids': 'list[str]',
            'query_conditions': 'ContactsExportQueryConditions',
            'created_by': 'DomainEntityRef',
            'date_created': 'datetime',
            'status': 'str',
            'download_url': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'division_ids': 'divisionIds',
            'query_conditions': 'queryConditions',
            'created_by': 'createdBy',
            'date_created': 'dateCreated',
            'status': 'status',
            'download_url': 'downloadUrl',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._division_ids = None
        self._query_conditions = None
        self._created_by = None
        self._date_created = None
        self._status = None
        self._download_url = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ContactsExport.
        The globally unique identifier for the object.

        :return: The id of this ContactsExport.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ContactsExport.
        The globally unique identifier for the object.

        :param id: The id of this ContactsExport.
        :type: str
        """
        

        self._id = id

    @property
    def division_ids(self) -> List[str]:
        """
        Gets the division_ids of this ContactsExport.
        Division IDs of entities

        :return: The division_ids of this ContactsExport.
        :rtype: list[str]
        """
        return self._division_ids

    @division_ids.setter
    def division_ids(self, division_ids: List[str]) -> None:
        """
        Sets the division_ids of this ContactsExport.
        Division IDs of entities

        :param division_ids: The division_ids of this ContactsExport.
        :type: list[str]
        """
        

        self._division_ids = division_ids

    @property
    def query_conditions(self) -> 'ContactsExportQueryConditions':
        """
        Gets the query_conditions of this ContactsExport.
        Query conditions to apply on export

        :return: The query_conditions of this ContactsExport.
        :rtype: ContactsExportQueryConditions
        """
        return self._query_conditions

    @query_conditions.setter
    def query_conditions(self, query_conditions: 'ContactsExportQueryConditions') -> None:
        """
        Sets the query_conditions of this ContactsExport.
        Query conditions to apply on export

        :param query_conditions: The query_conditions of this ContactsExport.
        :type: ContactsExportQueryConditions
        """
        

        self._query_conditions = query_conditions

    @property
    def created_by(self) -> 'DomainEntityRef':
        """
        Gets the created_by of this ContactsExport.
        The user that created this request

        :return: The created_by of this ContactsExport.
        :rtype: DomainEntityRef
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'DomainEntityRef') -> None:
        """
        Sets the created_by of this ContactsExport.
        The user that created this request

        :param created_by: The created_by of this ContactsExport.
        :type: DomainEntityRef
        """
        

        self._created_by = created_by

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this ContactsExport.
        When the request was submitted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this ContactsExport.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this ContactsExport.
        When the request was submitted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this ContactsExport.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def status(self) -> str:
        """
        Gets the status of this ContactsExport.
        The status of the request

        :return: The status of this ContactsExport.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this ContactsExport.
        The status of the request

        :param status: The status of this ContactsExport.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["RUNNING", "SUCCEEDED", "FAILED"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def download_url(self) -> str:
        """
        Gets the download_url of this ContactsExport.
        The location where the results of the request can be retrieved

        :return: The download_url of this ContactsExport.
        :rtype: str
        """
        return self._download_url

    @download_url.setter
    def download_url(self, download_url: str) -> None:
        """
        Sets the download_url of this ContactsExport.
        The location where the results of the request can be retrieved

        :param download_url: The download_url of this ContactsExport.
        :type: str
        """
        

        self._download_url = download_url

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ContactsExport.
        The URI for this object

        :return: The self_uri of this ContactsExport.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ContactsExport.
        The URI for this object

        :param self_uri: The self_uri of this ContactsExport.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

