# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ContactBulkSearchCriteria

class ContactsExportRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContactsExportRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'contact_list_filter_id': 'str',
            'criteria': 'ContactBulkSearchCriteria',
            'contact_ids': 'list[str]'
        }

        self.attribute_map = {
            'contact_list_filter_id': 'contactListFilterId',
            'criteria': 'criteria',
            'contact_ids': 'contactIds'
        }

        self._contact_list_filter_id = None
        self._criteria = None
        self._contact_ids = None

    @property
    def contact_list_filter_id(self) -> str:
        """
        Gets the contact_list_filter_id of this ContactsExportRequest.
        Contact List Filter ID.

        :return: The contact_list_filter_id of this ContactsExportRequest.
        :rtype: str
        """
        return self._contact_list_filter_id

    @contact_list_filter_id.setter
    def contact_list_filter_id(self, contact_list_filter_id: str) -> None:
        """
        Sets the contact_list_filter_id of this ContactsExportRequest.
        Contact List Filter ID.

        :param contact_list_filter_id: The contact_list_filter_id of this ContactsExportRequest.
        :type: str
        """
        

        self._contact_list_filter_id = contact_list_filter_id

    @property
    def criteria(self) -> 'ContactBulkSearchCriteria':
        """
        Gets the criteria of this ContactsExportRequest.
        Criteria to filter the contacts by.

        :return: The criteria of this ContactsExportRequest.
        :rtype: ContactBulkSearchCriteria
        """
        return self._criteria

    @criteria.setter
    def criteria(self, criteria: 'ContactBulkSearchCriteria') -> None:
        """
        Sets the criteria of this ContactsExportRequest.
        Criteria to filter the contacts by.

        :param criteria: The criteria of this ContactsExportRequest.
        :type: ContactBulkSearchCriteria
        """
        

        self._criteria = criteria

    @property
    def contact_ids(self) -> List[str]:
        """
        Gets the contact_ids of this ContactsExportRequest.
        Contact IDs to be exported.

        :return: The contact_ids of this ContactsExportRequest.
        :rtype: list[str]
        """
        return self._contact_ids

    @contact_ids.setter
    def contact_ids(self, contact_ids: List[str]) -> None:
        """
        Sets the contact_ids of this ContactsExportRequest.
        Contact IDs to be exported.

        :param contact_ids: The contact_ids of this ContactsExportRequest.
        :type: list[str]
        """
        

        self._contact_ids = contact_ids

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

