# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ContestDataMetrics
    from . import ContestDataPrizes
    from . import ContestDataWinners

class ContestCompleteData(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContestCompleteData - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'date_end': 'date',
            'anonymization': 'str',
            'metrics': 'list[ContestDataMetrics]',
            'prizes': 'list[ContestDataPrizes]',
            'winners': 'list[ContestDataWinners]'
        }

        self.attribute_map = {
            'date_end': 'dateEnd',
            'anonymization': 'anonymization',
            'metrics': 'metrics',
            'prizes': 'prizes',
            'winners': 'winners'
        }

        self._date_end = None
        self._anonymization = None
        self._metrics = None
        self._prizes = None
        self._winners = None

    @property
    def date_end(self) -> date:
        """
        Gets the date_end of this ContestCompleteData.
        End date of the contest. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_end of this ContestCompleteData.
        :rtype: date
        """
        return self._date_end

    @date_end.setter
    def date_end(self, date_end: date) -> None:
        """
        Sets the date_end of this ContestCompleteData.
        End date of the contest. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_end: The date_end of this ContestCompleteData.
        :type: date
        """
        

        self._date_end = date_end

    @property
    def anonymization(self) -> str:
        """
        Gets the anonymization of this ContestCompleteData.
        Anonymization of the contest

        :return: The anonymization of this ContestCompleteData.
        :rtype: str
        """
        return self._anonymization

    @anonymization.setter
    def anonymization(self, anonymization: str) -> None:
        """
        Sets the anonymization of this ContestCompleteData.
        Anonymization of the contest

        :param anonymization: The anonymization of this ContestCompleteData.
        :type: str
        """
        if isinstance(anonymization, int):
            anonymization = str(anonymization)
        allowed_values = ["NoAnonymization", "All", "AllExceptTop"]
        if anonymization.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for anonymization -> " + anonymization)
            self._anonymization = "outdated_sdk_version"
        else:
            self._anonymization = anonymization

    @property
    def metrics(self) -> List['ContestDataMetrics']:
        """
        Gets the metrics of this ContestCompleteData.
        Metrics of the contest

        :return: The metrics of this ContestCompleteData.
        :rtype: list[ContestDataMetrics]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics: List['ContestDataMetrics']) -> None:
        """
        Sets the metrics of this ContestCompleteData.
        Metrics of the contest

        :param metrics: The metrics of this ContestCompleteData.
        :type: list[ContestDataMetrics]
        """
        

        self._metrics = metrics

    @property
    def prizes(self) -> List['ContestDataPrizes']:
        """
        Gets the prizes of this ContestCompleteData.
        Prizes of the contest

        :return: The prizes of this ContestCompleteData.
        :rtype: list[ContestDataPrizes]
        """
        return self._prizes

    @prizes.setter
    def prizes(self, prizes: List['ContestDataPrizes']) -> None:
        """
        Sets the prizes of this ContestCompleteData.
        Prizes of the contest

        :param prizes: The prizes of this ContestCompleteData.
        :type: list[ContestDataPrizes]
        """
        

        self._prizes = prizes

    @property
    def winners(self) -> List['ContestDataWinners']:
        """
        Gets the winners of this ContestCompleteData.
        Winners of the contest

        :return: The winners of this ContestCompleteData.
        :rtype: list[ContestDataWinners]
        """
        return self._winners

    @winners.setter
    def winners(self, winners: List['ContestDataWinners']) -> None:
        """
        Sets the winners of this ContestCompleteData.
        Winners of the contest

        :param winners: The winners of this ContestCompleteData.
        :type: list[ContestDataWinners]
        """
        

        self._winners = winners

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

