# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class ContestScoreRanked(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContestScoreRanked - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'score': 'float',
            'total_points': 'float',
            'percent_of_goal': 'float',
            'rank': 'int',
            'tier': 'int'
        }

        self.attribute_map = {
            'score': 'score',
            'total_points': 'totalPoints',
            'percent_of_goal': 'percentOfGoal',
            'rank': 'rank',
            'tier': 'tier'
        }

        self._score = None
        self._total_points = None
        self._percent_of_goal = None
        self._rank = None
        self._tier = None

    @property
    def score(self) -> float:
        """
        Gets the score of this ContestScoreRanked.
        The Contest score

        :return: The score of this ContestScoreRanked.
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score: float) -> None:
        """
        Sets the score of this ContestScoreRanked.
        The Contest score

        :param score: The score of this ContestScoreRanked.
        :type: float
        """
        

        self._score = score

    @property
    def total_points(self) -> float:
        """
        Gets the total_points of this ContestScoreRanked.
        The Contest totalPoints

        :return: The total_points of this ContestScoreRanked.
        :rtype: float
        """
        return self._total_points

    @total_points.setter
    def total_points(self, total_points: float) -> None:
        """
        Sets the total_points of this ContestScoreRanked.
        The Contest totalPoints

        :param total_points: The total_points of this ContestScoreRanked.
        :type: float
        """
        

        self._total_points = total_points

    @property
    def percent_of_goal(self) -> float:
        """
        Gets the percent_of_goal of this ContestScoreRanked.
        The Contest percentOfGoal

        :return: The percent_of_goal of this ContestScoreRanked.
        :rtype: float
        """
        return self._percent_of_goal

    @percent_of_goal.setter
    def percent_of_goal(self, percent_of_goal: float) -> None:
        """
        Sets the percent_of_goal of this ContestScoreRanked.
        The Contest percentOfGoal

        :param percent_of_goal: The percent_of_goal of this ContestScoreRanked.
        :type: float
        """
        

        self._percent_of_goal = percent_of_goal

    @property
    def rank(self) -> int:
        """
        Gets the rank of this ContestScoreRanked.
        The Contest Score rank

        :return: The rank of this ContestScoreRanked.
        :rtype: int
        """
        return self._rank

    @rank.setter
    def rank(self, rank: int) -> None:
        """
        Sets the rank of this ContestScoreRanked.
        The Contest Score rank

        :param rank: The rank of this ContestScoreRanked.
        :type: int
        """
        

        self._rank = rank

    @property
    def tier(self) -> int:
        """
        Gets the tier of this ContestScoreRanked.
        The Contest Score tier

        :return: The tier of this ContestScoreRanked.
        :rtype: int
        """
        return self._tier

    @tier.setter
    def tier(self, tier: int) -> None:
        """
        Sets the tier of this ContestScoreRanked.
        The Contest Score tier

        :param tier: The tier of this ContestScoreRanked.
        :type: int
        """
        

        self._tier = tier

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

