# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ContestMetricScoreRanked
    from . import ContestScoreRanked

class ContestScoresAgentTrend(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContestScoresAgentTrend - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'contest_score': 'ContestScoreRanked',
            'metric_scores': 'list[ContestMetricScoreRanked]',
            'disqualified': 'bool',
            'date_workday': 'date'
        }

        self.attribute_map = {
            'contest_score': 'contestScore',
            'metric_scores': 'metricScores',
            'disqualified': 'disqualified',
            'date_workday': 'dateWorkday'
        }

        self._contest_score = None
        self._metric_scores = None
        self._disqualified = None
        self._date_workday = None

    @property
    def contest_score(self) -> 'ContestScoreRanked':
        """
        Gets the contest_score of this ContestScoresAgentTrend.
        The Contest score

        :return: The contest_score of this ContestScoresAgentTrend.
        :rtype: ContestScoreRanked
        """
        return self._contest_score

    @contest_score.setter
    def contest_score(self, contest_score: 'ContestScoreRanked') -> None:
        """
        Sets the contest_score of this ContestScoresAgentTrend.
        The Contest score

        :param contest_score: The contest_score of this ContestScoresAgentTrend.
        :type: ContestScoreRanked
        """
        

        self._contest_score = contest_score

    @property
    def metric_scores(self) -> List['ContestMetricScoreRanked']:
        """
        Gets the metric_scores of this ContestScoresAgentTrend.
        The Contest metric scores

        :return: The metric_scores of this ContestScoresAgentTrend.
        :rtype: list[ContestMetricScoreRanked]
        """
        return self._metric_scores

    @metric_scores.setter
    def metric_scores(self, metric_scores: List['ContestMetricScoreRanked']) -> None:
        """
        Sets the metric_scores of this ContestScoresAgentTrend.
        The Contest metric scores

        :param metric_scores: The metric_scores of this ContestScoresAgentTrend.
        :type: list[ContestMetricScoreRanked]
        """
        

        self._metric_scores = metric_scores

    @property
    def disqualified(self) -> bool:
        """
        Gets the disqualified of this ContestScoresAgentTrend.
        Indicates whether an agent is disqualified or not

        :return: The disqualified of this ContestScoresAgentTrend.
        :rtype: bool
        """
        return self._disqualified

    @disqualified.setter
    def disqualified(self, disqualified: bool) -> None:
        """
        Sets the disqualified of this ContestScoresAgentTrend.
        Indicates whether an agent is disqualified or not

        :param disqualified: The disqualified of this ContestScoresAgentTrend.
        :type: bool
        """
        

        self._disqualified = disqualified

    @property
    def date_workday(self) -> date:
        """
        Gets the date_workday of this ContestScoresAgentTrend.
        Workday of the contest scores leaderboard. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_workday of this ContestScoresAgentTrend.
        :rtype: date
        """
        return self._date_workday

    @date_workday.setter
    def date_workday(self, date_workday: date) -> None:
        """
        Sets the date_workday of this ContestScoresAgentTrend.
        Workday of the contest scores leaderboard. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_workday: The date_workday of this ContestScoresAgentTrend.
        :type: date
        """
        

        self._date_workday = date_workday

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

