# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ContestMetrics
    from . import ContestPrizes
    from . import WritableDivision

class ContestsCreateRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContestsCreateRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'division': 'WritableDivision',
            'title': 'str',
            'description': 'str',
            'date_start': 'date',
            'date_end': 'date',
            'winning_criteria': 'str',
            'date_announced': 'datetime',
            'announcement_timezone': 'str',
            'anonymization': 'str',
            'metrics': 'list[ContestMetrics]',
            'prizes': 'list[ContestPrizes]',
            'profile_id': 'str',
            'participant_ids': 'list[str]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'division': 'division',
            'title': 'title',
            'description': 'description',
            'date_start': 'dateStart',
            'date_end': 'dateEnd',
            'winning_criteria': 'winningCriteria',
            'date_announced': 'dateAnnounced',
            'announcement_timezone': 'announcementTimezone',
            'anonymization': 'anonymization',
            'metrics': 'metrics',
            'prizes': 'prizes',
            'profile_id': 'profileId',
            'participant_ids': 'participantIds',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._division = None
        self._title = None
        self._description = None
        self._date_start = None
        self._date_end = None
        self._winning_criteria = None
        self._date_announced = None
        self._announcement_timezone = None
        self._anonymization = None
        self._metrics = None
        self._prizes = None
        self._profile_id = None
        self._participant_ids = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ContestsCreateRequest.
        The globally unique identifier for the object.

        :return: The id of this ContestsCreateRequest.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ContestsCreateRequest.
        The globally unique identifier for the object.

        :param id: The id of this ContestsCreateRequest.
        :type: str
        """
        

        self._id = id

    @property
    def division(self) -> 'WritableDivision':
        """
        Gets the division of this ContestsCreateRequest.
        The division for this performance profile associate to. Only set for DEFAULT profile.

        :return: The division of this ContestsCreateRequest.
        :rtype: WritableDivision
        """
        return self._division

    @division.setter
    def division(self, division: 'WritableDivision') -> None:
        """
        Sets the division of this ContestsCreateRequest.
        The division for this performance profile associate to. Only set for DEFAULT profile.

        :param division: The division of this ContestsCreateRequest.
        :type: WritableDivision
        """
        

        self._division = division

    @property
    def title(self) -> str:
        """
        Gets the title of this ContestsCreateRequest.
        The Contest title

        :return: The title of this ContestsCreateRequest.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this ContestsCreateRequest.
        The Contest title

        :param title: The title of this ContestsCreateRequest.
        :type: str
        """
        

        self._title = title

    @property
    def description(self) -> str:
        """
        Gets the description of this ContestsCreateRequest.
        The Contest description

        :return: The description of this ContestsCreateRequest.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this ContestsCreateRequest.
        The Contest description

        :param description: The description of this ContestsCreateRequest.
        :type: str
        """
        

        self._description = description

    @property
    def date_start(self) -> date:
        """
        Gets the date_start of this ContestsCreateRequest.
        Start date of the contest. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_start of this ContestsCreateRequest.
        :rtype: date
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start: date) -> None:
        """
        Sets the date_start of this ContestsCreateRequest.
        Start date of the contest. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_start: The date_start of this ContestsCreateRequest.
        :type: date
        """
        

        self._date_start = date_start

    @property
    def date_end(self) -> date:
        """
        Gets the date_end of this ContestsCreateRequest.
        End date of the contest. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_end of this ContestsCreateRequest.
        :rtype: date
        """
        return self._date_end

    @date_end.setter
    def date_end(self, date_end: date) -> None:
        """
        Sets the date_end of this ContestsCreateRequest.
        End date of the contest. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_end: The date_end of this ContestsCreateRequest.
        :type: date
        """
        

        self._date_end = date_end

    @property
    def winning_criteria(self) -> str:
        """
        Gets the winning_criteria of this ContestsCreateRequest.
        The Contest winning criteria

        :return: The winning_criteria of this ContestsCreateRequest.
        :rtype: str
        """
        return self._winning_criteria

    @winning_criteria.setter
    def winning_criteria(self, winning_criteria: str) -> None:
        """
        Sets the winning_criteria of this ContestsCreateRequest.
        The Contest winning criteria

        :param winning_criteria: The winning_criteria of this ContestsCreateRequest.
        :type: str
        """
        if isinstance(winning_criteria, int):
            winning_criteria = str(winning_criteria)
        allowed_values = ["HighestOverallScore", "HighestOverallPercentOfGoal"]
        if winning_criteria.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for winning_criteria -> " + winning_criteria)
            self._winning_criteria = "outdated_sdk_version"
        else:
            self._winning_criteria = winning_criteria

    @property
    def date_announced(self) -> datetime:
        """
        Gets the date_announced of this ContestsCreateRequest.
        The Contest's Announcement Datetime. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_announced of this ContestsCreateRequest.
        :rtype: datetime
        """
        return self._date_announced

    @date_announced.setter
    def date_announced(self, date_announced: datetime) -> None:
        """
        Sets the date_announced of this ContestsCreateRequest.
        The Contest's Announcement Datetime. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_announced: The date_announced of this ContestsCreateRequest.
        :type: datetime
        """
        

        self._date_announced = date_announced

    @property
    def announcement_timezone(self) -> str:
        """
        Gets the announcement_timezone of this ContestsCreateRequest.
        The Contest's Announcement Timezone. Valid values are strings of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London

        :return: The announcement_timezone of this ContestsCreateRequest.
        :rtype: str
        """
        return self._announcement_timezone

    @announcement_timezone.setter
    def announcement_timezone(self, announcement_timezone: str) -> None:
        """
        Sets the announcement_timezone of this ContestsCreateRequest.
        The Contest's Announcement Timezone. Valid values are strings of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London

        :param announcement_timezone: The announcement_timezone of this ContestsCreateRequest.
        :type: str
        """
        

        self._announcement_timezone = announcement_timezone

    @property
    def anonymization(self) -> str:
        """
        Gets the anonymization of this ContestsCreateRequest.
        The Contest anonymization

        :return: The anonymization of this ContestsCreateRequest.
        :rtype: str
        """
        return self._anonymization

    @anonymization.setter
    def anonymization(self, anonymization: str) -> None:
        """
        Sets the anonymization of this ContestsCreateRequest.
        The Contest anonymization

        :param anonymization: The anonymization of this ContestsCreateRequest.
        :type: str
        """
        if isinstance(anonymization, int):
            anonymization = str(anonymization)
        allowed_values = ["NoAnonymization", "All", "AllExceptTop"]
        if anonymization.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for anonymization -> " + anonymization)
            self._anonymization = "outdated_sdk_version"
        else:
            self._anonymization = anonymization

    @property
    def metrics(self) -> List['ContestMetrics']:
        """
        Gets the metrics of this ContestsCreateRequest.
        The Contest's Metrics

        :return: The metrics of this ContestsCreateRequest.
        :rtype: list[ContestMetrics]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics: List['ContestMetrics']) -> None:
        """
        Sets the metrics of this ContestsCreateRequest.
        The Contest's Metrics

        :param metrics: The metrics of this ContestsCreateRequest.
        :type: list[ContestMetrics]
        """
        

        self._metrics = metrics

    @property
    def prizes(self) -> List['ContestPrizes']:
        """
        Gets the prizes of this ContestsCreateRequest.
        The Contest Prizes

        :return: The prizes of this ContestsCreateRequest.
        :rtype: list[ContestPrizes]
        """
        return self._prizes

    @prizes.setter
    def prizes(self, prizes: List['ContestPrizes']) -> None:
        """
        Sets the prizes of this ContestsCreateRequest.
        The Contest Prizes

        :param prizes: The prizes of this ContestsCreateRequest.
        :type: list[ContestPrizes]
        """
        

        self._prizes = prizes

    @property
    def profile_id(self) -> str:
        """
        Gets the profile_id of this ContestsCreateRequest.
        The Contest profile

        :return: The profile_id of this ContestsCreateRequest.
        :rtype: str
        """
        return self._profile_id

    @profile_id.setter
    def profile_id(self, profile_id: str) -> None:
        """
        Sets the profile_id of this ContestsCreateRequest.
        The Contest profile

        :param profile_id: The profile_id of this ContestsCreateRequest.
        :type: str
        """
        

        self._profile_id = profile_id

    @property
    def participant_ids(self) -> List[str]:
        """
        Gets the participant_ids of this ContestsCreateRequest.
        The Contest's participants

        :return: The participant_ids of this ContestsCreateRequest.
        :rtype: list[str]
        """
        return self._participant_ids

    @participant_ids.setter
    def participant_ids(self, participant_ids: List[str]) -> None:
        """
        Sets the participant_ids of this ContestsCreateRequest.
        The Contest's participants

        :param participant_ids: The participant_ids of this ContestsCreateRequest.
        :type: list[str]
        """
        

        self._participant_ids = participant_ids

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ContestsCreateRequest.
        The URI for this object

        :return: The self_uri of this ContestsCreateRequest.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ContestsCreateRequest.
        The URI for this object

        :param self_uri: The self_uri of this ContestsCreateRequest.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

