# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ContestMetrics
    from . import ContestProfile
    from . import ContestRequesingParticipantDailyInfo

class ContestsEssentials(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContestsEssentials - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'title': 'str',
            'status': 'str',
            'date_start': 'date',
            'date_end': 'date',
            'profile': 'ContestProfile',
            'participant_count': 'int',
            'date_announced': 'datetime',
            'date_finalized': 'datetime',
            'date_cancelled': 'datetime',
            'date_modified': 'datetime',
            'date_scores_modified': 'datetime',
            'metrics': 'list[ContestMetrics]',
            'requesting_participant_contest_info': 'ContestRequesingParticipantDailyInfo',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'title': 'title',
            'status': 'status',
            'date_start': 'dateStart',
            'date_end': 'dateEnd',
            'profile': 'profile',
            'participant_count': 'participantCount',
            'date_announced': 'dateAnnounced',
            'date_finalized': 'dateFinalized',
            'date_cancelled': 'dateCancelled',
            'date_modified': 'dateModified',
            'date_scores_modified': 'dateScoresModified',
            'metrics': 'metrics',
            'requesting_participant_contest_info': 'requestingParticipantContestInfo',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._title = None
        self._status = None
        self._date_start = None
        self._date_end = None
        self._profile = None
        self._participant_count = None
        self._date_announced = None
        self._date_finalized = None
        self._date_cancelled = None
        self._date_modified = None
        self._date_scores_modified = None
        self._metrics = None
        self._requesting_participant_contest_info = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ContestsEssentials.
        The globally unique identifier for the object.

        :return: The id of this ContestsEssentials.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ContestsEssentials.
        The globally unique identifier for the object.

        :param id: The id of this ContestsEssentials.
        :type: str
        """
        

        self._id = id

    @property
    def title(self) -> str:
        """
        Gets the title of this ContestsEssentials.
        The Contest title

        :return: The title of this ContestsEssentials.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this ContestsEssentials.
        The Contest title

        :param title: The title of this ContestsEssentials.
        :type: str
        """
        

        self._title = title

    @property
    def status(self) -> str:
        """
        Gets the status of this ContestsEssentials.
        The Contest status

        :return: The status of this ContestsEssentials.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this ContestsEssentials.
        The Contest status

        :param status: The status of this ContestsEssentials.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Upcoming", "Ongoing", "Pending", "RecentlyCompleted", "Completed", "Cancelled"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def date_start(self) -> date:
        """
        Gets the date_start of this ContestsEssentials.
        Start date of the contest. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_start of this ContestsEssentials.
        :rtype: date
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start: date) -> None:
        """
        Sets the date_start of this ContestsEssentials.
        Start date of the contest. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_start: The date_start of this ContestsEssentials.
        :type: date
        """
        

        self._date_start = date_start

    @property
    def date_end(self) -> date:
        """
        Gets the date_end of this ContestsEssentials.
        End date of the contest. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_end of this ContestsEssentials.
        :rtype: date
        """
        return self._date_end

    @date_end.setter
    def date_end(self, date_end: date) -> None:
        """
        Sets the date_end of this ContestsEssentials.
        End date of the contest. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_end: The date_end of this ContestsEssentials.
        :type: date
        """
        

        self._date_end = date_end

    @property
    def profile(self) -> 'ContestProfile':
        """
        Gets the profile of this ContestsEssentials.
        The performance profile

        :return: The profile of this ContestsEssentials.
        :rtype: ContestProfile
        """
        return self._profile

    @profile.setter
    def profile(self, profile: 'ContestProfile') -> None:
        """
        Sets the profile of this ContestsEssentials.
        The performance profile

        :param profile: The profile of this ContestsEssentials.
        :type: ContestProfile
        """
        

        self._profile = profile

    @property
    def participant_count(self) -> int:
        """
        Gets the participant_count of this ContestsEssentials.
        The Number of participants in the contest

        :return: The participant_count of this ContestsEssentials.
        :rtype: int
        """
        return self._participant_count

    @participant_count.setter
    def participant_count(self, participant_count: int) -> None:
        """
        Sets the participant_count of this ContestsEssentials.
        The Number of participants in the contest

        :param participant_count: The participant_count of this ContestsEssentials.
        :type: int
        """
        

        self._participant_count = participant_count

    @property
    def date_announced(self) -> datetime:
        """
        Gets the date_announced of this ContestsEssentials.
        The Contest's Announcement datetime. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_announced of this ContestsEssentials.
        :rtype: datetime
        """
        return self._date_announced

    @date_announced.setter
    def date_announced(self, date_announced: datetime) -> None:
        """
        Sets the date_announced of this ContestsEssentials.
        The Contest's Announcement datetime. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_announced: The date_announced of this ContestsEssentials.
        :type: datetime
        """
        

        self._date_announced = date_announced

    @property
    def date_finalized(self) -> datetime:
        """
        Gets the date_finalized of this ContestsEssentials.
        The Contest's finalize datetime, returned when a contest is complete. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_finalized of this ContestsEssentials.
        :rtype: datetime
        """
        return self._date_finalized

    @date_finalized.setter
    def date_finalized(self, date_finalized: datetime) -> None:
        """
        Sets the date_finalized of this ContestsEssentials.
        The Contest's finalize datetime, returned when a contest is complete. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_finalized: The date_finalized of this ContestsEssentials.
        :type: datetime
        """
        

        self._date_finalized = date_finalized

    @property
    def date_cancelled(self) -> datetime:
        """
        Gets the date_cancelled of this ContestsEssentials.
        The Contest's cancelled datetime, returned when a contest is complete. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_cancelled of this ContestsEssentials.
        :rtype: datetime
        """
        return self._date_cancelled

    @date_cancelled.setter
    def date_cancelled(self, date_cancelled: datetime) -> None:
        """
        Sets the date_cancelled of this ContestsEssentials.
        The Contest's cancelled datetime, returned when a contest is complete. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_cancelled: The date_cancelled of this ContestsEssentials.
        :type: datetime
        """
        

        self._date_cancelled = date_cancelled

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this ContestsEssentials.
        The Contest's last modified datetime. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this ContestsEssentials.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this ContestsEssentials.
        The Contest's last modified datetime. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this ContestsEssentials.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def date_scores_modified(self) -> datetime:
        """
        Gets the date_scores_modified of this ContestsEssentials.
        The datetime the contest scores were last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_scores_modified of this ContestsEssentials.
        :rtype: datetime
        """
        return self._date_scores_modified

    @date_scores_modified.setter
    def date_scores_modified(self, date_scores_modified: datetime) -> None:
        """
        Sets the date_scores_modified of this ContestsEssentials.
        The datetime the contest scores were last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_scores_modified: The date_scores_modified of this ContestsEssentials.
        :type: datetime
        """
        

        self._date_scores_modified = date_scores_modified

    @property
    def metrics(self) -> List['ContestMetrics']:
        """
        Gets the metrics of this ContestsEssentials.
        The Contest's Metrics

        :return: The metrics of this ContestsEssentials.
        :rtype: list[ContestMetrics]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics: List['ContestMetrics']) -> None:
        """
        Sets the metrics of this ContestsEssentials.
        The Contest's Metrics

        :param metrics: The metrics of this ContestsEssentials.
        :type: list[ContestMetrics]
        """
        

        self._metrics = metrics

    @property
    def requesting_participant_contest_info(self) -> 'ContestRequesingParticipantDailyInfo':
        """
        Gets the requesting_participant_contest_info of this ContestsEssentials.
        The Most Recent Contest Info for the requesting participant

        :return: The requesting_participant_contest_info of this ContestsEssentials.
        :rtype: ContestRequesingParticipantDailyInfo
        """
        return self._requesting_participant_contest_info

    @requesting_participant_contest_info.setter
    def requesting_participant_contest_info(self, requesting_participant_contest_info: 'ContestRequesingParticipantDailyInfo') -> None:
        """
        Sets the requesting_participant_contest_info of this ContestsEssentials.
        The Most Recent Contest Info for the requesting participant

        :param requesting_participant_contest_info: The requesting_participant_contest_info of this ContestsEssentials.
        :type: ContestRequesingParticipantDailyInfo
        """
        

        self._requesting_participant_contest_info = requesting_participant_contest_info

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ContestsEssentials.
        The URI for this object

        :return: The self_uri of this ContestsEssentials.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ContestsEssentials.
        The URI for this object

        :param self_uri: The self_uri of this ContestsEssentials.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

