# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ContestDisqualifiedAgents
    from . import ContestMetrics
    from . import ContestPrizes
    from . import ContestProfile
    from . import ContestWinners
    from . import UserReference
    from . import WritableDivision

class ContestsResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContestsResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'division': 'WritableDivision',
            'title': 'str',
            'description': 'str',
            'date_start': 'date',
            'date_end': 'date',
            'winning_criteria': 'str',
            'date_announced': 'datetime',
            'announcement_timezone': 'str',
            'anonymization': 'str',
            'metrics': 'list[ContestMetrics]',
            'prizes': 'list[ContestPrizes]',
            'version': 'int',
            'created_by': 'UserReference',
            'profile': 'ContestProfile',
            'participants': 'list[UserReference]',
            'status': 'str',
            'participant_count': 'int',
            'date_finalized': 'datetime',
            'date_cancelled': 'datetime',
            'date_modified': 'datetime',
            'date_scores_modified': 'datetime',
            'winners': 'list[ContestWinners]',
            'disqualified_agents': 'list[ContestDisqualifiedAgents]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'division': 'division',
            'title': 'title',
            'description': 'description',
            'date_start': 'dateStart',
            'date_end': 'dateEnd',
            'winning_criteria': 'winningCriteria',
            'date_announced': 'dateAnnounced',
            'announcement_timezone': 'announcementTimezone',
            'anonymization': 'anonymization',
            'metrics': 'metrics',
            'prizes': 'prizes',
            'version': 'version',
            'created_by': 'createdBy',
            'profile': 'profile',
            'participants': 'participants',
            'status': 'status',
            'participant_count': 'participantCount',
            'date_finalized': 'dateFinalized',
            'date_cancelled': 'dateCancelled',
            'date_modified': 'dateModified',
            'date_scores_modified': 'dateScoresModified',
            'winners': 'winners',
            'disqualified_agents': 'disqualifiedAgents',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._division = None
        self._title = None
        self._description = None
        self._date_start = None
        self._date_end = None
        self._winning_criteria = None
        self._date_announced = None
        self._announcement_timezone = None
        self._anonymization = None
        self._metrics = None
        self._prizes = None
        self._version = None
        self._created_by = None
        self._profile = None
        self._participants = None
        self._status = None
        self._participant_count = None
        self._date_finalized = None
        self._date_cancelled = None
        self._date_modified = None
        self._date_scores_modified = None
        self._winners = None
        self._disqualified_agents = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ContestsResponse.
        The globally unique identifier for the object.

        :return: The id of this ContestsResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ContestsResponse.
        The globally unique identifier for the object.

        :param id: The id of this ContestsResponse.
        :type: str
        """
        

        self._id = id

    @property
    def division(self) -> 'WritableDivision':
        """
        Gets the division of this ContestsResponse.
        The division for this performance profile associate to

        :return: The division of this ContestsResponse.
        :rtype: WritableDivision
        """
        return self._division

    @division.setter
    def division(self, division: 'WritableDivision') -> None:
        """
        Sets the division of this ContestsResponse.
        The division for this performance profile associate to

        :param division: The division of this ContestsResponse.
        :type: WritableDivision
        """
        

        self._division = division

    @property
    def title(self) -> str:
        """
        Gets the title of this ContestsResponse.
        The Contest title

        :return: The title of this ContestsResponse.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this ContestsResponse.
        The Contest title

        :param title: The title of this ContestsResponse.
        :type: str
        """
        

        self._title = title

    @property
    def description(self) -> str:
        """
        Gets the description of this ContestsResponse.
        The Contest description

        :return: The description of this ContestsResponse.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this ContestsResponse.
        The Contest description

        :param description: The description of this ContestsResponse.
        :type: str
        """
        

        self._description = description

    @property
    def date_start(self) -> date:
        """
        Gets the date_start of this ContestsResponse.
        Start date of the contest. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_start of this ContestsResponse.
        :rtype: date
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start: date) -> None:
        """
        Sets the date_start of this ContestsResponse.
        Start date of the contest. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_start: The date_start of this ContestsResponse.
        :type: date
        """
        

        self._date_start = date_start

    @property
    def date_end(self) -> date:
        """
        Gets the date_end of this ContestsResponse.
        End date of the contest. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_end of this ContestsResponse.
        :rtype: date
        """
        return self._date_end

    @date_end.setter
    def date_end(self, date_end: date) -> None:
        """
        Sets the date_end of this ContestsResponse.
        End date of the contest. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_end: The date_end of this ContestsResponse.
        :type: date
        """
        

        self._date_end = date_end

    @property
    def winning_criteria(self) -> str:
        """
        Gets the winning_criteria of this ContestsResponse.
        The Contest winning criteria

        :return: The winning_criteria of this ContestsResponse.
        :rtype: str
        """
        return self._winning_criteria

    @winning_criteria.setter
    def winning_criteria(self, winning_criteria: str) -> None:
        """
        Sets the winning_criteria of this ContestsResponse.
        The Contest winning criteria

        :param winning_criteria: The winning_criteria of this ContestsResponse.
        :type: str
        """
        if isinstance(winning_criteria, int):
            winning_criteria = str(winning_criteria)
        allowed_values = ["HighestOverallScore", "HighestOverallPercentOfGoal"]
        if winning_criteria.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for winning_criteria -> " + winning_criteria)
            self._winning_criteria = "outdated_sdk_version"
        else:
            self._winning_criteria = winning_criteria

    @property
    def date_announced(self) -> datetime:
        """
        Gets the date_announced of this ContestsResponse.
        The Contest's Announcement Datetime. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_announced of this ContestsResponse.
        :rtype: datetime
        """
        return self._date_announced

    @date_announced.setter
    def date_announced(self, date_announced: datetime) -> None:
        """
        Sets the date_announced of this ContestsResponse.
        The Contest's Announcement Datetime. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_announced: The date_announced of this ContestsResponse.
        :type: datetime
        """
        

        self._date_announced = date_announced

    @property
    def announcement_timezone(self) -> str:
        """
        Gets the announcement_timezone of this ContestsResponse.
        The Contest's Announcement Timezone. Valid values are strings of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London

        :return: The announcement_timezone of this ContestsResponse.
        :rtype: str
        """
        return self._announcement_timezone

    @announcement_timezone.setter
    def announcement_timezone(self, announcement_timezone: str) -> None:
        """
        Sets the announcement_timezone of this ContestsResponse.
        The Contest's Announcement Timezone. Valid values are strings of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London

        :param announcement_timezone: The announcement_timezone of this ContestsResponse.
        :type: str
        """
        

        self._announcement_timezone = announcement_timezone

    @property
    def anonymization(self) -> str:
        """
        Gets the anonymization of this ContestsResponse.
        The Contest anonymization

        :return: The anonymization of this ContestsResponse.
        :rtype: str
        """
        return self._anonymization

    @anonymization.setter
    def anonymization(self, anonymization: str) -> None:
        """
        Sets the anonymization of this ContestsResponse.
        The Contest anonymization

        :param anonymization: The anonymization of this ContestsResponse.
        :type: str
        """
        if isinstance(anonymization, int):
            anonymization = str(anonymization)
        allowed_values = ["NoAnonymization", "All", "AllExceptTop"]
        if anonymization.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for anonymization -> " + anonymization)
            self._anonymization = "outdated_sdk_version"
        else:
            self._anonymization = anonymization

    @property
    def metrics(self) -> List['ContestMetrics']:
        """
        Gets the metrics of this ContestsResponse.
        The Contest's Metrics

        :return: The metrics of this ContestsResponse.
        :rtype: list[ContestMetrics]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics: List['ContestMetrics']) -> None:
        """
        Sets the metrics of this ContestsResponse.
        The Contest's Metrics

        :param metrics: The metrics of this ContestsResponse.
        :type: list[ContestMetrics]
        """
        

        self._metrics = metrics

    @property
    def prizes(self) -> List['ContestPrizes']:
        """
        Gets the prizes of this ContestsResponse.
        The Contest Prizes

        :return: The prizes of this ContestsResponse.
        :rtype: list[ContestPrizes]
        """
        return self._prizes

    @prizes.setter
    def prizes(self, prizes: List['ContestPrizes']) -> None:
        """
        Sets the prizes of this ContestsResponse.
        The Contest Prizes

        :param prizes: The prizes of this ContestsResponse.
        :type: list[ContestPrizes]
        """
        

        self._prizes = prizes

    @property
    def version(self) -> int:
        """
        Gets the version of this ContestsResponse.
        The Contest Version

        :return: The version of this ContestsResponse.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this ContestsResponse.
        The Contest Version

        :param version: The version of this ContestsResponse.
        :type: int
        """
        

        self._version = version

    @property
    def created_by(self) -> 'UserReference':
        """
        Gets the created_by of this ContestsResponse.
        The creator of the contest

        :return: The created_by of this ContestsResponse.
        :rtype: UserReference
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'UserReference') -> None:
        """
        Sets the created_by of this ContestsResponse.
        The creator of the contest

        :param created_by: The created_by of this ContestsResponse.
        :type: UserReference
        """
        

        self._created_by = created_by

    @property
    def profile(self) -> 'ContestProfile':
        """
        Gets the profile of this ContestsResponse.
        The performance profile

        :return: The profile of this ContestsResponse.
        :rtype: ContestProfile
        """
        return self._profile

    @profile.setter
    def profile(self, profile: 'ContestProfile') -> None:
        """
        Sets the profile of this ContestsResponse.
        The performance profile

        :param profile: The profile of this ContestsResponse.
        :type: ContestProfile
        """
        

        self._profile = profile

    @property
    def participants(self) -> List['UserReference']:
        """
        Gets the participants of this ContestsResponse.
        The Contest's participants

        :return: The participants of this ContestsResponse.
        :rtype: list[UserReference]
        """
        return self._participants

    @participants.setter
    def participants(self, participants: List['UserReference']) -> None:
        """
        Sets the participants of this ContestsResponse.
        The Contest's participants

        :param participants: The participants of this ContestsResponse.
        :type: list[UserReference]
        """
        

        self._participants = participants

    @property
    def status(self) -> str:
        """
        Gets the status of this ContestsResponse.
        The Contest status

        :return: The status of this ContestsResponse.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this ContestsResponse.
        The Contest status

        :param status: The status of this ContestsResponse.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Upcoming", "Ongoing", "Pending", "RecentlyCompleted", "Completed", "Cancelled"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def participant_count(self) -> int:
        """
        Gets the participant_count of this ContestsResponse.
        The Number of participants in the contest

        :return: The participant_count of this ContestsResponse.
        :rtype: int
        """
        return self._participant_count

    @participant_count.setter
    def participant_count(self, participant_count: int) -> None:
        """
        Sets the participant_count of this ContestsResponse.
        The Number of participants in the contest

        :param participant_count: The participant_count of this ContestsResponse.
        :type: int
        """
        

        self._participant_count = participant_count

    @property
    def date_finalized(self) -> datetime:
        """
        Gets the date_finalized of this ContestsResponse.
        The Contest's finalize datetime, returned when a contest is complete. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_finalized of this ContestsResponse.
        :rtype: datetime
        """
        return self._date_finalized

    @date_finalized.setter
    def date_finalized(self, date_finalized: datetime) -> None:
        """
        Sets the date_finalized of this ContestsResponse.
        The Contest's finalize datetime, returned when a contest is complete. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_finalized: The date_finalized of this ContestsResponse.
        :type: datetime
        """
        

        self._date_finalized = date_finalized

    @property
    def date_cancelled(self) -> datetime:
        """
        Gets the date_cancelled of this ContestsResponse.
        The Contest's cancelled datetime, returned when a contest is complete. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_cancelled of this ContestsResponse.
        :rtype: datetime
        """
        return self._date_cancelled

    @date_cancelled.setter
    def date_cancelled(self, date_cancelled: datetime) -> None:
        """
        Sets the date_cancelled of this ContestsResponse.
        The Contest's cancelled datetime, returned when a contest is complete. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_cancelled: The date_cancelled of this ContestsResponse.
        :type: datetime
        """
        

        self._date_cancelled = date_cancelled

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this ContestsResponse.
        The Contest's last modified datetime. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this ContestsResponse.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this ContestsResponse.
        The Contest's last modified datetime. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this ContestsResponse.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def date_scores_modified(self) -> datetime:
        """
        Gets the date_scores_modified of this ContestsResponse.
        The datetime the contest scores were last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_scores_modified of this ContestsResponse.
        :rtype: datetime
        """
        return self._date_scores_modified

    @date_scores_modified.setter
    def date_scores_modified(self, date_scores_modified: datetime) -> None:
        """
        Sets the date_scores_modified of this ContestsResponse.
        The datetime the contest scores were last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_scores_modified: The date_scores_modified of this ContestsResponse.
        :type: datetime
        """
        

        self._date_scores_modified = date_scores_modified

    @property
    def winners(self) -> List['ContestWinners']:
        """
        Gets the winners of this ContestsResponse.
        The Contest Winners

        :return: The winners of this ContestsResponse.
        :rtype: list[ContestWinners]
        """
        return self._winners

    @winners.setter
    def winners(self, winners: List['ContestWinners']) -> None:
        """
        Sets the winners of this ContestsResponse.
        The Contest Winners

        :param winners: The winners of this ContestsResponse.
        :type: list[ContestWinners]
        """
        

        self._winners = winners

    @property
    def disqualified_agents(self) -> List['ContestDisqualifiedAgents']:
        """
        Gets the disqualified_agents of this ContestsResponse.
        The Contest's disqualified agents, returned when a contest is complete

        :return: The disqualified_agents of this ContestsResponse.
        :rtype: list[ContestDisqualifiedAgents]
        """
        return self._disqualified_agents

    @disqualified_agents.setter
    def disqualified_agents(self, disqualified_agents: List['ContestDisqualifiedAgents']) -> None:
        """
        Sets the disqualified_agents of this ContestsResponse.
        The Contest's disqualified agents, returned when a contest is complete

        :param disqualified_agents: The disqualified_agents of this ContestsResponse.
        :type: list[ContestDisqualifiedAgents]
        """
        

        self._disqualified_agents = disqualified_agents

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ContestsResponse.
        The URI for this object

        :return: The self_uri of this ContestsResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ContestsResponse.
        The URI for this object

        :param self_uri: The self_uri of this ContestsResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

