# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class ContinuousForecastGetSessionResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContinuousForecastGetSessionResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'session_id': 'str',
            'last_successful_session_id': 'str',
            'state': 'str',
            'error_code': 'str'
        }

        self.attribute_map = {
            'session_id': 'sessionId',
            'last_successful_session_id': 'lastSuccessfulSessionId',
            'state': 'state',
            'error_code': 'errorCode'
        }

        self._session_id = None
        self._last_successful_session_id = None
        self._state = None
        self._error_code = None

    @property
    def session_id(self) -> str:
        """
        Gets the session_id of this ContinuousForecastGetSessionResponse.
        Latest session ID of the business unit

        :return: The session_id of this ContinuousForecastGetSessionResponse.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id: str) -> None:
        """
        Sets the session_id of this ContinuousForecastGetSessionResponse.
        Latest session ID of the business unit

        :param session_id: The session_id of this ContinuousForecastGetSessionResponse.
        :type: str
        """
        

        self._session_id = session_id

    @property
    def last_successful_session_id(self) -> str:
        """
        Gets the last_successful_session_id of this ContinuousForecastGetSessionResponse.
        Last successful session ID of the business unit

        :return: The last_successful_session_id of this ContinuousForecastGetSessionResponse.
        :rtype: str
        """
        return self._last_successful_session_id

    @last_successful_session_id.setter
    def last_successful_session_id(self, last_successful_session_id: str) -> None:
        """
        Sets the last_successful_session_id of this ContinuousForecastGetSessionResponse.
        Last successful session ID of the business unit

        :param last_successful_session_id: The last_successful_session_id of this ContinuousForecastGetSessionResponse.
        :type: str
        """
        

        self._last_successful_session_id = last_successful_session_id

    @property
    def state(self) -> str:
        """
        Gets the state of this ContinuousForecastGetSessionResponse.
        State of the latest session

        :return: The state of this ContinuousForecastGetSessionResponse.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this ContinuousForecastGetSessionResponse.
        State of the latest session

        :param state: The state of this ContinuousForecastGetSessionResponse.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Complete", "Processing", "Error"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def error_code(self) -> str:
        """
        Gets the error_code of this ContinuousForecastGetSessionResponse.
        Failed session error code

        :return: The error_code of this ContinuousForecastGetSessionResponse.
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code: str) -> None:
        """
        Sets the error_code of this ContinuousForecastGetSessionResponse.
        Failed session error code

        :param error_code: The error_code of this ContinuousForecastGetSessionResponse.
        :type: str
        """
        

        self._error_code = error_code

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

