# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ConversationContentListPickerSection
    from . import ConversationContentReceivedReplyMessage

class ConversationContentListPicker(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ConversationContentListPicker - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'sections': 'list[ConversationContentListPickerSection]',
            'reply_message': 'ConversationContentReceivedReplyMessage',
            'received_message': 'ConversationContentReceivedReplyMessage'
        }

        self.attribute_map = {
            'id': 'id',
            'sections': 'sections',
            'reply_message': 'replyMessage',
            'received_message': 'receivedMessage'
        }

        self._id = None
        self._sections = None
        self._reply_message = None
        self._received_message = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ConversationContentListPicker.
        Optional unique identifier to help map component replies to form messages where multiple ListPickers can be present.

        :return: The id of this ConversationContentListPicker.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ConversationContentListPicker.
        Optional unique identifier to help map component replies to form messages where multiple ListPickers can be present.

        :param id: The id of this ConversationContentListPicker.
        :type: str
        """
        

        self._id = id

    @property
    def sections(self) -> List['ConversationContentListPickerSection']:
        """
        Gets the sections of this ConversationContentListPicker.
        An array of sections in the List Picker.

        :return: The sections of this ConversationContentListPicker.
        :rtype: list[ConversationContentListPickerSection]
        """
        return self._sections

    @sections.setter
    def sections(self, sections: List['ConversationContentListPickerSection']) -> None:
        """
        Sets the sections of this ConversationContentListPicker.
        An array of sections in the List Picker.

        :param sections: The sections of this ConversationContentListPicker.
        :type: list[ConversationContentListPickerSection]
        """
        

        self._sections = sections

    @property
    def reply_message(self) -> 'ConversationContentReceivedReplyMessage':
        """
        Gets the reply_message of this ConversationContentListPicker.
        The reply message after the user has selected the options from the List Picker.

        :return: The reply_message of this ConversationContentListPicker.
        :rtype: ConversationContentReceivedReplyMessage
        """
        return self._reply_message

    @reply_message.setter
    def reply_message(self, reply_message: 'ConversationContentReceivedReplyMessage') -> None:
        """
        Sets the reply_message of this ConversationContentListPicker.
        The reply message after the user has selected the options from the List Picker.

        :param reply_message: The reply_message of this ConversationContentListPicker.
        :type: ConversationContentReceivedReplyMessage
        """
        

        self._reply_message = reply_message

    @property
    def received_message(self) -> 'ConversationContentReceivedReplyMessage':
        """
        Gets the received_message of this ConversationContentListPicker.
        The message prompt to select options in the List Picker sections.

        :return: The received_message of this ConversationContentListPicker.
        :rtype: ConversationContentReceivedReplyMessage
        """
        return self._received_message

    @received_message.setter
    def received_message(self, received_message: 'ConversationContentReceivedReplyMessage') -> None:
        """
        Sets the received_message of this ConversationContentListPicker.
        The message prompt to select options in the List Picker sections.

        :param received_message: The received_message of this ConversationContentListPicker.
        :type: ConversationContentReceivedReplyMessage
        """
        

        self._received_message = received_message

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

