# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ConversationPushFailedMessageReferences
    from . import ConversationPushNotificationMessageLabel
    from . import ConversationPushProviderIntegration

class ConversationContentPush(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ConversationContentPush - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'device_type': 'str',
            'device_token_id': 'str',
            'device_token': 'str',
            'failed_messages': 'list[ConversationPushFailedMessageReferences]',
            'notification_message': 'ConversationPushNotificationMessageLabel',
            'push_provider_integration': 'ConversationPushProviderIntegration',
            'expiration': 'int'
        }

        self.attribute_map = {
            'device_type': 'deviceType',
            'device_token_id': 'deviceTokenId',
            'device_token': 'deviceToken',
            'failed_messages': 'failedMessages',
            'notification_message': 'notificationMessage',
            'push_provider_integration': 'pushProviderIntegration',
            'expiration': 'expiration'
        }

        self._device_type = None
        self._device_token_id = None
        self._device_token = None
        self._failed_messages = None
        self._notification_message = None
        self._push_provider_integration = None
        self._expiration = None

    @property
    def device_type(self) -> str:
        """
        Gets the device_type of this ConversationContentPush.
        The device type used to send the push notification

        :return: The device_type of this ConversationContentPush.
        :rtype: str
        """
        return self._device_type

    @device_type.setter
    def device_type(self, device_type: str) -> None:
        """
        Sets the device_type of this ConversationContentPush.
        The device type used to send the push notification

        :param device_type: The device_type of this ConversationContentPush.
        :type: str
        """
        if isinstance(device_type, int):
            device_type = str(device_type)
        allowed_values = ["Android", "IOS"]
        if device_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for device_type -> " + device_type)
            self._device_type = "outdated_sdk_version"
        else:
            self._device_type = device_type

    @property
    def device_token_id(self) -> str:
        """
        Gets the device_token_id of this ConversationContentPush.
        Unique Id of the device token

        :return: The device_token_id of this ConversationContentPush.
        :rtype: str
        """
        return self._device_token_id

    @device_token_id.setter
    def device_token_id(self, device_token_id: str) -> None:
        """
        Sets the device_token_id of this ConversationContentPush.
        Unique Id of the device token

        :param device_token_id: The device_token_id of this ConversationContentPush.
        :type: str
        """
        

        self._device_token_id = device_token_id

    @property
    def device_token(self) -> str:
        """
        Gets the device_token of this ConversationContentPush.
        device token from the notification provider

        :return: The device_token of this ConversationContentPush.
        :rtype: str
        """
        return self._device_token

    @device_token.setter
    def device_token(self, device_token: str) -> None:
        """
        Sets the device_token of this ConversationContentPush.
        device token from the notification provider

        :param device_token: The device_token of this ConversationContentPush.
        :type: str
        """
        

        self._device_token = device_token

    @property
    def failed_messages(self) -> List['ConversationPushFailedMessageReferences']:
        """
        Gets the failed_messages of this ConversationContentPush.
        MessageIds failed to be sent which trigger the push event

        :return: The failed_messages of this ConversationContentPush.
        :rtype: list[ConversationPushFailedMessageReferences]
        """
        return self._failed_messages

    @failed_messages.setter
    def failed_messages(self, failed_messages: List['ConversationPushFailedMessageReferences']) -> None:
        """
        Sets the failed_messages of this ConversationContentPush.
        MessageIds failed to be sent which trigger the push event

        :param failed_messages: The failed_messages of this ConversationContentPush.
        :type: list[ConversationPushFailedMessageReferences]
        """
        

        self._failed_messages = failed_messages

    @property
    def notification_message(self) -> 'ConversationPushNotificationMessageLabel':
        """
        Gets the notification_message of this ConversationContentPush.
        Title and body localized according to deployment

        :return: The notification_message of this ConversationContentPush.
        :rtype: ConversationPushNotificationMessageLabel
        """
        return self._notification_message

    @notification_message.setter
    def notification_message(self, notification_message: 'ConversationPushNotificationMessageLabel') -> None:
        """
        Sets the notification_message of this ConversationContentPush.
        Title and body localized according to deployment

        :param notification_message: The notification_message of this ConversationContentPush.
        :type: ConversationPushNotificationMessageLabel
        """
        

        self._notification_message = notification_message

    @property
    def push_provider_integration(self) -> 'ConversationPushProviderIntegration':
        """
        Gets the push_provider_integration of this ConversationContentPush.
        Push provider integrations details configured on the deployment

        :return: The push_provider_integration of this ConversationContentPush.
        :rtype: ConversationPushProviderIntegration
        """
        return self._push_provider_integration

    @push_provider_integration.setter
    def push_provider_integration(self, push_provider_integration: 'ConversationPushProviderIntegration') -> None:
        """
        Sets the push_provider_integration of this ConversationContentPush.
        Push provider integrations details configured on the deployment

        :param push_provider_integration: The push_provider_integration of this ConversationContentPush.
        :type: ConversationPushProviderIntegration
        """
        

        self._push_provider_integration = push_provider_integration

    @property
    def expiration(self) -> int:
        """
        Gets the expiration of this ConversationContentPush.
        The time to live of the pushed message

        :return: The expiration of this ConversationContentPush.
        :rtype: int
        """
        return self._expiration

    @expiration.setter
    def expiration(self, expiration: int) -> None:
        """
        Sets the expiration of this ConversationContentPush.
        The time to live of the pushed message

        :param expiration: The expiration of this ConversationContentPush.
        :type: int
        """
        

        self._expiration = expiration

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

