# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ConversationEnrichmentLanguage
    from . import ConversationEnrichmentSentimentV2

class ConversationEnrichment(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ConversationEnrichment - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'language': 'ConversationEnrichmentLanguage',
            'sentiment_v2': 'ConversationEnrichmentSentimentV2'
        }

        self.attribute_map = {
            'language': 'language',
            'sentiment_v2': 'sentimentV2'
        }

        self._language = None
        self._sentiment_v2 = None

    @property
    def language(self) -> 'ConversationEnrichmentLanguage':
        """
        Gets the language of this ConversationEnrichment.
        Detected language of this message.

        :return: The language of this ConversationEnrichment.
        :rtype: ConversationEnrichmentLanguage
        """
        return self._language

    @language.setter
    def language(self, language: 'ConversationEnrichmentLanguage') -> None:
        """
        Sets the language of this ConversationEnrichment.
        Detected language of this message.

        :param language: The language of this ConversationEnrichment.
        :type: ConversationEnrichmentLanguage
        """
        

        self._language = language

    @property
    def sentiment_v2(self) -> 'ConversationEnrichmentSentimentV2':
        """
        Gets the sentiment_v2 of this ConversationEnrichment.
        Detected sentiment of this message.

        :return: The sentiment_v2 of this ConversationEnrichment.
        :rtype: ConversationEnrichmentSentimentV2
        """
        return self._sentiment_v2

    @sentiment_v2.setter
    def sentiment_v2(self, sentiment_v2: 'ConversationEnrichmentSentimentV2') -> None:
        """
        Sets the sentiment_v2 of this ConversationEnrichment.
        Detected sentiment of this message.

        :param sentiment_v2: The sentiment_v2 of this ConversationEnrichment.
        :type: ConversationEnrichmentSentimentV2
        """
        

        self._sentiment_v2 = sentiment_v2

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

