# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ConversationNotificationTemplateParameter

class ConversationNotificationTemplateButton(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ConversationNotificationTemplateButton - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'text': 'str',
            'index': 'int',
            'phone_number': 'str',
            'url': 'str',
            'parameters': 'list[ConversationNotificationTemplateParameter]'
        }

        self.attribute_map = {
            'type': 'type',
            'text': 'text',
            'index': 'index',
            'phone_number': 'phoneNumber',
            'url': 'url',
            'parameters': 'parameters'
        }

        self._type = None
        self._text = None
        self._index = None
        self._phone_number = None
        self._url = None
        self._parameters = None

    @property
    def type(self) -> str:
        """
        Gets the type of this ConversationNotificationTemplateButton.
        Specifies the type of the button.

        :return: The type of this ConversationNotificationTemplateButton.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this ConversationNotificationTemplateButton.
        Specifies the type of the button.

        :param type: The type of this ConversationNotificationTemplateButton.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["QuickReply", "PhoneNumber", "Url"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def text(self) -> str:
        """
        Gets the text of this ConversationNotificationTemplateButton.
        Button text message.

        :return: The text of this ConversationNotificationTemplateButton.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text: str) -> None:
        """
        Sets the text of this ConversationNotificationTemplateButton.
        Button text message.

        :param text: The text of this ConversationNotificationTemplateButton.
        :type: str
        """
        

        self._text = text

    @property
    def index(self) -> int:
        """
        Gets the index of this ConversationNotificationTemplateButton.
        index of the button in the list.

        :return: The index of this ConversationNotificationTemplateButton.
        :rtype: int
        """
        return self._index

    @index.setter
    def index(self, index: int) -> None:
        """
        Sets the index of this ConversationNotificationTemplateButton.
        index of the button in the list.

        :param index: The index of this ConversationNotificationTemplateButton.
        :type: int
        """
        

        self._index = index

    @property
    def phone_number(self) -> str:
        """
        Gets the phone_number of this ConversationNotificationTemplateButton.
        Button phone number.

        :return: The phone_number of this ConversationNotificationTemplateButton.
        :rtype: str
        """
        return self._phone_number

    @phone_number.setter
    def phone_number(self, phone_number: str) -> None:
        """
        Sets the phone_number of this ConversationNotificationTemplateButton.
        Button phone number.

        :param phone_number: The phone_number of this ConversationNotificationTemplateButton.
        :type: str
        """
        

        self._phone_number = phone_number

    @property
    def url(self) -> str:
        """
        Gets the url of this ConversationNotificationTemplateButton.
        Button URL link.

        :return: The url of this ConversationNotificationTemplateButton.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url: str) -> None:
        """
        Sets the url of this ConversationNotificationTemplateButton.
        Button URL link.

        :param url: The url of this ConversationNotificationTemplateButton.
        :type: str
        """
        

        self._url = url

    @property
    def parameters(self) -> List['ConversationNotificationTemplateParameter']:
        """
        Gets the parameters of this ConversationNotificationTemplateButton.
        Template parameters for placeholders in the button.

        :return: The parameters of this ConversationNotificationTemplateButton.
        :rtype: list[ConversationNotificationTemplateParameter]
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters: List['ConversationNotificationTemplateParameter']) -> None:
        """
        Sets the parameters of this ConversationNotificationTemplateButton.
        Template parameters for placeholders in the button.

        :param parameters: The parameters of this ConversationNotificationTemplateButton.
        :type: list[ConversationNotificationTemplateParameter]
        """
        

        self._parameters = parameters

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

