# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import ConversationSessionSummary
    from . import ConversationSummary

class ConversationSummariesGetResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ConversationSummariesGetResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'conversation': 'AddressableEntityRef',
            'summary': 'ConversationSummary',
            'session_summaries': 'list[ConversationSessionSummary]'
        }

        self.attribute_map = {
            'conversation': 'conversation',
            'summary': 'summary',
            'session_summaries': 'sessionSummaries'
        }

        self._conversation = None
        self._summary = None
        self._session_summaries = None

    @property
    def conversation(self) -> 'AddressableEntityRef':
        """
        Gets the conversation of this ConversationSummariesGetResponse.
        The conversation object.

        :return: The conversation of this ConversationSummariesGetResponse.
        :rtype: AddressableEntityRef
        """
        return self._conversation

    @conversation.setter
    def conversation(self, conversation: 'AddressableEntityRef') -> None:
        """
        Sets the conversation of this ConversationSummariesGetResponse.
        The conversation object.

        :param conversation: The conversation of this ConversationSummariesGetResponse.
        :type: AddressableEntityRef
        """
        

        self._conversation = conversation

    @property
    def summary(self) -> 'ConversationSummary':
        """
        Gets the summary of this ConversationSummariesGetResponse.
        The summary of the conversation.

        :return: The summary of this ConversationSummariesGetResponse.
        :rtype: ConversationSummary
        """
        return self._summary

    @summary.setter
    def summary(self, summary: 'ConversationSummary') -> None:
        """
        Sets the summary of this ConversationSummariesGetResponse.
        The summary of the conversation.

        :param summary: The summary of this ConversationSummariesGetResponse.
        :type: ConversationSummary
        """
        

        self._summary = summary

    @property
    def session_summaries(self) -> List['ConversationSessionSummary']:
        """
        Gets the session_summaries of this ConversationSummariesGetResponse.
        All the summaries of the session.

        :return: The session_summaries of this ConversationSummariesGetResponse.
        :rtype: list[ConversationSessionSummary]
        """
        return self._session_summaries

    @session_summaries.setter
    def session_summaries(self, session_summaries: List['ConversationSessionSummary']) -> None:
        """
        Sets the session_summaries of this ConversationSummariesGetResponse.
        All the summaries of the session.

        :param session_summaries: The session_summaries of this ConversationSummariesGetResponse.
        :type: list[ConversationSessionSummary]
        """
        

        self._session_summaries = session_summaries

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

