# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class ConversationSummaryTopicTriggerSource(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ConversationSummaryTopicTriggerSource - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'source_type': 'str',
            'source_id': 'str',
            'source_outcome': 'str'
        }

        self.attribute_map = {
            'source_type': 'sourceType',
            'source_id': 'sourceId',
            'source_outcome': 'sourceOutcome'
        }

        self._source_type = None
        self._source_id = None
        self._source_outcome = None

    @property
    def source_type(self) -> str:
        """
        Gets the source_type of this ConversationSummaryTopicTriggerSource.


        :return: The source_type of this ConversationSummaryTopicTriggerSource.
        :rtype: str
        """
        return self._source_type

    @source_type.setter
    def source_type(self, source_type: str) -> None:
        """
        Sets the source_type of this ConversationSummaryTopicTriggerSource.


        :param source_type: The source_type of this ConversationSummaryTopicTriggerSource.
        :type: str
        """
        if isinstance(source_type, int):
            source_type = str(source_type)
        allowed_values = ["UNKNOWN", "AGENT_ASSISTANT", "PROGRAM", "FLOW", "COPILOT"]
        if source_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for source_type -> " + source_type)
            self._source_type = "outdated_sdk_version"
        else:
            self._source_type = source_type

    @property
    def source_id(self) -> str:
        """
        Gets the source_id of this ConversationSummaryTopicTriggerSource.


        :return: The source_id of this ConversationSummaryTopicTriggerSource.
        :rtype: str
        """
        return self._source_id

    @source_id.setter
    def source_id(self, source_id: str) -> None:
        """
        Sets the source_id of this ConversationSummaryTopicTriggerSource.


        :param source_id: The source_id of this ConversationSummaryTopicTriggerSource.
        :type: str
        """
        

        self._source_id = source_id

    @property
    def source_outcome(self) -> str:
        """
        Gets the source_outcome of this ConversationSummaryTopicTriggerSource.


        :return: The source_outcome of this ConversationSummaryTopicTriggerSource.
        :rtype: str
        """
        return self._source_outcome

    @source_outcome.setter
    def source_outcome(self, source_outcome: str) -> None:
        """
        Sets the source_outcome of this ConversationSummaryTopicTriggerSource.


        :param source_outcome: The source_outcome of this ConversationSummaryTopicTriggerSource.
        :type: str
        """
        if isinstance(source_outcome, int):
            source_outcome = str(source_outcome)
        allowed_values = ["UNKNOWN", "CONTAINED", "TRANSFER"]
        if source_outcome.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for source_outcome -> " + source_outcome)
            self._source_outcome = "outdated_sdk_version"
        else:
            self._source_outcome = source_outcome

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

