# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ConversationSummaryTopicVirtualAgentsConversationFollowupAction
    from . import ConversationSummaryTopicVirtualAgentsConversationHeadline
    from . import ConversationSummaryTopicVirtualAgentsConversationReason
    from . import ConversationSummaryTopicVirtualAgentsConversationResolution
    from . import ConversationSummaryTopicVirtualAgentsConversationSummary
    from . import ConversationSummaryTopicVirtualAgentsConversationSummaryParticipant
    from . import ConversationSummaryTopicVirtualAgentsConversationWrapUpCode
    from . import ConversationSummaryTopicVirtualAgentsSummaryExtractedCustomEntity
    from . import ConversationSummaryTopicVirtualAgentsTriggerSource

class ConversationSummaryTopicVirtualAgentsConversationSummaryEvent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ConversationSummaryTopicVirtualAgentsConversationSummaryEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'conversation_id': 'str',
            'queue_id': 'str',
            'participants': 'list[ConversationSummaryTopicVirtualAgentsConversationSummaryParticipant]',
            'communication_ids': 'list[str]',
            'created_date': 'datetime',
            'message_type': 'str',
            'media_type': 'str',
            'summary_id': 'str',
            'language': 'str',
            'summary': 'ConversationSummaryTopicVirtualAgentsConversationSummary',
            'headline': 'ConversationSummaryTopicVirtualAgentsConversationHeadline',
            'reason': 'ConversationSummaryTopicVirtualAgentsConversationReason',
            'resolution': 'ConversationSummaryTopicVirtualAgentsConversationResolution',
            'followup_actions': 'list[ConversationSummaryTopicVirtualAgentsConversationFollowupAction]',
            'extracted_entities': 'list[ConversationSummaryTopicVirtualAgentsSummaryExtractedCustomEntity]',
            'wrap_up_codes': 'list[ConversationSummaryTopicVirtualAgentsConversationWrapUpCode]',
            'trigger_source': 'ConversationSummaryTopicVirtualAgentsTriggerSource',
            'last_edited_by': 'ConversationSummaryTopicVirtualAgentsConversationSummaryParticipant',
            'error_type': 'str',
            'duration_ms': 'int'
        }

        self.attribute_map = {
            'conversation_id': 'conversationId',
            'queue_id': 'queueId',
            'participants': 'participants',
            'communication_ids': 'communicationIds',
            'created_date': 'createdDate',
            'message_type': 'messageType',
            'media_type': 'mediaType',
            'summary_id': 'summaryId',
            'language': 'language',
            'summary': 'summary',
            'headline': 'headline',
            'reason': 'reason',
            'resolution': 'resolution',
            'followup_actions': 'followupActions',
            'extracted_entities': 'extractedEntities',
            'wrap_up_codes': 'wrapUpCodes',
            'trigger_source': 'triggerSource',
            'last_edited_by': 'lastEditedBy',
            'error_type': 'errorType',
            'duration_ms': 'durationMs'
        }

        self._conversation_id = None
        self._queue_id = None
        self._participants = None
        self._communication_ids = None
        self._created_date = None
        self._message_type = None
        self._media_type = None
        self._summary_id = None
        self._language = None
        self._summary = None
        self._headline = None
        self._reason = None
        self._resolution = None
        self._followup_actions = None
        self._extracted_entities = None
        self._wrap_up_codes = None
        self._trigger_source = None
        self._last_edited_by = None
        self._error_type = None
        self._duration_ms = None

    @property
    def conversation_id(self) -> str:
        """
        Gets the conversation_id of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The conversation_id of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id: str) -> None:
        """
        Sets the conversation_id of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param conversation_id: The conversation_id of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: str
        """
        

        self._conversation_id = conversation_id

    @property
    def queue_id(self) -> str:
        """
        Gets the queue_id of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The queue_id of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: str
        """
        return self._queue_id

    @queue_id.setter
    def queue_id(self, queue_id: str) -> None:
        """
        Sets the queue_id of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param queue_id: The queue_id of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: str
        """
        

        self._queue_id = queue_id

    @property
    def participants(self) -> List['ConversationSummaryTopicVirtualAgentsConversationSummaryParticipant']:
        """
        Gets the participants of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The participants of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: list[ConversationSummaryTopicVirtualAgentsConversationSummaryParticipant]
        """
        return self._participants

    @participants.setter
    def participants(self, participants: List['ConversationSummaryTopicVirtualAgentsConversationSummaryParticipant']) -> None:
        """
        Sets the participants of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param participants: The participants of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: list[ConversationSummaryTopicVirtualAgentsConversationSummaryParticipant]
        """
        

        self._participants = participants

    @property
    def communication_ids(self) -> List[str]:
        """
        Gets the communication_ids of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The communication_ids of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: list[str]
        """
        return self._communication_ids

    @communication_ids.setter
    def communication_ids(self, communication_ids: List[str]) -> None:
        """
        Sets the communication_ids of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param communication_ids: The communication_ids of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: list[str]
        """
        

        self._communication_ids = communication_ids

    @property
    def created_date(self) -> datetime:
        """
        Gets the created_date of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The created_date of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date: datetime) -> None:
        """
        Sets the created_date of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param created_date: The created_date of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: datetime
        """
        

        self._created_date = created_date

    @property
    def message_type(self) -> str:
        """
        Gets the message_type of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The message_type of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: str
        """
        return self._message_type

    @message_type.setter
    def message_type(self, message_type: str) -> None:
        """
        Sets the message_type of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param message_type: The message_type of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: str
        """
        if isinstance(message_type, int):
            message_type = str(message_type)
        allowed_values = ["UNKNOWN", "SMS", "TWITTER", "FACEBOOK", "INSTAGRAM", "LINE", "WHATSAPP", "WEBMESSAGING", "OPEN", "APPLE"]
        if message_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for message_type -> " + message_type)
            self._message_type = "outdated_sdk_version"
        else:
            self._message_type = message_type

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The media_type of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param media_type: The media_type of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: str
        """
        if isinstance(media_type, int):
            media_type = str(media_type)
        allowed_values = ["UNKNOWN", "MESSAGE", "CALL", "EMAIL"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    @property
    def summary_id(self) -> str:
        """
        Gets the summary_id of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The summary_id of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: str
        """
        return self._summary_id

    @summary_id.setter
    def summary_id(self, summary_id: str) -> None:
        """
        Sets the summary_id of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param summary_id: The summary_id of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: str
        """
        

        self._summary_id = summary_id

    @property
    def language(self) -> str:
        """
        Gets the language of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The language of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language: str) -> None:
        """
        Sets the language of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param language: The language of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: str
        """
        

        self._language = language

    @property
    def summary(self) -> 'ConversationSummaryTopicVirtualAgentsConversationSummary':
        """
        Gets the summary of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The summary of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: ConversationSummaryTopicVirtualAgentsConversationSummary
        """
        return self._summary

    @summary.setter
    def summary(self, summary: 'ConversationSummaryTopicVirtualAgentsConversationSummary') -> None:
        """
        Sets the summary of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param summary: The summary of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: ConversationSummaryTopicVirtualAgentsConversationSummary
        """
        

        self._summary = summary

    @property
    def headline(self) -> 'ConversationSummaryTopicVirtualAgentsConversationHeadline':
        """
        Gets the headline of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The headline of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: ConversationSummaryTopicVirtualAgentsConversationHeadline
        """
        return self._headline

    @headline.setter
    def headline(self, headline: 'ConversationSummaryTopicVirtualAgentsConversationHeadline') -> None:
        """
        Sets the headline of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param headline: The headline of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: ConversationSummaryTopicVirtualAgentsConversationHeadline
        """
        

        self._headline = headline

    @property
    def reason(self) -> 'ConversationSummaryTopicVirtualAgentsConversationReason':
        """
        Gets the reason of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The reason of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: ConversationSummaryTopicVirtualAgentsConversationReason
        """
        return self._reason

    @reason.setter
    def reason(self, reason: 'ConversationSummaryTopicVirtualAgentsConversationReason') -> None:
        """
        Sets the reason of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param reason: The reason of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: ConversationSummaryTopicVirtualAgentsConversationReason
        """
        

        self._reason = reason

    @property
    def resolution(self) -> 'ConversationSummaryTopicVirtualAgentsConversationResolution':
        """
        Gets the resolution of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The resolution of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: ConversationSummaryTopicVirtualAgentsConversationResolution
        """
        return self._resolution

    @resolution.setter
    def resolution(self, resolution: 'ConversationSummaryTopicVirtualAgentsConversationResolution') -> None:
        """
        Sets the resolution of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param resolution: The resolution of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: ConversationSummaryTopicVirtualAgentsConversationResolution
        """
        

        self._resolution = resolution

    @property
    def followup_actions(self) -> List['ConversationSummaryTopicVirtualAgentsConversationFollowupAction']:
        """
        Gets the followup_actions of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The followup_actions of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: list[ConversationSummaryTopicVirtualAgentsConversationFollowupAction]
        """
        return self._followup_actions

    @followup_actions.setter
    def followup_actions(self, followup_actions: List['ConversationSummaryTopicVirtualAgentsConversationFollowupAction']) -> None:
        """
        Sets the followup_actions of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param followup_actions: The followup_actions of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: list[ConversationSummaryTopicVirtualAgentsConversationFollowupAction]
        """
        

        self._followup_actions = followup_actions

    @property
    def extracted_entities(self) -> List['ConversationSummaryTopicVirtualAgentsSummaryExtractedCustomEntity']:
        """
        Gets the extracted_entities of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The extracted_entities of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: list[ConversationSummaryTopicVirtualAgentsSummaryExtractedCustomEntity]
        """
        return self._extracted_entities

    @extracted_entities.setter
    def extracted_entities(self, extracted_entities: List['ConversationSummaryTopicVirtualAgentsSummaryExtractedCustomEntity']) -> None:
        """
        Sets the extracted_entities of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param extracted_entities: The extracted_entities of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: list[ConversationSummaryTopicVirtualAgentsSummaryExtractedCustomEntity]
        """
        

        self._extracted_entities = extracted_entities

    @property
    def wrap_up_codes(self) -> List['ConversationSummaryTopicVirtualAgentsConversationWrapUpCode']:
        """
        Gets the wrap_up_codes of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The wrap_up_codes of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: list[ConversationSummaryTopicVirtualAgentsConversationWrapUpCode]
        """
        return self._wrap_up_codes

    @wrap_up_codes.setter
    def wrap_up_codes(self, wrap_up_codes: List['ConversationSummaryTopicVirtualAgentsConversationWrapUpCode']) -> None:
        """
        Sets the wrap_up_codes of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param wrap_up_codes: The wrap_up_codes of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: list[ConversationSummaryTopicVirtualAgentsConversationWrapUpCode]
        """
        

        self._wrap_up_codes = wrap_up_codes

    @property
    def trigger_source(self) -> 'ConversationSummaryTopicVirtualAgentsTriggerSource':
        """
        Gets the trigger_source of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The trigger_source of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: ConversationSummaryTopicVirtualAgentsTriggerSource
        """
        return self._trigger_source

    @trigger_source.setter
    def trigger_source(self, trigger_source: 'ConversationSummaryTopicVirtualAgentsTriggerSource') -> None:
        """
        Sets the trigger_source of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param trigger_source: The trigger_source of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: ConversationSummaryTopicVirtualAgentsTriggerSource
        """
        

        self._trigger_source = trigger_source

    @property
    def last_edited_by(self) -> 'ConversationSummaryTopicVirtualAgentsConversationSummaryParticipant':
        """
        Gets the last_edited_by of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The last_edited_by of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: ConversationSummaryTopicVirtualAgentsConversationSummaryParticipant
        """
        return self._last_edited_by

    @last_edited_by.setter
    def last_edited_by(self, last_edited_by: 'ConversationSummaryTopicVirtualAgentsConversationSummaryParticipant') -> None:
        """
        Sets the last_edited_by of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param last_edited_by: The last_edited_by of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: ConversationSummaryTopicVirtualAgentsConversationSummaryParticipant
        """
        

        self._last_edited_by = last_edited_by

    @property
    def error_type(self) -> str:
        """
        Gets the error_type of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The error_type of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: str
        """
        return self._error_type

    @error_type.setter
    def error_type(self, error_type: str) -> None:
        """
        Sets the error_type of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param error_type: The error_type of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: str
        """
        if isinstance(error_type, int):
            error_type = str(error_type)
        allowed_values = ["UNKNOWN", "CONVERSATION_TOO_LONG", "CONVERSATION_TOO_SHORT", "RATE_LIMITED"]
        if error_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for error_type -> " + error_type)
            self._error_type = "outdated_sdk_version"
        else:
            self._error_type = error_type

    @property
    def duration_ms(self) -> int:
        """
        Gets the duration_ms of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :return: The duration_ms of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :rtype: int
        """
        return self._duration_ms

    @duration_ms.setter
    def duration_ms(self, duration_ms: int) -> None:
        """
        Sets the duration_ms of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.


        :param duration_ms: The duration_ms of this ConversationSummaryTopicVirtualAgentsConversationSummaryEvent.
        :type: int
        """
        

        self._duration_ms = duration_ms

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

