# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ActivityPlanServiceGoalImpactOverrides
    from . import FixedAvailability
    from . import GroupSettings
    from . import RecurrenceSettings
    from . import SchedulingPeriod
    from . import UserSearchRule

class CreateActivityPlanRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CreateActivityPlanRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'management_unit_ids': 'list[str]',
            'description': 'str',
            'activity_code_id': 'str',
            'type': 'str',
            'length_minutes': 'int',
            'initial_schedule_period': 'SchedulingPeriod',
            'group_settings': 'GroupSettings',
            'recurrence_settings': 'RecurrenceSettings',
            'attendees_search_rule': 'UserSearchRule',
            'facilitated': 'bool',
            'facilitators_search_rule': 'UserSearchRule',
            'transition_time_minutes': 'int',
            'service_goal_impact_overrides': 'ActivityPlanServiceGoalImpactOverrides',
            'optimization_objective': 'str',
            'state': 'str',
            'counts_as_paid_time': 'bool',
            'fixed_availability': 'list[FixedAvailability]'
        }

        self.attribute_map = {
            'name': 'name',
            'management_unit_ids': 'managementUnitIds',
            'description': 'description',
            'activity_code_id': 'activityCodeId',
            'type': 'type',
            'length_minutes': 'lengthMinutes',
            'initial_schedule_period': 'initialSchedulePeriod',
            'group_settings': 'groupSettings',
            'recurrence_settings': 'recurrenceSettings',
            'attendees_search_rule': 'attendeesSearchRule',
            'facilitated': 'facilitated',
            'facilitators_search_rule': 'facilitatorsSearchRule',
            'transition_time_minutes': 'transitionTimeMinutes',
            'service_goal_impact_overrides': 'serviceGoalImpactOverrides',
            'optimization_objective': 'optimizationObjective',
            'state': 'state',
            'counts_as_paid_time': 'countsAsPaidTime',
            'fixed_availability': 'fixedAvailability'
        }

        self._name = None
        self._management_unit_ids = None
        self._description = None
        self._activity_code_id = None
        self._type = None
        self._length_minutes = None
        self._initial_schedule_period = None
        self._group_settings = None
        self._recurrence_settings = None
        self._attendees_search_rule = None
        self._facilitated = None
        self._facilitators_search_rule = None
        self._transition_time_minutes = None
        self._service_goal_impact_overrides = None
        self._optimization_objective = None
        self._state = None
        self._counts_as_paid_time = None
        self._fixed_availability = None

    @property
    def name(self) -> str:
        """
        Gets the name of this CreateActivityPlanRequest.
        The name of the activity plan

        :return: The name of this CreateActivityPlanRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this CreateActivityPlanRequest.
        The name of the activity plan

        :param name: The name of this CreateActivityPlanRequest.
        :type: str
        """
        

        self._name = name

    @property
    def management_unit_ids(self) -> List[str]:
        """
        Gets the management_unit_ids of this CreateActivityPlanRequest.
        The management units to which this activity plan applies. Empty list or null means this activity plan applies to the entire business unit

        :return: The management_unit_ids of this CreateActivityPlanRequest.
        :rtype: list[str]
        """
        return self._management_unit_ids

    @management_unit_ids.setter
    def management_unit_ids(self, management_unit_ids: List[str]) -> None:
        """
        Sets the management_unit_ids of this CreateActivityPlanRequest.
        The management units to which this activity plan applies. Empty list or null means this activity plan applies to the entire business unit

        :param management_unit_ids: The management_unit_ids of this CreateActivityPlanRequest.
        :type: list[str]
        """
        

        self._management_unit_ids = management_unit_ids

    @property
    def description(self) -> str:
        """
        Gets the description of this CreateActivityPlanRequest.
        The description of the activity plan

        :return: The description of this CreateActivityPlanRequest.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this CreateActivityPlanRequest.
        The description of the activity plan

        :param description: The description of this CreateActivityPlanRequest.
        :type: str
        """
        

        self._description = description

    @property
    def activity_code_id(self) -> str:
        """
        Gets the activity_code_id of this CreateActivityPlanRequest.
        The activity code associated with the activity plan

        :return: The activity_code_id of this CreateActivityPlanRequest.
        :rtype: str
        """
        return self._activity_code_id

    @activity_code_id.setter
    def activity_code_id(self, activity_code_id: str) -> None:
        """
        Sets the activity_code_id of this CreateActivityPlanRequest.
        The activity code associated with the activity plan

        :param activity_code_id: The activity_code_id of this CreateActivityPlanRequest.
        :type: str
        """
        

        self._activity_code_id = activity_code_id

    @property
    def type(self) -> str:
        """
        Gets the type of this CreateActivityPlanRequest.
        The type of the activity plan

        :return: The type of this CreateActivityPlanRequest.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this CreateActivityPlanRequest.
        The type of the activity plan

        :param type: The type of this CreateActivityPlanRequest.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Individual", "Group"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def length_minutes(self) -> int:
        """
        Gets the length_minutes of this CreateActivityPlanRequest.
        The length in minutes of the activity plan

        :return: The length_minutes of this CreateActivityPlanRequest.
        :rtype: int
        """
        return self._length_minutes

    @length_minutes.setter
    def length_minutes(self, length_minutes: int) -> None:
        """
        Sets the length_minutes of this CreateActivityPlanRequest.
        The length in minutes of the activity plan

        :param length_minutes: The length_minutes of this CreateActivityPlanRequest.
        :type: int
        """
        

        self._length_minutes = length_minutes

    @property
    def initial_schedule_period(self) -> 'SchedulingPeriod':
        """
        Gets the initial_schedule_period of this CreateActivityPlanRequest.
        The initial scheduling period for the activity plan

        :return: The initial_schedule_period of this CreateActivityPlanRequest.
        :rtype: SchedulingPeriod
        """
        return self._initial_schedule_period

    @initial_schedule_period.setter
    def initial_schedule_period(self, initial_schedule_period: 'SchedulingPeriod') -> None:
        """
        Sets the initial_schedule_period of this CreateActivityPlanRequest.
        The initial scheduling period for the activity plan

        :param initial_schedule_period: The initial_schedule_period of this CreateActivityPlanRequest.
        :type: SchedulingPeriod
        """
        

        self._initial_schedule_period = initial_schedule_period

    @property
    def group_settings(self) -> 'GroupSettings':
        """
        Gets the group_settings of this CreateActivityPlanRequest.
        Group settings for the activity plan

        :return: The group_settings of this CreateActivityPlanRequest.
        :rtype: GroupSettings
        """
        return self._group_settings

    @group_settings.setter
    def group_settings(self, group_settings: 'GroupSettings') -> None:
        """
        Sets the group_settings of this CreateActivityPlanRequest.
        Group settings for the activity plan

        :param group_settings: The group_settings of this CreateActivityPlanRequest.
        :type: GroupSettings
        """
        

        self._group_settings = group_settings

    @property
    def recurrence_settings(self) -> 'RecurrenceSettings':
        """
        Gets the recurrence_settings of this CreateActivityPlanRequest.
        Settings controlling recurrence for the activity plan. If not set the activity plan will only occur once

        :return: The recurrence_settings of this CreateActivityPlanRequest.
        :rtype: RecurrenceSettings
        """
        return self._recurrence_settings

    @recurrence_settings.setter
    def recurrence_settings(self, recurrence_settings: 'RecurrenceSettings') -> None:
        """
        Sets the recurrence_settings of this CreateActivityPlanRequest.
        Settings controlling recurrence for the activity plan. If not set the activity plan will only occur once

        :param recurrence_settings: The recurrence_settings of this CreateActivityPlanRequest.
        :type: RecurrenceSettings
        """
        

        self._recurrence_settings = recurrence_settings

    @property
    def attendees_search_rule(self) -> 'UserSearchRule':
        """
        Gets the attendees_search_rule of this CreateActivityPlanRequest.
        Attendee search rule for this activity plan

        :return: The attendees_search_rule of this CreateActivityPlanRequest.
        :rtype: UserSearchRule
        """
        return self._attendees_search_rule

    @attendees_search_rule.setter
    def attendees_search_rule(self, attendees_search_rule: 'UserSearchRule') -> None:
        """
        Sets the attendees_search_rule of this CreateActivityPlanRequest.
        Attendee search rule for this activity plan

        :param attendees_search_rule: The attendees_search_rule of this CreateActivityPlanRequest.
        :type: UserSearchRule
        """
        

        self._attendees_search_rule = attendees_search_rule

    @property
    def facilitated(self) -> bool:
        """
        Gets the facilitated of this CreateActivityPlanRequest.
        Whether the sessions created by this activity plan should be facilitated

        :return: The facilitated of this CreateActivityPlanRequest.
        :rtype: bool
        """
        return self._facilitated

    @facilitated.setter
    def facilitated(self, facilitated: bool) -> None:
        """
        Sets the facilitated of this CreateActivityPlanRequest.
        Whether the sessions created by this activity plan should be facilitated

        :param facilitated: The facilitated of this CreateActivityPlanRequest.
        :type: bool
        """
        

        self._facilitated = facilitated

    @property
    def facilitators_search_rule(self) -> 'UserSearchRule':
        """
        Gets the facilitators_search_rule of this CreateActivityPlanRequest.
        Facilitator search rule for this activity plan

        :return: The facilitators_search_rule of this CreateActivityPlanRequest.
        :rtype: UserSearchRule
        """
        return self._facilitators_search_rule

    @facilitators_search_rule.setter
    def facilitators_search_rule(self, facilitators_search_rule: 'UserSearchRule') -> None:
        """
        Sets the facilitators_search_rule of this CreateActivityPlanRequest.
        Facilitator search rule for this activity plan

        :param facilitators_search_rule: The facilitators_search_rule of this CreateActivityPlanRequest.
        :type: UserSearchRule
        """
        

        self._facilitators_search_rule = facilitators_search_rule

    @property
    def transition_time_minutes(self) -> int:
        """
        Gets the transition_time_minutes of this CreateActivityPlanRequest.
        Transition time in minutes between facilitated sessions

        :return: The transition_time_minutes of this CreateActivityPlanRequest.
        :rtype: int
        """
        return self._transition_time_minutes

    @transition_time_minutes.setter
    def transition_time_minutes(self, transition_time_minutes: int) -> None:
        """
        Sets the transition_time_minutes of this CreateActivityPlanRequest.
        Transition time in minutes between facilitated sessions

        :param transition_time_minutes: The transition_time_minutes of this CreateActivityPlanRequest.
        :type: int
        """
        

        self._transition_time_minutes = transition_time_minutes

    @property
    def service_goal_impact_overrides(self) -> 'ActivityPlanServiceGoalImpactOverrides':
        """
        Gets the service_goal_impact_overrides of this CreateActivityPlanRequest.
        Allowable service goal impact override settings for this activity plan. If not set the business unit setting will be used

        :return: The service_goal_impact_overrides of this CreateActivityPlanRequest.
        :rtype: ActivityPlanServiceGoalImpactOverrides
        """
        return self._service_goal_impact_overrides

    @service_goal_impact_overrides.setter
    def service_goal_impact_overrides(self, service_goal_impact_overrides: 'ActivityPlanServiceGoalImpactOverrides') -> None:
        """
        Sets the service_goal_impact_overrides of this CreateActivityPlanRequest.
        Allowable service goal impact override settings for this activity plan. If not set the business unit setting will be used

        :param service_goal_impact_overrides: The service_goal_impact_overrides of this CreateActivityPlanRequest.
        :type: ActivityPlanServiceGoalImpactOverrides
        """
        

        self._service_goal_impact_overrides = service_goal_impact_overrides

    @property
    def optimization_objective(self) -> str:
        """
        Gets the optimization_objective of this CreateActivityPlanRequest.
        The optimization objective of this activity plan

        :return: The optimization_objective of this CreateActivityPlanRequest.
        :rtype: str
        """
        return self._optimization_objective

    @optimization_objective.setter
    def optimization_objective(self, optimization_objective: str) -> None:
        """
        Sets the optimization_objective of this CreateActivityPlanRequest.
        The optimization objective of this activity plan

        :param optimization_objective: The optimization_objective of this CreateActivityPlanRequest.
        :type: str
        """
        if isinstance(optimization_objective, int):
            optimization_objective = str(optimization_objective)
        allowed_values = ["FavorServiceGoals", "FavorSchedulingAll"]
        if optimization_objective.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for optimization_objective -> " + optimization_objective)
            self._optimization_objective = "outdated_sdk_version"
        else:
            self._optimization_objective = optimization_objective

    @property
    def state(self) -> str:
        """
        Gets the state of this CreateActivityPlanRequest.
        The state of this activity plan

        :return: The state of this CreateActivityPlanRequest.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this CreateActivityPlanRequest.
        The state of this activity plan

        :param state: The state of this CreateActivityPlanRequest.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Active", "Inactive"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def counts_as_paid_time(self) -> bool:
        """
        Gets the counts_as_paid_time of this CreateActivityPlanRequest.
        Whether the activity should count as paid time

        :return: The counts_as_paid_time of this CreateActivityPlanRequest.
        :rtype: bool
        """
        return self._counts_as_paid_time

    @counts_as_paid_time.setter
    def counts_as_paid_time(self, counts_as_paid_time: bool) -> None:
        """
        Sets the counts_as_paid_time of this CreateActivityPlanRequest.
        Whether the activity should count as paid time

        :param counts_as_paid_time: The counts_as_paid_time of this CreateActivityPlanRequest.
        :type: bool
        """
        

        self._counts_as_paid_time = counts_as_paid_time

    @property
    def fixed_availability(self) -> List['FixedAvailability']:
        """
        Gets the fixed_availability of this CreateActivityPlanRequest.
        Fixed availability configuration for the activity plan

        :return: The fixed_availability of this CreateActivityPlanRequest.
        :rtype: list[FixedAvailability]
        """
        return self._fixed_availability

    @fixed_availability.setter
    def fixed_availability(self, fixed_availability: List['FixedAvailability']) -> None:
        """
        Sets the fixed_availability of this CreateActivityPlanRequest.
        Fixed availability configuration for the activity plan

        :param fixed_availability: The fixed_availability of this CreateActivityPlanRequest.
        :type: list[FixedAvailability]
        """
        

        self._fixed_availability = fixed_availability

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

