# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class CreateCapacityPlanStaffingGroupMetricChangeRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CreateCapacityPlanStaffingGroupMetricChangeRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'number_of_weeks': 'int',
            'week_start_number': 'int',
            'value': 'float',
            'metric': 'str',
            'notes': 'str',
            'staffing_group_ids': 'list[str]',
            'version': 'int'
        }

        self.attribute_map = {
            'number_of_weeks': 'numberOfWeeks',
            'week_start_number': 'weekStartNumber',
            'value': 'value',
            'metric': 'metric',
            'notes': 'notes',
            'staffing_group_ids': 'staffingGroupIds',
            'version': 'version'
        }

        self._number_of_weeks = None
        self._week_start_number = None
        self._value = None
        self._metric = None
        self._notes = None
        self._staffing_group_ids = None
        self._version = None

    @property
    def number_of_weeks(self) -> int:
        """
        Gets the number_of_weeks of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        The number of weeks to which the metric change applies

        :return: The number_of_weeks of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        :rtype: int
        """
        return self._number_of_weeks

    @number_of_weeks.setter
    def number_of_weeks(self, number_of_weeks: int) -> None:
        """
        Sets the number_of_weeks of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        The number of weeks to which the metric change applies

        :param number_of_weeks: The number_of_weeks of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        :type: int
        """
        

        self._number_of_weeks = number_of_weeks

    @property
    def week_start_number(self) -> int:
        """
        Gets the week_start_number of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        The start number of the week (starting from 1) to which the metric change applies, related to numberOfWeeks

        :return: The week_start_number of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        :rtype: int
        """
        return self._week_start_number

    @week_start_number.setter
    def week_start_number(self, week_start_number: int) -> None:
        """
        Sets the week_start_number of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        The start number of the week (starting from 1) to which the metric change applies, related to numberOfWeeks

        :param week_start_number: The week_start_number of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        :type: int
        """
        

        self._week_start_number = week_start_number

    @property
    def value(self) -> float:
        """
        Gets the value of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        The value of the metric

        :return: The value of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        :rtype: float
        """
        return self._value

    @value.setter
    def value(self, value: float) -> None:
        """
        Sets the value of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        The value of the metric

        :param value: The value of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        :type: float
        """
        

        self._value = value

    @property
    def metric(self) -> str:
        """
        Gets the metric of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        The metric which is going to be modified for the selected staffing groups

        :return: The metric of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        :rtype: str
        """
        return self._metric

    @metric.setter
    def metric(self, metric: str) -> None:
        """
        Sets the metric of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        The metric which is going to be modified for the selected staffing groups

        :param metric: The metric of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        :type: str
        """
        if isinstance(metric, int):
            metric = str(metric)
        allowed_values = ["StartingWeeklyFullTimeEquivalentCount", "NewHiresFullTimeEquivalentCount", "AttritionPercentage", "ShrinkagePercentage"]
        if metric.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for metric -> " + metric)
            self._metric = "outdated_sdk_version"
        else:
            self._metric = metric

    @property
    def notes(self) -> str:
        """
        Gets the notes of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        Notes about the staffing groups metric changes

        :return: The notes of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes: str) -> None:
        """
        Sets the notes of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        Notes about the staffing groups metric changes

        :param notes: The notes of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        :type: str
        """
        

        self._notes = notes

    @property
    def staffing_group_ids(self) -> List[str]:
        """
        Gets the staffing_group_ids of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        The IDs of the staffing groups affected by the metric change

        :return: The staffing_group_ids of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        :rtype: list[str]
        """
        return self._staffing_group_ids

    @staffing_group_ids.setter
    def staffing_group_ids(self, staffing_group_ids: List[str]) -> None:
        """
        Sets the staffing_group_ids of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        The IDs of the staffing groups affected by the metric change

        :param staffing_group_ids: The staffing_group_ids of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        :type: list[str]
        """
        

        self._staffing_group_ids = staffing_group_ids

    @property
    def version(self) -> int:
        """
        Gets the version of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        The version of the capacity plan

        :return: The version of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        The version of the capacity plan

        :param version: The version of this CreateCapacityPlanStaffingGroupMetricChangeRequest.
        :type: int
        """
        

        self._version = version

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

