# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DecisionTableRowParameterValue

class CreateDecisionTableRowRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CreateDecisionTableRowRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'row_index': 'int',
            'inputs': 'dict(str, DecisionTableRowParameterValue)',
            'outputs': 'dict(str, DecisionTableRowParameterValue)'
        }

        self.attribute_map = {
            'row_index': 'rowIndex',
            'inputs': 'inputs',
            'outputs': 'outputs'
        }

        self._row_index = None
        self._inputs = None
        self._outputs = None

    @property
    def row_index(self) -> int:
        """
        Gets the row_index of this CreateDecisionTableRowRequest.
        The absolute position of this row in the decision table. Must be an integerstarting from 1, must be positive and less than or equal to the size of the table. If not provided row will be append to the end of the table. 

        :return: The row_index of this CreateDecisionTableRowRequest.
        :rtype: int
        """
        return self._row_index

    @row_index.setter
    def row_index(self, row_index: int) -> None:
        """
        Sets the row_index of this CreateDecisionTableRowRequest.
        The absolute position of this row in the decision table. Must be an integerstarting from 1, must be positive and less than or equal to the size of the table. If not provided row will be append to the end of the table. 

        :param row_index: The row_index of this CreateDecisionTableRowRequest.
        :type: int
        """
        

        self._row_index = row_index

    @property
    def inputs(self) -> Dict[str, 'DecisionTableRowParameterValue']:
        """
        Gets the inputs of this CreateDecisionTableRowRequest.
        The input values of the row. The key for this map is the column ID the row value relates. Column IDs are available from the decision table entity

        :return: The inputs of this CreateDecisionTableRowRequest.
        :rtype: dict(str, DecisionTableRowParameterValue)
        """
        return self._inputs

    @inputs.setter
    def inputs(self, inputs: Dict[str, 'DecisionTableRowParameterValue']) -> None:
        """
        Sets the inputs of this CreateDecisionTableRowRequest.
        The input values of the row. The key for this map is the column ID the row value relates. Column IDs are available from the decision table entity

        :param inputs: The inputs of this CreateDecisionTableRowRequest.
        :type: dict(str, DecisionTableRowParameterValue)
        """
        

        self._inputs = inputs

    @property
    def outputs(self) -> Dict[str, 'DecisionTableRowParameterValue']:
        """
        Gets the outputs of this CreateDecisionTableRowRequest.
        The output values of the row. The key for this map is the column ID the row value relates. Column IDs are available from the decision table entity

        :return: The outputs of this CreateDecisionTableRowRequest.
        :rtype: dict(str, DecisionTableRowParameterValue)
        """
        return self._outputs

    @outputs.setter
    def outputs(self, outputs: Dict[str, 'DecisionTableRowParameterValue']) -> None:
        """
        Sets the outputs of this CreateDecisionTableRowRequest.
        The output values of the row. The key for this map is the column ID the row value relates. Column IDs are available from the decision table entity

        :param outputs: The outputs of this CreateDecisionTableRowRequest.
        :type: dict(str, DecisionTableRowParameterValue)
        """
        

        self._outputs = outputs

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

