# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class CreateReprocessJobRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CreateReprocessJobRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'date_start': 'datetime',
            'date_end': 'datetime',
            'programs': 'list[str]',
            'media_types': 'list[str]',
            'dialects': 'list[str]'
        }

        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'date_start': 'dateStart',
            'date_end': 'dateEnd',
            'programs': 'programs',
            'media_types': 'mediaTypes',
            'dialects': 'dialects'
        }

        self._name = None
        self._description = None
        self._date_start = None
        self._date_end = None
        self._programs = None
        self._media_types = None
        self._dialects = None

    @property
    def name(self) -> str:
        """
        Gets the name of this CreateReprocessJobRequest.
        The name given for the job.

        :return: The name of this CreateReprocessJobRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this CreateReprocessJobRequest.
        The name given for the job.

        :param name: The name of this CreateReprocessJobRequest.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this CreateReprocessJobRequest.
        The description of the job.

        :return: The description of this CreateReprocessJobRequest.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this CreateReprocessJobRequest.
        The description of the job.

        :param description: The description of this CreateReprocessJobRequest.
        :type: str
        """
        

        self._description = description

    @property
    def date_start(self) -> datetime:
        """
        Gets the date_start of this CreateReprocessJobRequest.
        The start date for the search criteria. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_start of this CreateReprocessJobRequest.
        :rtype: datetime
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start: datetime) -> None:
        """
        Sets the date_start of this CreateReprocessJobRequest.
        The start date for the search criteria. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_start: The date_start of this CreateReprocessJobRequest.
        :type: datetime
        """
        

        self._date_start = date_start

    @property
    def date_end(self) -> datetime:
        """
        Gets the date_end of this CreateReprocessJobRequest.
        The end date for the search criteria. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_end of this CreateReprocessJobRequest.
        :rtype: datetime
        """
        return self._date_end

    @date_end.setter
    def date_end(self, date_end: datetime) -> None:
        """
        Sets the date_end of this CreateReprocessJobRequest.
        The end date for the search criteria. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_end: The date_end of this CreateReprocessJobRequest.
        :type: datetime
        """
        

        self._date_end = date_end

    @property
    def programs(self) -> List[str]:
        """
        Gets the programs of this CreateReprocessJobRequest.
        A list of program IDs to filter conversations by.

        :return: The programs of this CreateReprocessJobRequest.
        :rtype: list[str]
        """
        return self._programs

    @programs.setter
    def programs(self, programs: List[str]) -> None:
        """
        Sets the programs of this CreateReprocessJobRequest.
        A list of program IDs to filter conversations by.

        :param programs: The programs of this CreateReprocessJobRequest.
        :type: list[str]
        """
        

        self._programs = programs

    @property
    def media_types(self) -> List[str]:
        """
        Gets the media_types of this CreateReprocessJobRequest.
        The types of conversations to reprocess.

        :return: The media_types of this CreateReprocessJobRequest.
        :rtype: list[str]
        """
        return self._media_types

    @media_types.setter
    def media_types(self, media_types: List[str]) -> None:
        """
        Sets the media_types of this CreateReprocessJobRequest.
        The types of conversations to reprocess.

        :param media_types: The media_types of this CreateReprocessJobRequest.
        :type: list[str]
        """
        

        self._media_types = media_types

    @property
    def dialects(self) -> List[str]:
        """
        Gets the dialects of this CreateReprocessJobRequest.
        The dialects to filter by the conversations.

        :return: The dialects of this CreateReprocessJobRequest.
        :rtype: list[str]
        """
        return self._dialects

    @dialects.setter
    def dialects(self, dialects: List[str]) -> None:
        """
        Sets the dialects of this CreateReprocessJobRequest.
        The dialects to filter by the conversations.

        :param dialects: The dialects of this CreateReprocessJobRequest.
        :type: list[str]
        """
        

        self._dialects = dialects

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

