# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DomainEntityRef
    from . import Share

class CreateShareResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CreateShareResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'shared_entity_type': 'str',
            'shared_entity': 'DomainEntityRef',
            'member_type': 'str',
            'member': 'DomainEntityRef',
            'shared_by': 'DomainEntityRef',
            'workspace': 'DomainEntityRef',
            'succeeded': 'list[Share]',
            'failed': 'list[Share]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'shared_entity_type': 'sharedEntityType',
            'shared_entity': 'sharedEntity',
            'member_type': 'memberType',
            'member': 'member',
            'shared_by': 'sharedBy',
            'workspace': 'workspace',
            'succeeded': 'succeeded',
            'failed': 'failed',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._shared_entity_type = None
        self._shared_entity = None
        self._member_type = None
        self._member = None
        self._shared_by = None
        self._workspace = None
        self._succeeded = None
        self._failed = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this CreateShareResponse.
        The globally unique identifier for the object.

        :return: The id of this CreateShareResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this CreateShareResponse.
        The globally unique identifier for the object.

        :param id: The id of this CreateShareResponse.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this CreateShareResponse.


        :return: The name of this CreateShareResponse.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this CreateShareResponse.


        :param name: The name of this CreateShareResponse.
        :type: str
        """
        

        self._name = name

    @property
    def shared_entity_type(self) -> str:
        """
        Gets the shared_entity_type of this CreateShareResponse.


        :return: The shared_entity_type of this CreateShareResponse.
        :rtype: str
        """
        return self._shared_entity_type

    @shared_entity_type.setter
    def shared_entity_type(self, shared_entity_type: str) -> None:
        """
        Sets the shared_entity_type of this CreateShareResponse.


        :param shared_entity_type: The shared_entity_type of this CreateShareResponse.
        :type: str
        """
        if isinstance(shared_entity_type, int):
            shared_entity_type = str(shared_entity_type)
        allowed_values = ["DOCUMENT"]
        if shared_entity_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for shared_entity_type -> " + shared_entity_type)
            self._shared_entity_type = "outdated_sdk_version"
        else:
            self._shared_entity_type = shared_entity_type

    @property
    def shared_entity(self) -> 'DomainEntityRef':
        """
        Gets the shared_entity of this CreateShareResponse.


        :return: The shared_entity of this CreateShareResponse.
        :rtype: DomainEntityRef
        """
        return self._shared_entity

    @shared_entity.setter
    def shared_entity(self, shared_entity: 'DomainEntityRef') -> None:
        """
        Sets the shared_entity of this CreateShareResponse.


        :param shared_entity: The shared_entity of this CreateShareResponse.
        :type: DomainEntityRef
        """
        

        self._shared_entity = shared_entity

    @property
    def member_type(self) -> str:
        """
        Gets the member_type of this CreateShareResponse.


        :return: The member_type of this CreateShareResponse.
        :rtype: str
        """
        return self._member_type

    @member_type.setter
    def member_type(self, member_type: str) -> None:
        """
        Sets the member_type of this CreateShareResponse.


        :param member_type: The member_type of this CreateShareResponse.
        :type: str
        """
        if isinstance(member_type, int):
            member_type = str(member_type)
        allowed_values = ["USER", "GROUP", "PUBLIC"]
        if member_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for member_type -> " + member_type)
            self._member_type = "outdated_sdk_version"
        else:
            self._member_type = member_type

    @property
    def member(self) -> 'DomainEntityRef':
        """
        Gets the member of this CreateShareResponse.


        :return: The member of this CreateShareResponse.
        :rtype: DomainEntityRef
        """
        return self._member

    @member.setter
    def member(self, member: 'DomainEntityRef') -> None:
        """
        Sets the member of this CreateShareResponse.


        :param member: The member of this CreateShareResponse.
        :type: DomainEntityRef
        """
        

        self._member = member

    @property
    def shared_by(self) -> 'DomainEntityRef':
        """
        Gets the shared_by of this CreateShareResponse.


        :return: The shared_by of this CreateShareResponse.
        :rtype: DomainEntityRef
        """
        return self._shared_by

    @shared_by.setter
    def shared_by(self, shared_by: 'DomainEntityRef') -> None:
        """
        Sets the shared_by of this CreateShareResponse.


        :param shared_by: The shared_by of this CreateShareResponse.
        :type: DomainEntityRef
        """
        

        self._shared_by = shared_by

    @property
    def workspace(self) -> 'DomainEntityRef':
        """
        Gets the workspace of this CreateShareResponse.


        :return: The workspace of this CreateShareResponse.
        :rtype: DomainEntityRef
        """
        return self._workspace

    @workspace.setter
    def workspace(self, workspace: 'DomainEntityRef') -> None:
        """
        Sets the workspace of this CreateShareResponse.


        :param workspace: The workspace of this CreateShareResponse.
        :type: DomainEntityRef
        """
        

        self._workspace = workspace

    @property
    def succeeded(self) -> List['Share']:
        """
        Gets the succeeded of this CreateShareResponse.


        :return: The succeeded of this CreateShareResponse.
        :rtype: list[Share]
        """
        return self._succeeded

    @succeeded.setter
    def succeeded(self, succeeded: List['Share']) -> None:
        """
        Sets the succeeded of this CreateShareResponse.


        :param succeeded: The succeeded of this CreateShareResponse.
        :type: list[Share]
        """
        

        self._succeeded = succeeded

    @property
    def failed(self) -> List['Share']:
        """
        Gets the failed of this CreateShareResponse.


        :return: The failed of this CreateShareResponse.
        :rtype: list[Share]
        """
        return self._failed

    @failed.setter
    def failed(self, failed: List['Share']) -> None:
        """
        Sets the failed of this CreateShareResponse.


        :param failed: The failed of this CreateShareResponse.
        :type: list[Share]
        """
        

        self._failed = failed

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this CreateShareResponse.
        The URI for this object

        :return: The self_uri of this CreateShareResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this CreateShareResponse.
        The URI for this object

        :param self_uri: The self_uri of this CreateShareResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

